/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentTools;

public class MultipleAlignmentWriter {
    public static String toFASTA(MultipleAlignment alignment) {
        List<String> alnSequences = MultipleAlignmentTools.getSequenceAlignment(alignment);
        String fasta = "";
        for (int st = 0; st < alignment.size(); ++st) {
            fasta = fasta + ">" + alignment.getEnsemble().getStructureNames().get(st) + "\n" + alnSequences.get(st) + "\n";
        }
        return fasta;
    }

    public static String toFatCat(MultipleAlignment alignment) {
        StringWriter fatcat = new StringWriter();
        fatcat.append(alignment.toString() + "\n\n");
        ArrayList<Integer> mapSeqToStruct = new ArrayList<Integer>();
        List<String> alnSequences = MultipleAlignmentTools.getSequenceAlignment(alignment, mapSeqToStruct);
        String blockNumbers = "";
        for (int pos = 0; pos < alnSequences.get(0).length(); ++pos) {
            int blockNr = MultipleAlignmentTools.getBlockForSequencePosition(alignment, mapSeqToStruct, pos);
            blockNumbers = blockNr != -1 ? blockNumbers.concat("" + (blockNr + 1)) : blockNumbers.concat(" ");
        }
        for (int str = 0; str < alignment.size(); ++str) {
            if (str < 9) {
                fatcat.append("Chain 0" + (str + 1) + ": " + alnSequences.get(str) + "\n");
            } else {
                fatcat.append("Chain " + (str + 1) + ": " + alnSequences.get(str) + "\n");
            }
            if (str == alignment.size() - 1) continue;
            fatcat.append("          " + blockNumbers + "\n");
        }
        return fatcat.toString();
    }

    public static String toAlignedResidues(MultipleAlignment multAln) {
        int str;
        StringWriter residueGroup = new StringWriter();
        for (str = 0; str < multAln.size(); ++str) {
            residueGroup.append("#Struct" + (str + 1) + ":\t");
            residueGroup.append(multAln.getEnsemble().getStructureNames().get(str));
            residueGroup.append("\n");
        }
        for (str = 0; str < multAln.size(); ++str) {
            residueGroup.append("#Num" + (str + 1) + "\tChain" + (str + 1) + "\tAA" + (str + 1) + "\t");
        }
        residueGroup.append("\n");
        for (Block b : multAln.getBlocks()) {
            for (int res = 0; res < b.length(); ++res) {
                for (int str2 = 0; str2 < multAln.size(); ++str2) {
                    Integer residue = b.getAlignRes().get(str2).get(res);
                    if (residue == null) {
                        residueGroup.append("-");
                        residueGroup.append('\t');
                        residueGroup.append("-");
                        residueGroup.append('\t');
                        residueGroup.append("-");
                        residueGroup.append('\t');
                        continue;
                    }
                    Atom atom = multAln.getEnsemble().getAtomArrays().get(str2)[residue];
                    residueGroup.append(atom.getGroup().getResidueNumber().toString());
                    residueGroup.append('\t');
                    residueGroup.append(atom.getGroup().getChain().getChainID());
                    residueGroup.append('\t');
                    residueGroup.append(atom.getGroup().getPDBName());
                    residueGroup.append('\t');
                }
                residueGroup.append('\n');
            }
        }
        return residueGroup.toString();
    }

    public static String toTransformMatrices(MultipleAlignment alignment) {
        StringBuffer txt = new StringBuffer();
        for (int bs = 0; bs < alignment.getBlockSets().size(); ++bs) {
            List<Matrix4d> btransforms = alignment.getBlockSets().get(bs).getTransformations();
            if (btransforms == null || btransforms.size() < 1) continue;
            if (alignment.getBlockSets().size() > 1) {
                txt.append("Operations for block ");
                txt.append(bs + 1);
                txt.append("\n");
            }
            for (int str = 0; str < alignment.size(); ++str) {
                String origString = "ref";
                txt.append(String.format("     X" + (str + 1) + " = (%9.6f)*X" + origString + " + (%9.6f)*Y" + origString + " + (%9.6f)*Z" + origString + " + (%12.6f)", btransforms.get(str).getElement(0, 0), btransforms.get(str).getElement(0, 1), btransforms.get(str).getElement(0, 2), btransforms.get(str).getElement(0, 3)));
                txt.append("\n");
                txt.append(String.format("     Y" + (str + 1) + " = (%9.6f)*X" + origString + " + (%9.6f)*Y" + origString + " + (%9.6f)*Z" + origString + " + (%12.6f)", btransforms.get(str).getElement(1, 0), btransforms.get(str).getElement(1, 1), btransforms.get(str).getElement(1, 2), btransforms.get(str).getElement(1, 3)));
                txt.append("\n");
                txt.append(String.format("     Z" + (str + 1) + " = (%9.6f)*X" + origString + " + (%9.6f)*Y" + origString + " + (%9.6f)*Z" + origString + " + (%12.6f)", btransforms.get(str).getElement(2, 0), btransforms.get(str).getElement(2, 1), btransforms.get(str).getElement(2, 2), btransforms.get(str).getElement(2, 3)));
                txt.append("\n\n");
            }
        }
        return txt.toString();
    }
}

