/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.SVDSuperimposer;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.nbio.structure.align.xml.AFPChainXMLParser;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignmentTools {
    private static final Logger logger = LoggerFactory.getLogger(AlignmentTools.class);
    public static boolean debug = false;

    public static boolean isSequentialAlignment(AFPChain afpChain, boolean checkWithinBlocks) {
        int[][][] optAln = afpChain.getOptAln();
        int[] alnLen = afpChain.getOptLen();
        int blocks = afpChain.getBlockNum();
        if (blocks < 1) {
            return true;
        }
        if (alnLen[0] < 1) {
            return true;
        }
        if (checkWithinBlocks) {
            for (int block = 0; block < blocks; ++block) {
                if (alnLen[block] < 1) continue;
                int prevRes1 = optAln[block][0][0];
                int prevRes2 = optAln[block][1][0];
                for (int pos = 1; pos < alnLen[block]; ++pos) {
                    int currRes1 = optAln[block][0][pos];
                    int currRes2 = optAln[block][1][pos];
                    if (currRes1 < prevRes1) {
                        return false;
                    }
                    if (currRes2 < prevRes2) {
                        return false;
                    }
                    prevRes1 = currRes1;
                    prevRes2 = currRes2;
                }
            }
        }
        int prevRes1 = optAln[0][0][alnLen[0] - 1];
        int prevRes2 = optAln[0][1][alnLen[0] - 1];
        for (int block = 1; block < blocks; ++block) {
            if (alnLen[block] < 1) continue;
            if (optAln[block][0][0] < prevRes1) {
                return false;
            }
            if (optAln[block][1][0] < prevRes2) {
                return false;
            }
            prevRes1 = optAln[block][0][alnLen[block] - 1];
            prevRes2 = optAln[block][1][alnLen[block] - 1];
        }
        return true;
    }

    public static Map<Integer, Integer> alignmentAsMap(AFPChain afpChain) throws StructureException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (afpChain.getAlnLength() < 1) {
            return map;
        }
        int[][][] optAln = afpChain.getOptAln();
        int[] optLen = afpChain.getOptLen();
        for (int block = 0; block < afpChain.getBlockNum(); ++block) {
            for (int pos = 0; pos < optLen[block]; ++pos) {
                int res1 = optAln[block][0][pos];
                int res2 = optAln[block][1][pos];
                if (map.containsKey(res1)) {
                    throw new StructureException(String.format("Residue %d aligned to both %d and %d.", res1, map.get(res1), res2));
                }
                map.put(res1, res2);
            }
        }
        return map;
    }

    public static <T> Map<T, T> applyAlignment(Map<T, T> alignmentMap, int k) {
        return AlignmentTools.applyAlignment(alignmentMap, new IdentityMap(), k);
    }

    public static <S, T> Map<S, T> applyAlignment(Map<S, T> alignmentMap, Map<T, S> identity, int k) {
        Object pre;
        int i;
        if (k < 0) {
            throw new IllegalArgumentException("k must be positive");
        }
        if (k == 1) {
            return new HashMap<S, T>(alignmentMap);
        }
        ArrayList<S> preimage = new ArrayList<S>(alignmentMap.keySet());
        ArrayList<S> image = new ArrayList<S>(preimage);
        for (int n = 1; n < k; ++n) {
            for (i = 0; i < image.size(); ++i) {
                pre = image.get(i);
                Object intermediate = pre == null ? null : alignmentMap.get(pre);
                Object post = intermediate == null ? null : (Object)identity.get(intermediate);
                image.set(i, post);
            }
        }
        HashMap imageMap = new HashMap(alignmentMap.size());
        for (i = 0; i < preimage.size(); ++i) {
            pre = preimage.get(i);
            Object preK1 = image.get(i);
            Object postK = preK1 == null ? null : (Object)alignmentMap.get(preK1);
            imageMap.put(pre, postK);
        }
        return imageMap;
    }

    public static int getSymmetryOrder(Map<Integer, Integer> alignment, int maxSymmetry, float minimumMetricChange) {
        return AlignmentTools.getSymmetryOrder(alignment, new IdentityMap<Integer>(), maxSymmetry, minimumMetricChange);
    }

    public static int getSymmetryOrder(Map<Integer, Integer> alignment, Map<Integer, Integer> identity, int maxSymmetry, float minimumMetricChange) {
        ArrayList<Integer> preimage = new ArrayList<Integer>(alignment.keySet());
        ArrayList<Integer> image = new ArrayList<Integer>(preimage);
        int bestSymmetry = 1;
        double bestMetric = Double.POSITIVE_INFINITY;
        boolean foundSymmetry = false;
        if (debug) {
            logger.trace("Symm\tPos\tDelta");
        }
        for (int n = 1; n <= maxSymmetry; ++n) {
            int deltasSq = 0;
            int numDeltas = 0;
            for (int i = 0; i < image.size(); ++i) {
                Integer pre = (Integer)image.get(i);
                Integer intermediate = pre == null ? null : alignment.get(pre);
                Integer post = intermediate == null ? null : identity.get(intermediate);
                image.set(i, post);
                if (post == null) continue;
                int delta = post - (Integer)preimage.get(i);
                deltasSq += delta * delta;
                ++numDeltas;
                if (!debug) continue;
                logger.debug("%d\t%d\t%d\n", new Object[]{n, preimage.get(i), delta});
            }
            double metric = Math.sqrt((double)deltasSq / (double)numDeltas);
            if (!foundSymmetry && metric < bestMetric * (double)minimumMetricChange) {
                if (bestMetric < Double.POSITIVE_INFINITY) {
                    foundSymmetry = true;
                }
                bestSymmetry = n;
                bestMetric = metric;
            }
            if (!debug && foundSymmetry) break;
        }
        if (foundSymmetry) {
            return bestSymmetry;
        }
        return 1;
    }

    public static int getSymmetryOrder(AFPChain afpChain, int maxSymmetry, float minimumMetricChange) throws StructureException {
        Map<Integer, Integer> alignment = AlignmentTools.alignmentAsMap(afpChain);
        Map<Integer, Integer> identity = AlignmentTools.guessSequentialAlignment(alignment, true);
        return AlignmentTools.getSymmetryOrder(alignment, identity, maxSymmetry, minimumMetricChange);
    }

    public static Map<Integer, Integer> guessSequentialAlignment(Map<Integer, Integer> alignment, boolean inverseAlignment) {
        HashMap<Integer, Integer> identity = new HashMap<Integer, Integer>();
        TreeSet<Integer> aligned1 = new TreeSet<Integer>();
        TreeSet<Integer> aligned2 = new TreeSet<Integer>();
        for (Map.Entry<Integer, Integer> pair : alignment.entrySet()) {
            aligned1.add(pair.getKey());
            if (aligned2.add(pair.getValue())) continue;
            throw new IllegalArgumentException("Alignment is not one-to-one for residue " + pair.getValue() + " of the second structure.");
        }
        Iterator it1 = aligned1.iterator();
        Iterator it2 = aligned2.iterator();
        while (it1.hasNext()) {
            if (inverseAlignment) {
                identity.put((Integer)it2.next(), (Integer)it1.next());
                continue;
            }
            identity.put((Integer)it1.next(), (Integer)it2.next());
        }
        return identity;
    }

    public static List<List<List<Integer>>> getOptAlnAsList(AFPChain afpChain) {
        int[][][] optAln = afpChain.getOptAln();
        int[] optLen = afpChain.getOptLen();
        ArrayList<List<List<Integer>>> blocks = new ArrayList<List<List<Integer>>>(afpChain.getBlockNum());
        for (int blockNum = 0; blockNum < afpChain.getBlockNum(); ++blockNum) {
            ArrayList<Integer> align1 = new ArrayList<Integer>(optLen[blockNum]);
            ArrayList<Integer> align2 = new ArrayList<Integer>(optLen[blockNum]);
            for (int pos = 0; pos < optLen[blockNum]; ++pos) {
                align1.add(optAln[blockNum][0][pos]);
                align2.add(optAln[blockNum][1][pos]);
            }
            ArrayList<ArrayList<Integer>> block = new ArrayList<ArrayList<Integer>>(2);
            block.add(align1);
            block.add(align2);
            blocks.add(block);
        }
        return blocks;
    }

    public static AFPChain createAFPChain(Atom[] ca1, Atom[] ca2, ResidueNumber[] aligned1, ResidueNumber[] aligned2) throws StructureException {
        int alnLen = aligned1.length;
        if (alnLen != aligned2.length) {
            throw new IllegalArgumentException("Alignment lengths are not equal");
        }
        AFPChain a = new AFPChain();
        try {
            a.setName1(ca1[0].getGroup().getChain().getParent().getName());
            if (ca2[0].getGroup().getChain().getParent() != null) {
                a.setName2(ca2[0].getGroup().getChain().getParent().getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        a.setBlockNum(1);
        a.setCa1Length(ca1.length);
        a.setCa2Length(ca2.length);
        a.setOptLength(alnLen);
        a.setOptLen(new int[]{alnLen});
        Matrix[] ms = new Matrix[a.getBlockNum()];
        a.setBlockRotationMatrix(ms);
        Atom[] blockShiftVector = new Atom[a.getBlockNum()];
        a.setBlockShiftVector(blockShiftVector);
        String[][][] pdbAln = new String[1][2][alnLen];
        for (int i = 0; i < alnLen; ++i) {
            pdbAln[0][0][i] = aligned1[i].getChainId() + ":" + aligned1[i];
            pdbAln[0][1][i] = aligned2[i].getChainId() + ":" + aligned2[i];
        }
        a.setPdbAln(pdbAln);
        AFPChainXMLParser.rebuildAFPChain(a, ca1, ca2);
        return a;
    }

    public static AFPChain splitBlocksByTopology(AFPChain a, Atom[] ca1, Atom[] ca2) throws StructureException {
        int pos;
        int[][][] optAln = a.getOptAln();
        int blockNum = a.getBlockNum();
        int[] optLen = a.getOptLen();
        ArrayList<Integer> newBlkLen = new ArrayList<Integer>();
        boolean blockChanged = false;
        for (int blk = 0; blk < blockNum; ++blk) {
            int currLen = 1;
            for (pos = 1; pos < optLen[blk]; ++pos) {
                if (optAln[blk][0][pos] <= optAln[blk][0][pos - 1] || optAln[blk][1][pos] <= optAln[blk][1][pos - 1]) {
                    newBlkLen.add(currLen);
                    currLen = 0;
                    blockChanged = true;
                }
                ++currLen;
            }
            if (optLen[blk] < 2) {
                newBlkLen.add(optLen[blk]);
                continue;
            }
            newBlkLen.add(currLen);
        }
        if (!blockChanged) {
            return a;
        }
        ArrayList<int[][]> blocks = new ArrayList<int[][]>(newBlkLen.size());
        int oldBlk = 0;
        pos = 0;
        Iterator i$ = newBlkLen.iterator();
        while (i$.hasNext()) {
            int blkLen = (Integer)i$.next();
            if (blkLen == optLen[oldBlk]) {
                assert (pos == 0);
                blocks.add(optAln[oldBlk]);
                continue;
            }
            int[][] newBlock = new int[2][blkLen];
            assert (pos + blkLen <= optLen[oldBlk]);
            for (int i = 0; i < blkLen; ++i) {
                newBlock[0][i] = optAln[oldBlk][0][pos + i];
                newBlock[1][i] = optAln[oldBlk][1][pos + i];
            }
            blocks.add(newBlock);
            if ((pos += blkLen) != optLen[oldBlk]) continue;
            ++oldBlk;
            pos = 0;
        }
        int[][][] newOptAln = (int[][][])blocks.toArray((T[])new int[0][][]);
        int[] newBlockLens = new int[newBlkLen.size()];
        for (int i = 0; i < newBlkLen.size(); ++i) {
            newBlockLens[i] = (Integer)newBlkLen.get(i);
        }
        return AlignmentTools.replaceOptAln(a, ca1, ca2, blocks.size(), newBlockLens, newOptAln);
    }

    public static AFPChain replaceOptAln(int[][][] newAlgn, AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        int order = newAlgn.length;
        int[] optLens = new int[order];
        for (int s = 0; s < order; ++s) {
            optLens[s] = newAlgn[s][0].length;
        }
        int optLength = 0;
        for (int s = 0; s < order; ++s) {
            optLength += optLens[s];
        }
        AFPChain copyAFP = (AFPChain)afpChain.clone();
        copyAFP.setOptLength(optLength);
        copyAFP.setOptLen(optLens);
        copyAFP.setOptAln(newAlgn);
        copyAFP.setBlockNum(order);
        copyAFP.setBlockSize(optLens);
        copyAFP.setBlockResList(newAlgn);
        copyAFP.setBlockResSize(optLens);
        copyAFP.setBlockGap(AlignmentTools.calculateBlockGap(newAlgn));
        Atom[] ca2clone = StructureTools.cloneAtomArray(ca2);
        AlignmentTools.updateSuperposition(copyAFP, ca1, ca2clone);
        copyAFP.setAlnsymb(null);
        AFPAlignmentDisplay.getAlign(copyAFP, ca1, ca2clone);
        return copyAFP;
    }

    public static AFPChain replaceOptAln(AFPChain afpChain, Atom[] ca1, Atom[] ca2, Map<Integer, Integer> alignment) throws StructureException {
        Object[] res1 = alignment.keySet().toArray(new Integer[0]);
        Arrays.sort(res1);
        ArrayList<Integer> blockLens = new ArrayList<Integer>(2);
        int optLength = 0;
        Integer lastRes = alignment.get(res1[0]);
        int blkLen = lastRes == null ? 0 : 1;
        for (int i = 1; i < res1.length; ++i) {
            Integer currRes = alignment.get(res1[i]);
            assert (currRes != null);
            if (lastRes < currRes) {
                ++blkLen;
            } else {
                blockLens.add(blkLen);
                optLength += blkLen;
                blkLen = 1;
            }
            lastRes = currRes;
        }
        blockLens.add(blkLen);
        optLength += blkLen;
        int[][][] optAln = new int[blockLens.size()][][];
        int pos1 = 0;
        for (int blk = 0; blk < blockLens.size(); ++blk) {
            optAln[blk] = new int[2][];
            blkLen = (Integer)blockLens.get(blk);
            optAln[blk][0] = new int[blkLen];
            optAln[blk][1] = new int[blkLen];
            int pos = 0;
            while (pos < blkLen) {
                optAln[blk][0][pos] = (Integer)res1[pos1];
                Integer currRes = alignment.get(res1[pos1]);
                optAln[blk][1][pos] = currRes;
                ++pos;
                ++pos1;
            }
        }
        assert (pos1 == optLength);
        int[] optLens = new int[blockLens.size()];
        for (int i = 0; i < blockLens.size(); ++i) {
            optLens[i] = (Integer)blockLens.get(i);
        }
        return AlignmentTools.replaceOptAln(afpChain, ca1, ca2, blockLens.size(), optLens, optAln);
    }

    public static AFPChain replaceOptAln(AFPChain afpChain, Atom[] ca1, Atom[] ca2, int blockNum, int[] optLens, int[][][] optAln) throws StructureException {
        int optLength = 0;
        for (int blk = 0; blk < blockNum; ++blk) {
            optLength += optLens[blk];
        }
        AFPChain refinedAFP = (AFPChain)afpChain.clone();
        refinedAFP.setOptLength(optLength);
        refinedAFP.setBlockSize(optLens);
        refinedAFP.setOptLen(optLens);
        refinedAFP.setOptAln(optAln);
        refinedAFP.setBlockNum(blockNum);
        Atom[] ca2clone = StructureTools.cloneAtomArray(ca2);
        AlignmentTools.updateSuperposition(refinedAFP, ca1, ca2clone);
        AFPAlignmentDisplay.getAlign(refinedAFP, ca1, ca2clone);
        return refinedAFP;
    }

    public static void updateSuperposition(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        afpChain.setCa1Length(ca1.length);
        afpChain.setCa2Length(ca2.length);
        int[] focusRes1 = afpChain.getFocusRes1();
        int[] focusRes2 = afpChain.getFocusRes2();
        if (focusRes1 == null) {
            focusRes1 = new int[afpChain.getCa1Length()];
            afpChain.setFocusRes1(focusRes1);
        }
        if (focusRes2 == null) {
            focusRes2 = new int[afpChain.getCa2Length()];
            afpChain.setFocusRes2(focusRes2);
        }
        if (afpChain.getNrEQR() == 0) {
            return;
        }
        Atom[] ca1aligned = new Atom[afpChain.getOptLength()];
        Atom[] ca2aligned = new Atom[afpChain.getOptLength()];
        int pos = 0;
        int[] blockLens = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        assert (afpChain.getBlockNum() <= optAln.length);
        for (int block = 0; block < afpChain.getBlockNum(); ++block) {
            for (int i = 0; i < blockLens[block]; ++i) {
                int pos1 = optAln[block][0][i];
                int pos2 = optAln[block][1][i];
                Atom a1 = ca1[pos1];
                Atom a2 = (Atom)ca2[pos2].clone();
                ca1aligned[pos] = a1;
                ca2aligned[pos] = a2;
                ++pos;
            }
        }
        if (pos != afpChain.getOptLength()) {
            logger.warn("AFPChainScorer getTMScore: Problems reconstructing alignment! nr of loaded atoms is " + pos + " but should be " + afpChain.getOptLength());
            ca1aligned = (Atom[])AlignmentTools.resizeArray(ca1aligned, pos);
            ca2aligned = (Atom[])AlignmentTools.resizeArray(ca2aligned, pos);
        }
        SVDSuperimposer svd = new SVDSuperimposer(ca1aligned, ca2aligned);
        Matrix matrix = svd.getRotation();
        Atom shift = svd.getTranslation();
        Object[] blockMxs = new Matrix[afpChain.getBlockNum()];
        Arrays.fill(blockMxs, matrix);
        afpChain.setBlockRotationMatrix((Matrix[])blockMxs);
        Object[] blockShifts = new Atom[afpChain.getBlockNum()];
        Arrays.fill(blockShifts, shift);
        afpChain.setBlockShiftVector((Atom[])blockShifts);
        for (Atom a : ca2aligned) {
            Calc.rotate(a, matrix);
            Calc.shift(a, shift);
        }
        double rmsd = SVDSuperimposer.getRMS(ca1aligned, ca2aligned);
        double tmScore = SVDSuperimposer.getTMScore(ca1aligned, ca2aligned, ca1.length, ca2.length);
        afpChain.setTotalRmsdOpt(rmsd);
        afpChain.setTMScore(tmScore);
        double[] blockRMSD = new double[afpChain.getBlockNum()];
        double[] blockScore = new double[afpChain.getBlockNum()];
        for (int k = 0; k < afpChain.getBlockNum(); ++k) {
            Atom[] ca1block = new Atom[afpChain.getOptLen()[k]];
            Atom[] ca2block = new Atom[afpChain.getOptLen()[k]];
            int position = 0;
            for (int i = 0; i < blockLens[k]; ++i) {
                int pos1 = optAln[k][0][i];
                int pos2 = optAln[k][1][i];
                Atom a1 = ca1[pos1];
                Atom a2 = (Atom)ca2[pos2].clone();
                ca1block[position] = a1;
                ca2block[position] = a2;
                ++position;
            }
            if (position != afpChain.getOptLen()[k]) {
                logger.warn("AFPChainScorer getTMScore: Problems reconstructing block alignment! nr of loaded atoms is " + pos + " but should be " + afpChain.getOptLen()[k]);
                ca1block = (Atom[])AlignmentTools.resizeArray(ca1block, position);
                ca2block = (Atom[])AlignmentTools.resizeArray(ca2block, position);
            }
            SVDSuperimposer svdb = new SVDSuperimposer(ca1block, ca2block);
            Matrix matrixb = svdb.getRotation();
            Atom shiftb = svdb.getTranslation();
            for (Atom a : ca2block) {
                Calc.rotate(a, matrixb);
                Calc.shift(a, shiftb);
            }
            double rmsdb = SVDSuperimposer.getRMS(ca1block, ca2block);
            double tmScoreb = SVDSuperimposer.getTMScore(ca1block, ca2block, ca1.length, ca2.length);
            blockRMSD[k] = rmsdb;
            blockScore[k] = tmScoreb;
        }
        afpChain.setOptRmsd(blockRMSD);
        afpChain.setBlockRmsd(blockRMSD);
        afpChain.setBlockScore(blockScore);
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static <S, T> String toConciseAlignmentString(Map<S, T> alignment, Map<T, S> identity) {
        HashMap<S, T> alig = new HashMap<S, T>(alignment);
        HashMap inverse = new HashMap();
        for (Map.Entry e : alig.entrySet()) {
            List l;
            S val = identity.get(e.getValue());
            if (inverse.containsKey(val)) {
                l = (List)inverse.get(val);
                l.add(e.getKey());
                continue;
            }
            l = new ArrayList();
            l.add(e.getKey());
            inverse.put(val, l);
        }
        StringBuilder str = new StringBuilder();
        while (!alig.isEmpty()) {
            Object seedNode;
            Object node = seedNode = alig.keySet().iterator().next();
            if (inverse.containsKey(seedNode)) {
                node = ((List)inverse.get(seedNode)).iterator().next();
                while (node != seedNode && inverse.containsKey(node)) {
                    node = ((List)inverse.get(node)).iterator().next();
                }
            }
            seedNode = node;
            str.append(node);
            while (alig.containsKey(node)) {
                Object lastNode = node;
                node = identity.get(alig.get(lastNode));
                str.append('>');
                str.append(node);
                alig.remove(lastNode);
                List inv = (List)inverse.get(node);
                if (inv.size() > 1) {
                    inv.remove(node);
                    continue;
                }
                inverse.remove(node);
            }
            if (alig.isEmpty()) continue;
            str.append(' ');
        }
        return str.toString();
    }

    public static <T> String toConciseAlignmentString(Map<T, T> alignment) {
        return AlignmentTools.toConciseAlignmentString(alignment, new IdentityMap());
    }

    public static Map<Integer, Integer> fromConciseAlignmentString(String string) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        boolean matches = true;
        while (matches) {
            Pattern pattern = Pattern.compile("(\\d+)>(\\d+)");
            Matcher matcher = pattern.matcher(string);
            matches = matcher.find();
            if (!matches) continue;
            Integer from = Integer.parseInt(matcher.group(1));
            Integer to = Integer.parseInt(matcher.group(2));
            map.put(from, to);
            string = string.substring(matcher.end(1) + 1);
        }
        return map;
    }

    public static int[] calculateBlockGap(int[][][] optAln) {
        int[] blockGap = new int[optAln.length];
        for (int i = 0; i < optAln.length; ++i) {
            int gaps = 0;
            int last1 = 0;
            int last2 = 0;
            for (int j = 0; j < optAln[i][0].length; ++j) {
                if (j == 0) {
                    last1 = optAln[i][0][j];
                    last2 = optAln[i][1][j];
                    continue;
                }
                if (optAln[i][0][j] > last1 + 1 || optAln[i][1][j] > last2 + 1) {
                    ++gaps;
                    last1 = optAln[i][0][j];
                    last2 = optAln[i][1][j];
                    continue;
                }
                last1 = optAln[i][0][j];
                last2 = optAln[i][1][j];
            }
            blockGap[i] = gaps;
        }
        return blockGap;
    }

    public static class IdentityMap<K>
    extends AbstractMap<K, K> {
        @Override
        public K get(Object key) {
            return (K)key;
        }

        @Override
        public Set<Map.Entry<K, K>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }
    }
}

