/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomPositionMap;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.ResidueRangeAndLength;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.cath.CathDatabase;
import org.biojava.nbio.structure.cath.CathDomain;
import org.biojava.nbio.structure.cath.CathFactory;
import org.biojava.nbio.structure.cath.CathSegment;
import org.biojava.nbio.structure.domain.PDPProvider;
import org.biojava.nbio.structure.domain.RemotePDPProvider;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.io.util.FileDownloadUtils;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProviderFactory;
import org.biojava.nbio.structure.scop.CachedRemoteScopInstallation;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDescription;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomCache {
    private static final Logger logger = LoggerFactory.getLogger(AtomCache.class);
    public static final String BIOL_ASSEMBLY_IDENTIFIER = "BIO:";
    public static final String CHAIN_NR_SYMBOL = ":";
    public static final String CHAIN_SPLIT_SYMBOL = ".";
    public static final String PDP_DOMAIN_IDENTIFIER = "PDP:";
    public static final Pattern scopIDregex = Pattern.compile("d(....)(.)(.)");
    public static final String UNDERSCORE = "_";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected FileParsingParameters params;
    protected PDPProvider pdpprovider;
    private LocalPDBDirectory.FetchBehavior fetchBehavior;
    private LocalPDBDirectory.ObsoleteBehavior obsoleteBehavior;
    private String cachePath;
    private Collection<String> currentlyLoading = Collections.synchronizedCollection(new TreeSet());
    private String path;
    private boolean strictSCOP;
    private boolean useMmCif;

    public AtomCache() {
        this(new UserConfiguration());
    }

    public AtomCache(String pdbFilePath) {
        this(pdbFilePath, pdbFilePath);
    }

    public AtomCache(String pdbFilePath, String cachePath) {
        logger.debug("Initialising AtomCache with pdbFilePath={}, cachePath={}", (Object)pdbFilePath, (Object)cachePath);
        if (!pdbFilePath.endsWith(FILE_SEPARATOR)) {
            pdbFilePath = pdbFilePath + FILE_SEPARATOR;
        }
        System.setProperty("biojava.cache.files", "true");
        this.setPath(pdbFilePath);
        this.cachePath = cachePath;
        this.fetchBehavior = LocalPDBDirectory.FetchBehavior.DEFAULT;
        this.obsoleteBehavior = LocalPDBDirectory.ObsoleteBehavior.DEFAULT;
        this.currentlyLoading.clear();
        this.params = new FileParsingParameters();
        this.params.setAlignSeqRes(false);
        this.params.setParseSecStruc(false);
        this.strictSCOP = true;
        this.setUseMmCif(true);
    }

    @Deprecated
    public AtomCache(String pdbFilePath, boolean isSplit) {
        this(pdbFilePath);
    }

    @Deprecated
    public AtomCache(String pdbFilePath, String cachePath, boolean isSplit) {
        this(pdbFilePath, cachePath);
    }

    public AtomCache(UserConfiguration config) {
        this(config.getPdbFilePath(), config.getCacheFilePath());
        this.fetchBehavior = config.getFetchBehavior();
        this.obsoleteBehavior = config.getObsoleteBehavior();
    }

    public Atom[] getAtoms(String name) throws IOException, StructureException {
        Atom[] atoms = null;
        Structure s = this.getStructure(name);
        atoms = StructureTools.getAtomCAArray(s);
        return atoms;
    }

    public Atom[] getRepresentativeAtoms(String name) throws IOException, StructureException {
        Atom[] atoms = null;
        Structure s = this.getStructure(name);
        atoms = StructureTools.getRepresentativeAtomArray(s);
        return atoms;
    }

    public Structure getBiologicalAssembly(String pdbId, int bioAssemblyId, boolean bioAssemblyFallback) throws StructureException, IOException {
        if (bioAssemblyId < 1) {
            throw new StructureException("bioAssemblyID must be greater than zero: " + pdbId + " bioAssemblyId " + bioAssemblyId);
        }
        Structure s = StructureIO.getBiologicalAssembly(pdbId, bioAssemblyId);
        if (s == null && bioAssemblyFallback) {
            return StructureIO.getBiologicalAssembly(pdbId, 0);
        }
        return s;
    }

    public Structure getBiologicalUnit(String pdbId) throws StructureException, IOException {
        int bioAssemblyId = 1;
        boolean bioAssemblyFallback = true;
        return this.getBiologicalAssembly(pdbId, bioAssemblyId, bioAssemblyFallback);
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public FileParsingParameters getFileParsingParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }

    public PDPProvider getPdpprovider() {
        return this.pdpprovider;
    }

    public Structure getStructure(String name) throws IOException, StructureException {
        if (name.length() < 4) {
            throw new IllegalArgumentException("Can't interpret IDs that are shorter than 4 characters!");
        }
        Structure n = null;
        boolean useChainNr = false;
        boolean useDomainInfo = false;
        String range = null;
        int chainNr = -1;
        StructureName structureName = new StructureName(name);
        String pdbId = null;
        String chainId = null;
        if (name.length() == 4) {
            pdbId = name;
            Structure s = this.useMmCif ? this.loadStructureFromCifByPdbId(pdbId) : this.loadStructureFromPdbByPdbId(pdbId);
            return s;
        }
        if (structureName.isScopName()) {
            return this.getStructureFromSCOPDomain(name);
        }
        if (structureName.isCathID()) {
            return this.getStructureForCathDomain(structureName, CathFactory.getCathDatabase());
        }
        if (name.length() == 6) {
            pdbId = name.substring(0, 4);
            if (name.substring(4, 5).equals(CHAIN_SPLIT_SYMBOL)) {
                chainId = name.substring(5, 6);
            } else if (name.substring(4, 5).equals(CHAIN_NR_SYMBOL)) {
                useChainNr = true;
                chainNr = Integer.parseInt(name.substring(5, 6));
            }
        } else {
            if (name.startsWith("file:/") || name.startsWith("http:/")) {
                URL url = new URL(name);
                return this.getStructureFromURL(url);
            }
            if (structureName.isPDPDomain()) {
                return this.getPDPStructure(name);
            }
            if (name.startsWith(BIOL_ASSEMBLY_IDENTIFIER)) {
                return this.getBioAssembly(name);
            }
            if (!(name.length() <= 6 || name.startsWith(PDP_DOMAIN_IDENTIFIER) || !name.contains(CHAIN_NR_SYMBOL) && !name.contains(UNDERSCORE) || name.startsWith("file:/") || name.startsWith("http:/"))) {
                pdbId = name.substring(0, 4);
                useDomainInfo = true;
                range = name.substring(5);
            }
        }
        if (pdbId == null) {
            return null;
        }
        while (this.checkLoading(pdbId)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
        }
        Structure s = this.useMmCif ? this.loadStructureFromCifByPdbId(pdbId) : this.loadStructureFromPdbByPdbId(pdbId);
        n = chainId == null && chainNr < 0 && range == null ? StructureTools.getReducedStructure(s, -1) : (useChainNr ? StructureTools.getReducedStructure(s, chainNr) : (useDomainInfo ? StructureTools.getSubRanges(s, range) : StructureTools.getReducedStructure(s, chainId)));
        n.setName(name);
        return n;
    }

    public Structure getStructureForDomain(ScopDomain domain) throws IOException, StructureException {
        return this.getStructureForDomain(domain, ScopFactory.getSCOP());
    }

    public Structure getStructureForDomain(ScopDomain domain, ScopDatabase scopDatabase) throws IOException, StructureException {
        return this.getStructureForDomain(domain, scopDatabase, false);
    }

    public Structure getStructureForDomain(ScopDomain domain, ScopDatabase scopDatabase, boolean strictLigandHandling) throws IOException, StructureException {
        int sf;
        ScopDescription description;
        String pdbId = domain.getPdbId();
        Structure fullStructure = this.getStructure(pdbId);
        StringBuilder rangeString = new StringBuilder();
        Iterator<String> iter = domain.getRanges().iterator();
        while (iter.hasNext()) {
            rangeString.append(iter.next());
            if (!iter.hasNext()) continue;
            rangeString.append(",");
        }
        Structure structure = StructureTools.getSubRanges(fullStructure, rangeString.toString());
        structure.setName(domain.getScopId());
        structure.setPDBCode(domain.getScopId());
        AtomPositionMap map = null;
        List<ResidueRangeAndLength> rrs = null;
        if (strictLigandHandling) {
            map = new AtomPositionMap(StructureTools.getAllAtomArray(fullStructure), AtomPositionMap.ANYTHING_MATCHER);
            rrs = ResidueRangeAndLength.parseMultiple(domain.getRanges(), map);
        }
        for (Chain chain : fullStructure.getChains()) {
            if (!structure.hasChain(chain.getChainID())) continue;
            Chain newChain = structure.getChainByPDB(chain.getChainID());
            List<Group> ligands = StructureTools.filterLigands(chain.getAtomGroups());
            for (Group group : ligands) {
                boolean shouldContain = true;
                if (strictLigandHandling) {
                    shouldContain = false;
                    for (ResidueRange residueRange : rrs) {
                        if (!residueRange.contains(group.getResidueNumber(), map)) continue;
                        shouldContain = true;
                    }
                }
                boolean alreadyContains = newChain.getAtomGroups().contains(group);
                if (!shouldContain || alreadyContains) continue;
                newChain.addGroup(group);
            }
        }
        StringBuilder header = new StringBuilder();
        header.append(domain.getClassificationId());
        if (scopDatabase != null && (description = scopDatabase.getScopDescriptionBySunid(sf = domain.getSuperfamilyId())) != null) {
            header.append(" | ");
            header.append(description.getDescription());
        }
        structure.getPDBHeader().setDescription(header.toString());
        return structure;
    }

    public Structure getStructureForDomain(String scopId) throws IOException, StructureException {
        return this.getStructureForDomain(scopId, ScopFactory.getSCOP());
    }

    public Structure getStructureForDomain(String scopId, ScopDatabase scopDatabase) throws IOException, StructureException {
        ScopDomain domain = scopDatabase.getDomainByScopID(scopId);
        return this.getStructureForDomain(domain, scopDatabase);
    }

    @Deprecated
    public boolean isAutoFetch() {
        return this.fetchBehavior != LocalPDBDirectory.FetchBehavior.LOCAL_ONLY;
    }

    @Deprecated
    public boolean isFetchCurrent() {
        return this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT;
    }

    @Deprecated
    public boolean isFetchFileEvenIfObsolete() {
        return this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE;
    }

    public boolean isStrictSCOP() {
        return this.strictSCOP;
    }

    public void notifyShutdown() {
        ScopDatabase scopInstallation;
        if (this.pdpprovider != null && this.pdpprovider instanceof RemotePDPProvider) {
            RemotePDPProvider remotePDP = (RemotePDPProvider)this.pdpprovider;
            remotePDP.flushCache();
        }
        if ((scopInstallation = ScopFactory.getSCOP()) != null && scopInstallation instanceof CachedRemoteScopInstallation) {
            CachedRemoteScopInstallation cacheScop = (CachedRemoteScopInstallation)scopInstallation;
            cacheScop.flushCache();
        }
    }

    @Deprecated
    public void setAutoFetch(boolean autoFetch) {
        if (autoFetch) {
            this.setFetchBehavior(LocalPDBDirectory.FetchBehavior.DEFAULT);
        } else {
            this.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
        }
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    @Deprecated
    public void setFetchCurrent(boolean fetchNewestCurrent) {
        if (fetchNewestCurrent) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT);
        } else if (this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
        }
    }

    @Deprecated
    public void setFetchFileEvenIfObsolete(boolean fetchFileEvenIfObsolete) {
        if (fetchFileEvenIfObsolete) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE);
        } else if (this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
        }
    }

    public void setFileParsingParams(FileParsingParameters params) {
        this.params = params;
    }

    public void setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior behavior) {
        this.obsoleteBehavior = behavior;
    }

    public LocalPDBDirectory.ObsoleteBehavior getObsoleteBehavior() {
        return this.obsoleteBehavior;
    }

    public LocalPDBDirectory.FetchBehavior getFetchBehavior() {
        return this.fetchBehavior;
    }

    public void setFetchBehavior(LocalPDBDirectory.FetchBehavior fetchBehavior) {
        this.fetchBehavior = fetchBehavior;
    }

    public void setPath(String path) {
        this.path = FileDownloadUtils.expandUserHome(path);
    }

    public void setPdpprovider(PDPProvider pdpprovider) {
        this.pdpprovider = pdpprovider;
    }

    public void setStrictSCOP(boolean strictSCOP) {
        this.strictSCOP = strictSCOP;
    }

    public boolean isUseMmCif() {
        return this.useMmCif;
    }

    public void setUseMmCif(boolean useMmCif) {
        this.useMmCif = useMmCif;
        if (useMmCif) {
            BioUnitDataProviderFactory.setBioUnitDataProvider(BioUnitDataProviderFactory.mmcifProviderClassName);
        } else {
            BioUnitDataProviderFactory.setBioUnitDataProvider(BioUnitDataProviderFactory.pdbProviderClassName);
        }
    }

    private boolean checkLoading(String name) {
        return this.currentlyLoading.contains(name);
    }

    private Structure getBioAssembly(String name) throws IOException, StructureException {
        String pdbId = name.substring(4, 8);
        int biolNr = 1;
        if (name.length() > 8) {
            biolNr = Integer.parseInt(name.substring(9, name.length()));
        }
        Structure s = StructureIO.getBiologicalAssembly(pdbId, biolNr);
        return s;
    }

    private Structure getPDPStructure(String pdpDomainName) {
        if (this.pdpprovider == null) {
            this.pdpprovider = new RemotePDPProvider(true);
        }
        return this.pdpprovider.getDomain(pdpDomainName, this);
    }

    private ScopDomain getScopDomain(String scopId) {
        return ScopFactory.getSCOP().getDomainByScopID(scopId);
    }

    public Structure getStructureForCathDomain(StructureName structureName) throws IOException, StructureException {
        return this.getStructureForCathDomain(structureName, CathFactory.getCathDatabase());
    }

    public Structure getStructureForCathDomain(StructureName structureName, CathDatabase cathInstall) throws IOException, StructureException {
        CathDomain cathDomain = cathInstall.getDomainByCathId(structureName.getName());
        List<CathSegment> segments = cathDomain.getSegments();
        StringWriter range = new StringWriter();
        int rangePos = 0;
        String chainId = structureName.getChainId();
        for (CathSegment segment : segments) {
            ++rangePos;
            range.append(chainId);
            range.append(UNDERSCORE);
            range.append(segment.getStart());
            range.append("-");
            range.append(segment.getStop());
            if (segments.size() <= 1 || rangePos >= segments.size()) continue;
            range.append(",");
        }
        String pdbId = structureName.getPdbId();
        Structure s = this.getStructure(pdbId);
        String rangeS = range.toString();
        Structure n = StructureTools.getSubRanges(s, rangeS);
        Chain newChain = n.getChainByPDB(structureName.getChainId());
        Chain origChain = s.getChainByPDB(structureName.getChainId());
        List<Group> ligands = origChain.getAtomLigands();
        for (Group g : ligands) {
            if (newChain.getAtomGroups().contains(g)) continue;
            newChain.addGroup(g);
        }
        n.setName(structureName.getName());
        n.setPDBCode(structureName.getPdbId());
        n.getPDBHeader().setDescription(cathDomain.getDomainName());
        return n;
    }

    private Structure getStructureFromSCOPDomain(String name) throws IOException, StructureException {
        Matcher scopMatch;
        ScopDomain domain = this.strictSCOP ? this.getScopDomain(name) : this.guessScopDomain(name);
        if (domain != null) {
            Structure s = this.getStructureForDomain(domain);
            return s;
        }
        if (!this.strictSCOP && (scopMatch = scopIDregex.matcher(name)).matches()) {
            Structure struct;
            String pdbID = scopMatch.group(1);
            String chainID = scopMatch.group(2);
            if (!chainID.equals(UNDERSCORE)) {
                pdbID = pdbID + CHAIN_SPLIT_SYMBOL + scopMatch.group(2);
            }
            if ((struct = this.getStructure(pdbID)) != null) {
                System.err.println("Trying chain " + pdbID);
            }
            return struct;
        }
        throw new StructureException("Unable to get structure for SCOP domain: " + name);
    }

    private Structure getStructureFromURL(URL url) throws IOException, StructureException {
        System.out.println("fetching structure from URL:" + url);
        String queryS = url.getQuery();
        String chainId = null;
        String fullu = url.toString();
        if (fullu.startsWith("file:") && fullu.endsWith("?" + queryS)) {
            String newu = fullu.substring(0, fullu.length() - ("?" + queryS).length());
            url = new URL(newu);
        }
        if (queryS != null && queryS.startsWith("chainId=")) {
            chainId = queryS.substring(8);
        }
        PDBFileReader reader = new PDBFileReader(this.path);
        reader.setFetchBehavior(this.fetchBehavior);
        reader.setObsoleteBehavior(this.obsoleteBehavior);
        reader.setFileParsingParameters(this.params);
        Structure s = reader.getStructure(url);
        if (chainId == null) {
            return StructureTools.getReducedStructure(s, -1);
        }
        return StructureTools.getReducedStructure(s, chainId);
    }

    private ScopDomain guessScopDomain(String name) throws IOException, StructureException {
        Iterator match;
        LinkedList<ScopDomain> matches = new LinkedList<ScopDomain>();
        ScopDomain domain = this.getScopDomain(name);
        if (domain != null) {
            return domain;
        }
        logger.warn("Warning, could not find SCOP domain: " + name);
        Matcher scopMatch = scopIDregex.matcher(name);
        if (scopMatch.matches()) {
            String pdbID = scopMatch.group(1);
            String chainID = scopMatch.group(2);
            String domainID = scopMatch.group(3);
            for (ScopDomain potentialSCOP : ScopFactory.getSCOP().getDomainsForPDB(pdbID)) {
                Matcher potMatch = scopIDregex.matcher(potentialSCOP.getScopId());
                if (!potMatch.matches() || !chainID.equals(potMatch.group(2)) && !chainID.equals(UNDERSCORE) && !chainID.equals(CHAIN_SPLIT_SYMBOL) && !potMatch.group(2).equals(UNDERSCORE) && !potMatch.group(2).equals(CHAIN_SPLIT_SYMBOL) || !domainID.equals(potMatch.group(3)) && !domainID.equals(UNDERSCORE) && !potMatch.group(3).equals(UNDERSCORE)) continue;
                matches.add(potentialSCOP);
            }
        }
        if ((match = matches.iterator()).hasNext()) {
            ScopDomain bestMatch = (ScopDomain)match.next();
            StringBuilder warnMsg = new StringBuilder();
            warnMsg.append("Trying domain " + bestMatch.getScopId() + CHAIN_SPLIT_SYMBOL);
            if (match.hasNext()) {
                warnMsg.append(" Other possibilities: ");
                while (match.hasNext()) {
                    warnMsg.append(((ScopDomain)match.next()).getScopId() + " ");
                }
            }
            warnMsg.append(System.getProperty("line.separator"));
            logger.warn(warnMsg.toString());
            return bestMatch;
        }
        return null;
    }

    protected void flagLoading(String name) {
        if (!this.currentlyLoading.contains(name)) {
            this.currentlyLoading.add(name);
        }
    }

    protected void flagLoadingFinished(String name) {
        this.currentlyLoading.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Structure loadStructureFromCifByPdbId(String pdbId) throws IOException, StructureException {
        Structure s;
        this.flagLoading(pdbId);
        try {
            MMCIFFileReader reader = new MMCIFFileReader(this.path);
            reader.setFetchBehavior(this.fetchBehavior);
            reader.setObsoleteBehavior(this.obsoleteBehavior);
            reader.setFileParsingParameters(this.params);
            s = reader.getStructureById(pdbId.toLowerCase());
        }
        finally {
            this.flagLoadingFinished(pdbId);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Structure loadStructureFromPdbByPdbId(String pdbId) throws IOException, StructureException {
        Structure s;
        this.flagLoading(pdbId);
        try {
            PDBFileReader reader = new PDBFileReader(this.path);
            reader.setFetchBehavior(this.fetchBehavior);
            reader.setObsoleteBehavior(this.obsoleteBehavior);
            reader.setFileParsingParameters(this.params);
            s = reader.getStructureById(pdbId.toLowerCase());
        }
        finally {
            this.flagLoadingFinished(pdbId);
        }
        return s;
    }
}

