/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.cath.CathCategory;
import org.biojava.nbio.structure.cath.CathDatabase;
import org.biojava.nbio.structure.cath.CathDomain;
import org.biojava.nbio.structure.cath.CathFragment;
import org.biojava.nbio.structure.cath.CathNode;
import org.biojava.nbio.structure.cath.CathSegment;
import org.biojava.nbio.structure.io.util.FileDownloadUtils;

public class CathInstallation
implements CathDatabase {
    public static final String DEFAULT_VERSION = "3.5.0";
    String cathVersion;
    public static final String domainListFileName = "CathDomainList";
    public static final String domainDescriptionFileName = "CathDomainDescriptionFile";
    public static final String nodeListFileName = "CathNames";
    public static final String domallFileName = "CathDomall";
    public static final String CATH_DOWNLOAD = "http://release.cathdb.info/";
    String cathDownloadUrl;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String FILESPLIT = System.getProperty("file.separator");
    private String cacheLocation;
    AtomicBoolean installedDomainList;
    AtomicBoolean installedDomainDescription;
    AtomicBoolean installedNodeList;
    AtomicBoolean installedDomall;
    final boolean useCathDomainDescriptionFile;
    final boolean parseCathFragments;
    Map<String, List<CathDomain>> pdbMap;
    Map<String, CathDomain> domainMap;
    Map<String, CathNode> cathTree;
    Map<String, List<CathFragment>> fragmentMap;

    public CathInstallation(String cacheLocation, boolean usingCDDF, boolean parseCF) {
        this.setCacheLocation(cacheLocation);
        this.useCathDomainDescriptionFile = usingCDDF;
        this.parseCathFragments = parseCF;
        this.installedDomainDescription = new AtomicBoolean(false);
        this.installedDomainList = new AtomicBoolean(false);
        this.installedNodeList = new AtomicBoolean(false);
        this.installedDomall = new AtomicBoolean(false);
        this.cathVersion = DEFAULT_VERSION;
        this.cathDownloadUrl = CATH_DOWNLOAD;
        this.pdbMap = new HashMap<String, List<CathDomain>>();
        this.domainMap = new HashMap<String, CathDomain>();
        this.cathTree = new HashMap<String, CathNode>();
        if (this.parseCathFragments) {
            this.fragmentMap = new HashMap<String, List<CathFragment>>();
        }
    }

    public CathInstallation(String cacheLocation) {
        this(cacheLocation, false, false);
    }

    public CathInstallation() {
        this(new UserConfiguration().getCacheFilePath());
    }

    public String getDomainListFileName() {
        return this.cacheLocation + domainListFileName + ".v" + this.cathVersion;
    }

    public String getDomainDescriptionFileName() {
        return this.cacheLocation + domainDescriptionFileName + ".v" + this.cathVersion;
    }

    public String getNodeListFileName() {
        return this.cacheLocation + nodeListFileName + ".v" + this.cathVersion;
    }

    public String getDomallFileName() {
        return this.cacheLocation + domallFileName + ".v" + this.cathVersion;
    }

    public String getCathDownloadUrl() {
        return this.cathDownloadUrl;
    }

    public void setCathDownloadUrl(String cathDownloadUrl) {
        this.cathDownloadUrl = cathDownloadUrl;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public void setCacheLocation(String cacheLocation) {
        if (!cacheLocation.endsWith(FILESPLIT)) {
            cacheLocation = cacheLocation + FILESPLIT;
        }
        this.cacheLocation = cacheLocation;
    }

    public AtomicBoolean getInstalledDomainList() {
        return this.installedDomainList;
    }

    public void setInstalledDomainList(AtomicBoolean installedDomainList) {
        this.installedDomainList = installedDomainList;
    }

    public AtomicBoolean getInstalledDomainDescription() {
        return this.installedDomainDescription;
    }

    public void setInstalledDomainDescription(AtomicBoolean installedDomainDescription) {
        this.installedDomainDescription = installedDomainDescription;
    }

    public AtomicBoolean getInstalledNodeList() {
        return this.installedNodeList;
    }

    public AtomicBoolean getInstalledDomall() {
        return this.installedDomall;
    }

    public void setInstalledNodeList(AtomicBoolean installedNodeList) {
        this.installedNodeList = installedNodeList;
    }

    public void setInstalledDomall(AtomicBoolean installedDomall) {
        this.installedDomall = installedDomall;
    }

    @Override
    public String getCathVersion() {
        return this.cathVersion;
    }

    @Override
    public CathNode getCathNode(String nodeId) {
        this.ensureNodeListInstalled();
        return this.cathTree.get(nodeId);
    }

    @Override
    public List<CathDomain> getByCategory(CathCategory category) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        this.ensureNodeListInstalled();
        ArrayList<CathDomain> matches = new ArrayList<CathDomain>();
        for (String nodeId : this.cathTree.keySet()) {
            CathNode node = this.cathTree.get(nodeId);
            if (node.getCategory() != category) continue;
            matches.add(this.domainMap.get(node.getRepresentative()));
        }
        return matches;
    }

    @Override
    public List<CathDomain> filterByCathCode(String query) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        ArrayList<CathDomain> matches = new ArrayList<CathDomain>();
        for (String k : this.domainMap.keySet()) {
            if (!this.domainMap.get(k).getCATH().startsWith(query)) continue;
            matches.add(this.domainMap.get(k));
        }
        return matches;
    }

    @Override
    public List<CathNode> getTree(CathDomain domain) {
        CathNode node = this.getCathNode(domain.getCATH());
        ArrayList<CathNode> tree = new ArrayList<CathNode>();
        while (node != null) {
            if ((node = this.getCathNode(node.getParentId())) == null) continue;
            tree.add(node);
        }
        Collections.reverse(tree);
        return tree;
    }

    @Override
    public List<CathDomain> filterByNodeName(String query) {
        this.ensureNodeListInstalled();
        ArrayList<CathNode> matchingNodes = new ArrayList<CathNode>();
        for (String nodeId : this.cathTree.keySet()) {
            CathNode node = this.cathTree.get(nodeId);
            if (!node.getDescription().startsWith(query)) continue;
            matchingNodes.add(node);
        }
        ArrayList<CathDomain> matches = new ArrayList<CathDomain>();
        for (CathNode n : matchingNodes) {
            matches.addAll(this.getDomainsByNodeId(n.getNodeId()));
        }
        return matches;
    }

    @Override
    public List<CathDomain> filterByDescription(String query) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        ArrayList<CathDomain> matches = new ArrayList<CathDomain>();
        for (String k : this.domainMap.keySet()) {
            if (!this.domainMap.get(k).getName().startsWith(query)) continue;
            matches.add(this.domainMap.get(k));
        }
        return matches;
    }

    @Override
    public CathDomain getDescriptionByNodeId(String nodeId) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        CathNode node = this.getCathNode(nodeId);
        return this.domainMap.get(node.getRepresentative());
    }

    @Override
    public List<CathDomain> getDomainsForPdb(String pdbId) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        return this.pdbMap.get(pdbId.toLowerCase());
    }

    @Override
    public CathDomain getDomainByCathId(String cathId) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        return this.domainMap.get(cathId);
    }

    @Override
    public CathDomain getDescriptionByCathId(String cathId) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        return this.domainMap.get(cathId);
    }

    @Override
    public List<CathDomain> getDomainsByNodeId(String nodeId) {
        if (this.useCathDomainDescriptionFile) {
            this.ensureDomainDescriptionInstalled();
        } else {
            this.ensureDomallInstalled();
        }
        ArrayList<CathDomain> domains = new ArrayList<CathDomain>();
        for (String domainName : this.domainMap.keySet()) {
            CathDomain description = this.domainMap.get(domainName);
            if (!description.getCATH().startsWith(nodeId)) continue;
            domains.add(description);
        }
        return domains;
    }

    @Override
    public List<CathFragment> getFragmentsByPdbId(String pdbId) {
        if (this.useCathDomainDescriptionFile || !this.parseCathFragments) {
            return null;
        }
        this.ensureDomallInstalled();
        return this.fragmentMap.get(pdbId);
    }

    private void parseCathDomainList() throws IOException {
        File file = new File(this.getDomainListFileName());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseCathDomainList(buffer);
    }

    private void parseCathDomainList(BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            List<Object> domainList;
            if (line.startsWith("#")) continue;
            CathDomain cathDomain = this.parseCathListFileLine(line);
            String pdbId = cathDomain.getPdbIdAndChain().substring(0, 4);
            if (this.pdbMap.containsKey(pdbId)) {
                domainList = this.pdbMap.get(pdbId);
            } else {
                domainList = new ArrayList();
                this.pdbMap.put(pdbId, domainList);
            }
            domainList.add(cathDomain);
            this.domainMap.put(cathDomain.getDomainName(), cathDomain);
        }
    }

    private void parseCathNames() throws IOException {
        File file = new File(this.getNodeListFileName());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseCathNames(buffer);
    }

    private void parseCathNames(BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            CathNode cathNode = this.parseCathNamesFileLine(line);
            this.cathTree.put(cathNode.getNodeId(), cathNode);
        }
    }

    private void parseCathDomainDescriptionFile() throws IOException {
        File file = new File(this.getDomainDescriptionFileName());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseCathDomainDescriptionFile(buffer);
    }

    private void parseCathDomainDescriptionFile(BufferedReader bufferedReader) throws IOException {
        String line;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        CathDomain cathDescription = null;
        StringBuilder name = null;
        StringBuilder source = null;
        StringBuilder seqh = null;
        StringBuilder seqs = null;
        ArrayList<CathSegment> segments = null;
        CathSegment segment = null;
        StringBuilder sseqh = null;
        StringBuilder sseqs = null;
        while ((line = bufferedReader.readLine()) != null) {
            List<Object> domainList;
            if (line.startsWith("#")) continue;
            if (line.startsWith("FORMAT")) {
                cathDescription = new CathDomain();
                cathDescription.setFormat(line.substring(10));
                name = new StringBuilder();
                source = new StringBuilder();
                seqh = new StringBuilder();
                seqs = new StringBuilder();
                continue;
            }
            if (line.startsWith("DOMAIN")) {
                cathDescription.setDomainName(line.substring(10));
                continue;
            }
            if (line.startsWith("VERSION")) {
                cathDescription.setVersion(line.substring(10));
                continue;
            }
            if (line.startsWith("VERDATE")) {
                try {
                    cathDescription.setDate(dateFormat.parse(line.substring(10)));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("NAME")) {
                name.append(line.substring(10));
                continue;
            }
            if (line.startsWith("SOURCE")) {
                source.append(line.substring(10));
                continue;
            }
            if (line.startsWith("CATHCODE")) {
                cathDescription.setCATH(line.substring(10));
                continue;
            }
            if (line.startsWith("DLENGTH")) {
                cathDescription.setLength(Integer.parseInt(line.substring(10)));
                continue;
            }
            if (line.startsWith("DSEQH")) {
                seqh.append(line.substring(10));
                continue;
            }
            if (line.startsWith("DSEQS")) {
                seqs = seqs.append(line.substring(10));
                continue;
            }
            if (line.startsWith("NSEGMENTS")) {
                segments = new ArrayList<CathSegment>();
                continue;
            }
            if (line.startsWith("SEGMENT")) {
                segment = new CathSegment();
                sseqh = new StringBuilder();
                sseqs = new StringBuilder();
                continue;
            }
            if (line.startsWith("SRANGE")) {
                int startStart = line.indexOf("=", 10) + 1;
                int startStop = line.indexOf(" ", 10);
                int stopStart = line.indexOf("=", startStop) + 1;
                segment.setStart(line.substring(startStart, startStop));
                segment.setStop(line.substring(stopStart));
                continue;
            }
            if (line.startsWith("SLENGTH")) {
                segment.setLength(Integer.parseInt(line.substring(10)));
                continue;
            }
            if (line.startsWith("SSEQH")) {
                sseqh.append(line.substring(10));
                continue;
            }
            if (line.startsWith("SSEQS")) {
                sseqs.append(line.substring(10));
                continue;
            }
            if (line.startsWith("ENDSEG")) {
                segments.add(segment);
                segment.setSegmentId(segments.size());
                segment.setSequenceHeader(sseqh.toString());
                segment.setSequence(sseqs.toString());
                continue;
            }
            if (!line.startsWith("//")) continue;
            cathDescription.setName(name.toString());
            cathDescription.setSource(source.toString());
            cathDescription.setSequenceHeader(seqh.toString());
            cathDescription.setSequence(seqs.toString());
            cathDescription.setSegments(segments);
            String pdbId = cathDescription.getPdbIdAndChain().substring(0, 4);
            if (this.pdbMap.containsKey(pdbId)) {
                domainList = this.pdbMap.get(pdbId);
            } else {
                domainList = new ArrayList();
                this.pdbMap.put(pdbId, domainList);
            }
            domainList.add(cathDescription);
            this.domainMap.put(cathDescription.getDomainName(), cathDescription);
        }
    }

    private CathDomain parseCathListFileLine(String line) {
        CathDomain cathDomain = new CathDomain();
        String[] token = line.split("\\s+");
        cathDomain.setDomainName(token[0]);
        cathDomain.setClassId(Integer.parseInt(token[1]));
        cathDomain.setArchitectureId(Integer.parseInt(token[2]));
        cathDomain.setTopologyId(Integer.parseInt(token[3]));
        cathDomain.setHomologyId(Integer.parseInt(token[4]));
        cathDomain.setSequenceFamilyId(Integer.parseInt(token[5]));
        cathDomain.setOrthologousSequenceFamilyId(Integer.parseInt(token[6]));
        cathDomain.setLikeSequenceFamilyId(Integer.parseInt(token[7]));
        cathDomain.setIdenticalSequenceFamilyId(Integer.parseInt(token[8]));
        cathDomain.setDomainCounter(Integer.parseInt(token[9]));
        cathDomain.setLength(Integer.parseInt(token[10]));
        cathDomain.setResolution(Double.parseDouble(token[11]));
        return cathDomain;
    }

    private CathNode parseCathNamesFileLine(String line) {
        CathNode cathNode = new CathNode();
        String[] token = line.split("\\s+", 3);
        cathNode.setNodeId(token[0]);
        int idx = token[0].lastIndexOf(".");
        if (idx == -1) {
            idx = token[0].length();
        }
        cathNode.setParentId(token[0].substring(0, idx));
        cathNode.setRepresentative(token[1]);
        cathNode.setDescription(token[2].replace(":", ""));
        return cathNode;
    }

    private void parseCathDomall() throws IOException {
        File file = new File(this.getDomallFileName());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseCathDomall(buffer);
    }

    private void parseCathDomall(BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("#") || line.length() == 0) continue;
            String[] token = line.split("\\s+");
            String chainId = token[0];
            Integer numberOfDomains = Integer.parseInt(token[1].substring(1));
            Integer numberOfFragments = Integer.parseInt(token[2].substring(1));
            int domIdx = 3;
            for (int i = 1; i <= numberOfDomains; ++i) {
                CathDomain domain;
                String domainId;
                DecimalFormat df = new DecimalFormat("00");
                if (numberOfDomains == 1) {
                    domainId = chainId + "00";
                    domain = this.domainMap.get(domainId);
                    if (domain == null) {
                        domainId = chainId + "01";
                        domain = this.domainMap.get(domainId);
                    }
                } else {
                    domainId = chainId + df.format(i);
                    domain = this.domainMap.get(domainId);
                }
                Integer numberOfSegments = Integer.parseInt(token[domIdx]);
                if (domain == null) {
                    domIdx += 6 * numberOfSegments + 1;
                    continue;
                }
                ArrayList<CathSegment> segments = new ArrayList<CathSegment>(numberOfSegments);
                int segIdx = 1;
                for (int j = 1; j <= numberOfSegments; ++j) {
                    CathSegment segment = new CathSegment();
                    segment.setSegmentId(j);
                    Integer sstart = Integer.parseInt(token[domIdx + segIdx + 1]);
                    String sstartInsertion = token[domIdx + segIdx + 2];
                    sstartInsertion = sstartInsertion.equals("-") ? "" : sstartInsertion;
                    segment.setStart(sstart + sstartInsertion);
                    Integer sstop = Integer.parseInt(token[domIdx + segIdx + 4]);
                    String sstopInsertion = token[domIdx + segIdx + 5];
                    sstopInsertion = sstopInsertion.equals("-") ? "" : sstopInsertion;
                    segment.setStart(sstart + sstartInsertion);
                    segment.setStop(sstop + sstopInsertion);
                    segment.setLength(1 + sstop - sstart);
                    segments.add(segment);
                    segIdx += 6;
                }
                domain.setSegments(segments);
                domIdx += 6 * numberOfSegments + 1;
            }
            if (!this.parseCathFragments) continue;
            ArrayList<CathFragment> fragments = new ArrayList<CathFragment>(numberOfFragments);
            for (int i = 1; i <= numberOfFragments; ++i) {
                CathFragment fragment = new CathFragment();
                fragment.setFragmentId(i);
                Integer fstart = Integer.parseInt(token[domIdx + 1]);
                String fstartInsertion = token[domIdx + 2];
                fstartInsertion = fstartInsertion.equals("-") ? "" : fstartInsertion;
                fragment.setStart(fstart + fstartInsertion);
                Integer fstop = Integer.parseInt(token[domIdx + 4]);
                String fstopInsertion = token[domIdx + 5];
                fstopInsertion = fstopInsertion.equals("-") ? "" : fstopInsertion;
                fragment.setStop(fstop + fstopInsertion);
                Integer flength = Integer.parseInt(token[domIdx + 6].replaceAll("[^0-9]", ""));
                fragment.setLength(flength);
                fragments.add(fragment);
                domIdx += 7;
            }
            this.fragmentMap.put(chainId, fragments);
        }
    }

    protected void downloadFileFromRemote(URL remoteURL, File localFile) throws FileNotFoundException, IOException {
        int bytesRead;
        long timeS = System.currentTimeMillis();
        File tempFile = File.createTempFile(FileDownloadUtils.getFilePrefix(localFile), "." + FileDownloadUtils.getFileExtension(localFile));
        FileOutputStream out = new FileOutputStream(tempFile);
        InputStream in = remoteURL.openStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
        FileDownloadUtils.copy(tempFile, localFile);
        tempFile.delete();
        long size = localFile.length();
        double disp = (double)size / 1024.0;
        String unit = " kB";
        if (disp > 1024.0) {
            unit = " MB";
            disp /= 1024.0;
        }
        long timeE = System.currentTimeMillis();
        System.out.println("downloaded " + String.format("%.1f", disp) + unit + " in " + (timeE - timeS) / 1000L + " sec.");
    }

    private boolean domainDescriptionFileAvailable() {
        String fileName = this.getDomainDescriptionFileName();
        File f = new File(fileName);
        return f.exists();
    }

    private boolean domainListFileAvailable() {
        String fileName = this.getDomainListFileName();
        File f = new File(fileName);
        return f.exists();
    }

    private boolean nodeListFileAvailable() {
        String fileName = this.getNodeListFileName();
        File f = new File(fileName);
        return f.exists();
    }

    private boolean domallFileAvailable() {
        String fileName = this.getDomallFileName();
        File f = new File(fileName);
        return f.exists();
    }

    protected void downloadDomainListFile() throws FileNotFoundException, IOException {
        String remoteFilename = domainListFileName;
        URL url = new URL(this.cathDownloadUrl + "v" + this.cathVersion + "/" + remoteFilename);
        String localFileName = this.getDomainListFileName();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadDomainDescriptionFile() throws FileNotFoundException, IOException {
        String remoteFilename = domainDescriptionFileName;
        URL url = new URL(this.cathDownloadUrl + "v" + this.cathVersion + "/" + remoteFilename);
        String localFileName = this.getDomainDescriptionFileName();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadNodeListFile() throws FileNotFoundException, IOException {
        String remoteFilename = nodeListFileName;
        URL url = new URL(this.cathDownloadUrl + "v" + this.cathVersion + "/" + remoteFilename);
        String localFileName = this.getNodeListFileName();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    protected void downloadDomallFile() throws IOException {
        String remoteFileName = domallFileName;
        URL url = new URL(this.cathDownloadUrl + "v" + this.cathVersion + "/" + remoteFileName);
        String localFileName = this.getDomallFileName();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    public void ensureDomainListInstalled() {
        if (this.installedDomainList.get()) {
            return;
        }
        if (!this.domainListFileAvailable()) {
            try {
                this.downloadDomainListFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedDomainList.set(false);
                return;
            }
        }
        try {
            this.parseCathDomainList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedDomainList.set(false);
            return;
        }
        this.installedDomainList.set(true);
    }

    public void ensureDomainDescriptionInstalled() {
        if (this.installedDomainDescription.get()) {
            return;
        }
        if (!this.domainDescriptionFileAvailable()) {
            try {
                this.downloadDomainDescriptionFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedDomainDescription.set(false);
                return;
            }
        }
        try {
            this.parseCathDomainDescriptionFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedDomainDescription.set(false);
            return;
        }
        this.installedDomainDescription.set(true);
    }

    public void ensureNodeListInstalled() {
        if (this.installedNodeList.get()) {
            return;
        }
        if (!this.nodeListFileAvailable()) {
            try {
                this.downloadNodeListFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedNodeList.set(false);
                return;
            }
        }
        try {
            this.parseCathNames();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedNodeList.set(false);
            return;
        }
        this.installedNodeList.set(true);
    }

    public void ensureDomallInstalled() {
        this.ensureDomainListInstalled();
        if (!this.installedDomainList.get()) {
            this.installedDomall.set(false);
            return;
        }
        if (this.installedDomall.get()) {
            return;
        }
        if (!this.domallFileAvailable()) {
            try {
                this.downloadDomallFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.installedDomall.set(false);
                return;
            }
        }
        try {
            this.parseCathDomall();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.installedDomall.set(false);
            return;
        }
        this.installedDomall.set(true);
    }

    public void setCathVersion(String cathVersion) {
        this.cathVersion = cathVersion;
    }
}

