/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;

public class BondMaker {
    private static final double MAX_PEPTIDE_BOND_LENGTH = 1.8;
    private static final double MAX_NUCLEOTIDE_BOND_LENGTH = 2.1;
    private Structure structure = null;

    public BondMaker(Structure structure) {
        this.structure = structure;
    }

    public void makeBonds() {
        this.formPeptideBonds();
        this.formNucleotideBonds();
        this.formIntraResidueBonds();
        this.trimBondLists();
    }

    private void formPeptideBonds() {
        for (Chain chain : this.structure.getChains()) {
            List<Group> groups = chain.getSeqResGroups();
            for (int i = 0; i < groups.size() - 1; ++i) {
                if (!(groups.get(i) instanceof AminoAcidImpl) || !(groups.get(i + 1) instanceof AminoAcidImpl)) continue;
                AminoAcidImpl tail = (AminoAcidImpl)groups.get(i);
                AminoAcidImpl head = (AminoAcidImpl)groups.get(i + 1);
                if (tail.getResidueNumber() == null || head.getResidueNumber() == null) continue;
                Atom carboxylC = tail.getC();
                Atom aminoN = head.getN();
                if (carboxylC == null || aminoN == null || !(Calc.getDistance(carboxylC, aminoN) < 1.8)) continue;
                new Bond(carboxylC, aminoN, 1);
            }
        }
    }

    private void formNucleotideBonds() {
        for (Chain chain : this.structure.getChains()) {
            List<Group> groups = chain.getSeqResGroups();
            for (int i = 0; i < groups.size() - 1; ++i) {
                if (!(groups.get(i) instanceof NucleotideImpl) || !(groups.get(i + 1) instanceof NucleotideImpl)) continue;
                NucleotideImpl tail = (NucleotideImpl)groups.get(i);
                NucleotideImpl head = (NucleotideImpl)groups.get(i + 1);
                if (tail.getResidueNumber() == null || head.getResidueNumber() == null) continue;
                Atom phosphorous = tail.getP();
                Atom oThreePrime = head.getO3Prime();
                if (phosphorous == null || oThreePrime == null || !(Calc.getDistance(phosphorous, oThreePrime) < 2.1)) continue;
                new Bond(phosphorous, oThreePrime, 1);
            }
        }
    }

    private void formIntraResidueBonds() {
        for (Chain chain : this.structure.getChains()) {
            List<Group> groups = chain.getAtomGroups();
            for (Group group : groups) {
                if (group.getResidueNumber() == null) continue;
                ChemComp aminoChemComp = ChemCompGroupFactory.getChemComp(group.getPDBName());
                for (ChemCompBond chemCompBond : aminoChemComp.getBonds()) {
                    Atom a = group.getAtom(chemCompBond.getAtom_id_1());
                    Atom b = group.getAtom(chemCompBond.getAtom_id_2());
                    if (a == null || b == null) continue;
                    int bondOrder = chemCompBond.getNumericalBondOrder();
                    new Bond(a, b, bondOrder);
                }
            }
        }
    }

    private void trimBondLists() {
        for (Chain chain : this.structure.getChains()) {
            for (Group group : chain.getAtomGroups()) {
                for (Atom atom : group.getAtoms()) {
                    if (atom.getBonds().size() <= 0) continue;
                    ((ArrayList)atom.getBonds()).trimToSize();
                }
            }
        }
    }
}

