/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.io.mmcif.AllChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadChemCompProvider
implements ChemCompProvider {
    private static final Logger logger = LoggerFactory.getLogger(DownloadChemCompProvider.class);
    public static final String CHEM_COMP_CACHE_DIRECTORY = "chemcomp";
    public static final String SERVER_LOCATION = "http://www.rcsb.org/pdb/files/ligand/";
    private static File path;
    private static final String NEWLINE;
    static AtomicBoolean loading;
    static final List<String> protectedIDs;
    boolean downloadAll = false;

    public DownloadChemCompProvider() {
        logger.debug("Initialising DownloadChemCompProvider");
        DownloadChemCompProvider.initPath();
    }

    private static void initPath() {
        if (path == null) {
            UserConfiguration config = new UserConfiguration();
            path = new File(config.getCacheFilePath());
        }
    }

    public void checkDoFirstInstall() {
        if (!this.downloadAll) {
            return;
        }
        File dir = new File(path, CHEM_COMP_CACHE_DIRECTORY);
        File f = new File(dir, "components.cif.gz");
        if (!f.exists()) {
            this.downloadAllDefinitions();
        } else {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String file) {
                    return file.endsWith(".cif.gz");
                }
            };
            String[] files = dir.list(filter);
            if (files.length < 500) {
                this.split();
            }
        }
    }

    private void split() {
        logger.info("Installing individual chem comp files ...");
        File dir = new File(path, CHEM_COMP_CACHE_DIRECTORY);
        File f = new File(dir, "components.cif.gz");
        int counter = 0;
        InputStreamProvider prov = new InputStreamProvider();
        try {
            InputStream inStream = prov.getInputStream(f);
            BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
            String line = null;
            line = buf.readLine();
            StringWriter writer = new StringWriter();
            String currentID = null;
            while (line != null) {
                if (line.startsWith("data_")) {
                    if (currentID != null) {
                        this.writeID(writer, currentID);
                        ++counter;
                    }
                    currentID = line.substring(5);
                    writer = new StringWriter();
                }
                writer.append(line);
                writer.append(NEWLINE);
                line = buf.readLine();
            }
            this.writeID(writer, currentID);
            ++counter;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("Created " + counter + " chemical component files.");
    }

    private void writeID(StringWriter writer, String currentID) throws IOException {
        String localName = DownloadChemCompProvider.getLocalFileName(currentID);
        FileOutputStream outPut = new FileOutputStream(localName);
        GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
        PrintWriter pw = new PrintWriter(gzOutPut);
        pw.print(writer.toString());
        writer.close();
        pw.flush();
        pw.close();
        outPut.close();
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        if ((recordName = recordName.toUpperCase().trim()).equals("?")) {
            return null;
        }
        try {
            if (!DownloadChemCompProvider.fileExists(recordName)) {
                this.checkDoFirstInstall();
            }
            if (!DownloadChemCompProvider.fileExists(recordName)) {
                DownloadChemCompProvider.downloadChemCompRecord(recordName);
            }
            String filename = DownloadChemCompProvider.getLocalFileName(recordName);
            InputStreamProvider isp = new InputStreamProvider();
            InputStream inStream = isp.getInputStream(filename);
            SimpleMMcifParser parser = new SimpleMMcifParser();
            ChemCompConsumer consumer = new ChemCompConsumer();
            parser.addMMcifConsumer(consumer);
            parser.parse(new BufferedReader(new InputStreamReader(inStream)));
            ChemicalComponentDictionary dict = consumer.getDictionary();
            ChemComp chemComp = dict.getChemComp(recordName);
            return chemComp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getLocalFileName(String recordName) {
        if (protectedIDs.contains(recordName)) {
            recordName = "_" + recordName;
        }
        DownloadChemCompProvider.initPath();
        File f = new File(path, CHEM_COMP_CACHE_DIRECTORY);
        if (!f.exists()) {
            logger.info("Creating directory " + f);
            boolean success = f.mkdir();
            if (!success) {
                logger.error("Directory {} could not be created", (Object)f);
            }
        }
        File theFile = new File(f, recordName + ".cif.gz");
        return theFile.toString();
    }

    private static boolean fileExists(String recordName) {
        String fileName = DownloadChemCompProvider.getLocalFileName(recordName);
        File f = new File(fileName);
        return f.exists();
    }

    private static void downloadChemCompRecord(String recordName) {
        String localName = DownloadChemCompProvider.getLocalFileName(recordName);
        String u = SERVER_LOCATION + recordName + ".cif";
        try {
            String line;
            URL url = new URL(u);
            HttpURLConnection uconn = HTTPConnectionTools.openHttpURLConnection(url);
            InputStream conn = uconn.getInputStream();
            FileOutputStream outPut = new FileOutputStream(localName);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(conn));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.close();
            conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void downloadAllDefinitions() {
        if (loading.get()) {
            logger.info("Waiting for other thread to install chemical components...");
        }
        if (loading.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted " + e.getMessage());
            }
            logger.info("Another thread installed the chemical components.");
            return;
        }
        loading.set(true);
        long timeS = System.currentTimeMillis();
        logger.info("Performing first installation of chemical components.");
        logger.info("Downloading components.cif.gz ...");
        try {
            AllChemCompProvider.downloadFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.split();
        long timeE = System.currentTimeMillis();
        logger.info("time to install chem comp dictionary: " + (timeE - timeS) / 1000L + " sec.");
        loading.set(false);
    }

    public boolean isDownloadAll() {
        return this.downloadAll;
    }

    public void setDownloadAll(boolean downloadAll) {
        this.downloadAll = downloadAll;
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        loading = new AtomicBoolean(false);
        protectedIDs = new ArrayList<String>();
        protectedIDs.add("CON");
        protectedIDs.add("PRN");
        protectedIDs.add("AUX");
        protectedIDs.add("NUL");
    }
}

