/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.BondMaker;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.nbio.structure.io.mmcif.model.Cell;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.nbio.structure.io.mmcif.model.Entity;
import org.biojava.nbio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.nbio.structure.io.mmcif.model.Exptl;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.nbio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.io.mmcif.model.Refine;
import org.biojava.nbio.structure.io.mmcif.model.Struct;
import org.biojava.nbio.structure.io.mmcif.model.StructAsym;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.io.mmcif.model.StructKeywords;
import org.biojava.nbio.structure.io.mmcif.model.StructNcsOper;
import org.biojava.nbio.structure.io.mmcif.model.StructRef;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.nbio.structure.io.mmcif.model.Symmetry;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.biojava.nbio.structure.xtal.SymoplibParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMMcifConsumer
implements MMcifConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMMcifConsumer.class);
    private Structure structure;
    private Chain current_chain;
    private Group current_group;
    private List<Chain> current_model;
    private List<Entity> entities;
    private List<StructRef> strucRefs;
    private List<Chain> seqResChains;
    private List<Chain> entityChains;
    private List<StructAsym> structAsyms;
    private List<PdbxStructOperList> structOpers;
    private List<PdbxStructAssembly> strucAssemblies;
    private List<PdbxStructAssemblyGen> strucAssemblyGens;
    private List<EntitySrcGen> entitySrcGens;
    private List<EntitySrcNat> entitySrcNats;
    private List<EntitySrcSyn> entitySrcSyns;
    private List<StructConn> structConn;
    private List<StructNcsOper> structNcsOper;
    private Map<String, String> asymStrandId;
    private Map<String, String> asymId2StrandIdFromAtomSites;
    private Map<String, String> asymId2entityId;
    private String current_nmr_model;
    private FileParsingParameters params = new FileParsingParameters();

    public SimpleMMcifConsumer() {
        this.documentStart();
    }

    @Override
    public void newEntity(Entity entity) {
        logger.debug("New entity: {}", (Object)entity.toString());
        this.entities.add(entity);
    }

    @Override
    public void newPdbxStructOperList(PdbxStructOperList structOper) {
        this.structOpers.add(structOper);
    }

    @Override
    public void newStructAsym(StructAsym sasym) {
        this.structAsyms.add(sasym);
    }

    private Entity getEntity(int entity_id) {
        try {
            for (Entity e : this.entities) {
                int eId = Integer.parseInt(e.getId());
                if (eId != entity_id) continue;
                return e;
            }
        }
        catch (NumberFormatException e) {
            logger.warn("Entity id does not look like a number:", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public void newStructKeywords(StructKeywords kw) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setDescription(kw.getPdbx_keywords());
        header.setClassification(kw.getPdbx_keywords());
    }

    @Override
    public void setStruct(Struct struct) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setTitle(struct.getTitle());
        header.setIdCode(struct.getEntry_id());
        this.structure.setPDBHeader(header);
        this.structure.setPDBCode(struct.getEntry_id());
    }

    private Group getNewGroup(String recordName, Character aminoCode1, long seq_id, String groupCode3) {
        HetatomImpl group;
        Group g;
        if (this.params.isLoadChemCompInfo() && (g = ChemCompGroupFactory.getGroupFromChemCompDictionary(groupCode3)) != null) {
            if (g instanceof AminoAcidImpl) {
                AminoAcidImpl aa = (AminoAcidImpl)g;
                aa.setId(seq_id);
            } else if (g instanceof NucleotideImpl) {
                NucleotideImpl nuc = (NucleotideImpl)g;
                nuc.setId(seq_id);
            } else if (g instanceof HetatomImpl) {
                HetatomImpl het = (HetatomImpl)g;
                het.setId(seq_id);
            }
            return g;
        }
        if (recordName.equals("ATOM")) {
            if (StructureTools.isNucleotide(groupCode3)) {
                NucleotideImpl nu;
                group = nu = new NucleotideImpl();
                nu.setId(seq_id);
            } else if (aminoCode1 == null || aminoCode1.charValue() == 'X') {
                HetatomImpl h = new HetatomImpl();
                h.setId(seq_id);
                group = h;
            } else {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(aminoCode1);
                aa.setId(seq_id);
                group = aa;
            }
        } else if (StructureTools.isNucleotide(groupCode3)) {
            NucleotideImpl nu;
            group = nu = new NucleotideImpl();
            nu.setId(seq_id);
        } else if (aminoCode1 != null) {
            AminoAcidImpl aa = new AminoAcidImpl();
            aa.setAminoType(aminoCode1);
            aa.setId(seq_id);
            group = aa;
        } else {
            HetatomImpl h = new HetatomImpl();
            h.setId(seq_id);
            group = h;
        }
        return group;
    }

    private Chain isKnownChain(String chainID, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!chainID.equals(testchain.getChainID())) continue;
            return testchain;
        }
        return null;
    }

    @Override
    public void newAtomSite(AtomSite atom) {
        boolean startOfNewChain = false;
        String chain_id = atom.getLabel_asym_id();
        String recordName = atom.getGroup_PDB();
        String residueNumberS = atom.getAuth_seq_id();
        Integer residueNrInt = Integer.parseInt(residueNumberS);
        String groupCode3 = atom.getLabel_comp_id();
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            aminoCode1 = StructureTools.get1LetterCodeAmino(groupCode3);
        } else {
            aminoCode1 = StructureTools.get1LetterCodeAmino(groupCode3);
            if (aminoCode1 != null && aminoCode1.equals(Character.valueOf('X'))) {
                aminoCode1 = null;
            }
        }
        String insCodeS = atom.getPdbx_PDB_ins_code();
        Character insCode = null;
        if (!insCodeS.equals("?")) {
            insCode = Character.valueOf(insCodeS.charAt(0));
        }
        long seq_id = -1L;
        try {
            seq_id = Long.parseLong(atom.getLabel_seq_id());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String nmrModel = atom.getPdbx_PDB_model_num();
        if (this.current_nmr_model == null) {
            this.current_nmr_model = nmrModel;
        }
        if (!this.current_nmr_model.equals(nmrModel)) {
            this.current_nmr_model = nmrModel;
            if (this.current_chain != null) {
                this.current_chain.addGroup(this.current_group);
                this.current_group.trimToSize();
            }
            this.structure.addModel(this.current_model);
            this.current_model = new ArrayList<Chain>();
            this.current_chain = null;
            this.current_group = null;
        }
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setChainID(chain_id);
            this.current_model.add(this.current_chain);
            startOfNewChain = true;
        }
        if (!chain_id.equals(this.current_chain.getChainID())) {
            startOfNewChain = true;
            this.current_chain.addGroup(this.current_group);
            Chain testchain = this.isKnownChain(this.current_chain.getChainID(), this.current_model);
            if (testchain == null || !testchain.getChainID().equals(chain_id)) {
                testchain = this.isKnownChain(chain_id, this.current_model);
            }
            if (testchain == null) {
                this.current_chain = new ChainImpl();
                this.current_chain.setChainID(chain_id);
            } else {
                this.current_chain = testchain;
            }
            if (!this.current_model.contains(this.current_chain)) {
                this.current_model.add(this.current_chain);
            }
        }
        ResidueNumber residueNumber = new ResidueNumber(chain_id, residueNrInt, insCode);
        if (this.current_group == null) {
            this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        if (startOfNewChain) {
            this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        Group altGroup = null;
        String altLocS = atom.getLabel_alt_id();
        Character altLoc = Character.valueOf(' ');
        if (altLocS.length() > 0 && (altLoc = Character.valueOf(altLocS.charAt(0))).equals(Character.valueOf('.'))) {
            altLoc = Character.valueOf(' ');
        }
        if (!residueNumber.equals(this.current_group.getResidueNumber())) {
            this.current_chain.addGroup(this.current_group);
            this.current_group.trimToSize();
            this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.current_group.setPDBName(groupCode3);
            this.current_group.setResidueNumber(residueNumber);
        } else if (!altLoc.equals(Character.valueOf(' ')) && !altLoc.equals(Character.valueOf('.'))) {
            logger.debug("found altLoc! " + altLoc + " " + this.current_group + " " + altGroup);
            altGroup = this.getCorrectAltLocGroup(altLoc, recordName, aminoCode1, groupCode3, seq_id);
            if (altGroup.getChain() == null) {
                altGroup.setChain(this.current_chain);
            }
        }
        if (this.params.isHeaderOnly()) {
            return;
        }
        if (!(!this.params.isParseCAOnly() || atom.getLabel_atom_id().equals("CA") && atom.getType_symbol().equals("C"))) {
            return;
        }
        this.asymId2StrandIdFromAtomSites.put(atom.getLabel_asym_id(), atom.getAuth_asym_id());
        Atom a = this.convertAtom(atom);
        if (altGroup != null) {
            altGroup.addAtom(a);
            altGroup = null;
        } else {
            this.current_group.addAtom(a);
        }
        if (!this.current_group.hasAtom(a.getName())) {
            this.current_group.addAtom(a);
        }
    }

    private Atom convertAtom(AtomSite atom) {
        AtomImpl a = new AtomImpl();
        a.setPDBserial(Integer.parseInt(atom.getId()));
        a.setName(atom.getLabel_atom_id());
        double x = Double.parseDouble(atom.getCartn_x());
        double y = Double.parseDouble(atom.getCartn_y());
        double z = Double.parseDouble(atom.getCartn_z());
        a.setX(x);
        a.setY(y);
        a.setZ(z);
        double occupancy = Double.parseDouble(atom.getOccupancy());
        a.setOccupancy(occupancy);
        double temp = Double.parseDouble(atom.getB_iso_or_equiv());
        a.setTempFactor(temp);
        String alt = atom.getLabel_alt_id();
        if (alt != null && alt.length() > 0 && !alt.equals(".")) {
            a.setAltLoc(new Character(alt.charAt(0)));
        } else {
            a.setAltLoc(new Character(' '));
        }
        Element element = Element.R;
        try {
            element = Element.valueOfIgnoreCase(atom.getType_symbol());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        a.setElement(element);
        return a;
    }

    private Group getCorrectAltLocGroup(Character altLoc, String recordName, Character aminoCode1, String groupCode3, long seq_id) {
        Group altLocG;
        Atom a1;
        List<Atom> atoms = this.current_group.getAtoms();
        if (atoms.size() > 0 && (a1 = atoms.get(0)).getAltLoc().equals(altLoc)) {
            return this.current_group;
        }
        List<Group> altLocs = this.current_group.getAltLocs();
        for (Group altLocG2 : altLocs) {
            atoms = altLocG2.getAtoms();
            if (atoms.size() <= 0) continue;
            for (Atom a12 : atoms) {
                if (!a12.getAltLoc().equals(altLoc)) continue;
                return altLocG2;
            }
        }
        if (groupCode3.equals(this.current_group.getPDBName())) {
            if (this.current_group.getAtoms().size() == 0) {
                return this.current_group;
            }
            altLocG = (Group)this.current_group.clone();
            altLocG.setAtoms(new ArrayList<Atom>());
            this.current_group.addAltLoc(altLocG);
            return altLocG;
        }
        altLocG = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
        altLocG.setPDBName(groupCode3);
        altLocG.setResidueNumber(this.current_group.getResidueNumber());
        this.current_group.addAltLoc(altLocG);
        return altLocG;
    }

    @Override
    public void documentStart() {
        this.structure = new StructureImpl();
        this.current_chain = null;
        this.current_group = null;
        this.current_nmr_model = null;
        this.current_model = new ArrayList<Chain>();
        this.entities = new ArrayList<Entity>();
        this.strucRefs = new ArrayList<StructRef>();
        this.seqResChains = new ArrayList<Chain>();
        this.entityChains = new ArrayList<Chain>();
        this.structAsyms = new ArrayList<StructAsym>();
        this.asymStrandId = new HashMap<String, String>();
        this.asymId2StrandIdFromAtomSites = new HashMap<String, String>();
        this.asymId2entityId = new HashMap<String, String>();
        this.structOpers = new ArrayList<PdbxStructOperList>();
        this.strucAssemblies = new ArrayList<PdbxStructAssembly>();
        this.strucAssemblyGens = new ArrayList<PdbxStructAssemblyGen>();
        this.entitySrcGens = new ArrayList<EntitySrcGen>();
        this.entitySrcNats = new ArrayList<EntitySrcNat>();
        this.entitySrcSyns = new ArrayList<EntitySrcSyn>();
        this.structConn = new ArrayList<StructConn>();
        this.structNcsOper = new ArrayList<StructNcsOper>();
    }

    @Override
    public void documentEnd() {
        if (this.current_chain != null) {
            this.current_chain.addGroup(this.current_group);
            if (this.isKnownChain(this.current_chain.getChainID(), this.current_model) == null) {
                this.current_model.add(this.current_chain);
            }
        } else {
            logger.warn("current chain is null at end of document.");
        }
        this.structure.addModel(this.current_model);
        for (StructAsym asym : this.structAsyms) {
            logger.debug("Entity {} matches asym_id: {}", (Object)asym.getEntity_id(), (Object)asym.getId());
            this.asymId2entityId.put(asym.getId(), asym.getEntity_id());
            Chain s = this.getEntityChain(asym.getEntity_id());
            Chain seqres = (Chain)s.clone();
            seqres = this.removeSeqResHeterogeneity(seqres);
            seqres.setChainID(asym.getId());
            this.seqResChains.add(seqres);
            logger.debug(" seqres: " + asym.getId() + " " + seqres + "<");
            this.addCompounds(asym);
        }
        if (this.structAsyms.isEmpty()) {
            logger.warn("No _struct_asym category in file, no SEQRES groups will be added.");
        }
        if (this.params.isAlignSeqRes()) {
            this.alignSeqRes();
        }
        if (this.params.shouldCreateAtomBonds()) {
            this.addBonds();
        }
        boolean noAsymStrandIdMappingPresent = false;
        if (this.asymStrandId.isEmpty()) {
            logger.warn("No pdbx_poly_seq_scheme/pdbx_non_poly_seq_scheme categories present. Will use chain id mapping from _atom_sites category");
            this.asymStrandId = this.asymId2StrandIdFromAtomSites;
            noAsymStrandIdMappingPresent = true;
        }
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            Chain chain2;
            List<Chain> model = this.structure.getModel(i);
            ArrayList<Chain> pdbChains = new ArrayList<Chain>();
            block6: for (Chain chain2 : model) {
                for (String asym : this.asymStrandId.keySet()) {
                    ResidueNumber resNum;
                    if (!chain2.getChainID().equals(asym)) continue;
                    String newChainId = this.asymStrandId.get(asym);
                    logger.debug("Renaming chain with asym_id {} ({} atom groups) to author_asym_id/strand_id  {}", new Object[]{asym, chain2.getAtomGroups().size(), newChainId});
                    chain2.setChainID(newChainId);
                    chain2.setInternalChainID(asym);
                    for (Group g : chain2.getAtomGroups()) {
                        resNum = g.getResidueNumber();
                        if (resNum == null) continue;
                        resNum.setChainId(newChainId);
                    }
                    for (Group g : chain2.getSeqResGroups()) {
                        resNum = g.getResidueNumber();
                        if (resNum == null) continue;
                        resNum.setChainId(newChainId);
                    }
                    Chain known = this.isKnownChain(chain2.getChainID(), pdbChains);
                    if (known == null) {
                        pdbChains.add(chain2);
                        continue block6;
                    }
                    for (Group g : chain2.getAtomGroups()) {
                        known.addGroup(g);
                    }
                    continue block6;
                }
            }
            this.structure.setModel(i, pdbChains);
            Iterator it = pdbChains.iterator();
            while (it.hasNext()) {
                chain2 = (Chain)it.next();
                String entityId = this.asymId2entityId.get(chain2.getInternalChainID());
                if (entityId == null) {
                    logger.warn("No entity id could be found for chain {}", (Object)chain2.getInternalChainID());
                    continue;
                }
                int eId = Integer.parseInt(entityId);
                Compound compound = this.structure.getCompoundById(eId);
                if (compound == null) {
                    logger.warn("Could not find a compound for entity_id {} corresponding to chain id {} (asym id {}). Most likely it is a purely non-polymeric chain ({} groups). Removing it from this structure.", new Object[]{eId, chain2.getChainID(), chain2.getInternalChainID(), chain2.getAtomGroups().size()});
                    it.remove();
                    continue;
                }
                logger.debug("Adding chain with chain id {} (asym id {}) to compound with entity_id {}", new Object[]{chain2.getChainID(), chain2.getInternalChainID(), eId});
                compound.addChain(chain2);
                chain2.setCompound(compound);
            }
            if (!noAsymStrandIdMappingPresent) continue;
            it = pdbChains.iterator();
            while (it.hasNext()) {
                chain2 = (Chain)it.next();
                GroupType predominantGroupType = StructureTools.getPredominantGroupType(chain2);
                if (StructureTools.isChainWaterOnly(chain2)) {
                    it.remove();
                    logger.warn("Chain with chain id {} (asym id {}) and {} residues, contains only waters. Will ignore the chain because it doesn't fit into the BioJava structure data model.", new Object[]{chain2.getChainID(), chain2.getInternalChainID(), chain2.getAtomGroups().size()});
                    continue;
                }
                if (predominantGroupType == GroupType.AMINOACID || predominantGroupType == GroupType.NUCLEOTIDE) continue;
                logger.warn("Chain with chain id {} (asym id {}) and {} residues, does not seem to be polymeric. Will ignore the chain because it doesn't fit into the BioJava structure data model.", new Object[]{chain2.getChainID(), chain2.getInternalChainID(), chain2.getAtomGroups().size()});
                it.remove();
            }
        }
        List<Compound> compounds = this.structure.getCompounds();
        for (Compound compound : compounds) {
            if (!compound.getChains().isEmpty()) continue;
            logger.info("Compound {} '{}' has no chains associated to it", compound.getId() == null ? "with no entity id" : compound.getId(), (Object)compound.getMolName());
        }
        if (this.params.isParseBioAssembly()) {
            HashMap<Integer, BioAssemblyInfo> bioAssemblies = new HashMap<Integer, BioAssemblyInfo>();
            for (PdbxStructAssembly psa : this.strucAssemblies) {
                ArrayList<PdbxStructAssemblyGen> psags = new ArrayList<PdbxStructAssemblyGen>(1);
                for (PdbxStructAssemblyGen psag : this.strucAssemblyGens) {
                    if (!psag.getAssembly_id().equals(psa.getId())) continue;
                    psags.add(psag);
                }
                BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
                ArrayList<BiologicalAssemblyTransformation> transformations = builder.getBioUnitTransformationList(psa, psags, this.structOpers);
                int mmSize = 0;
                int bioAssemblyId = -1;
                try {
                    bioAssemblyId = Integer.parseInt(psa.getId());
                }
                catch (NumberFormatException e) {
                    logger.info("Could not parse a numerical bio assembly id from '{}'", (Object)psa.getId());
                }
                try {
                    mmSize = Integer.parseInt(psa.getOligomeric_count());
                }
                catch (NumberFormatException e) {
                    if (bioAssemblyId != -1) {
                        logger.warn("Could not parse oligomeric count from '{}' for biological assembly id {}", (Object)psa.getOligomeric_count(), (Object)psa.getId());
                    }
                    logger.info("Could not parse oligomeric count from '{}' for biological assembly id {}", (Object)psa.getOligomeric_count(), (Object)psa.getId());
                }
                if (bioAssemblyId == -1) continue;
                BioAssemblyInfo bioAssembly = new BioAssemblyInfo();
                bioAssembly.setId(bioAssemblyId);
                bioAssembly.setMacromolecularSize(mmSize);
                bioAssembly.setTransforms(transformations);
                bioAssemblies.put(bioAssemblyId, bioAssembly);
            }
            this.structure.getPDBHeader().setBioAssemblies(bioAssemblies);
        }
        ArrayList<Matrix4d> ncsOperators = new ArrayList<Matrix4d>();
        for (StructNcsOper sNcsOper : this.structNcsOper) {
            if (!sNcsOper.getCode().equals("generate")) continue;
            ncsOperators.add(sNcsOper.getOperator());
        }
        if (ncsOperators.size() > 0) {
            this.structure.getCrystallographicInfo().setNcsOperators(ncsOperators.toArray(new Matrix4d[ncsOperators.size()]));
        }
    }

    private Chain removeSeqResHeterogeneity(Chain c) {
        ChainImpl trimmedChain = new ChainImpl();
        ResidueNumber lastResNum = null;
        for (Group g : c.getAtomGroups()) {
            ResidueNumber currentResNum = new ResidueNumber(g.getResidueNumber().getChainId(), g.getResidueNumber().getSeqNum(), g.getResidueNumber().getInsCode());
            if (lastResNum == null || !lastResNum.equals(currentResNum)) {
                trimmedChain.addGroup(g);
            } else {
                logger.debug("Removing seqres group because it seems to be repeated in entity_poly_seq, most likely has hetero='y': " + g);
            }
            lastResNum = currentResNum;
        }
        return trimmedChain;
    }

    private void addBonds() {
        BondMaker maker = new BondMaker(this.structure);
        maker.makeBonds();
    }

    private void alignSeqRes() {
        logger.debug("Parsing mode align_seqres, will align to ATOM to SEQRES sequence");
        for (int model = 0; model < this.structure.nrModels(); ++model) {
            List<Chain> atomList = this.structure.getModel(model);
            for (Chain seqResChain : this.seqResChains) {
                Chain atomChain = SeqRes2AtomAligner.getMatchingAtomRes(seqResChain, atomList);
                if (atomChain == null) {
                    logger.warn("Could not map SEQRES chain with asym_id={} to any ATOM chain. Most likely there's no observed residues in the chain.", (Object)seqResChain.getChainID());
                    continue;
                }
                ArrayList<Group> seqResGroups = new ArrayList<Group>();
                for (int i = 0; i < seqResChain.getAtomGroups().size(); ++i) {
                    seqResGroups.add((Group)seqResChain.getAtomGroups().get(i).clone());
                }
                for (int seqResPos = 0; seqResPos < seqResGroups.size(); ++seqResPos) {
                    Group seqresG = (Group)seqResGroups.get(seqResPos);
                    boolean found = false;
                    for (Group atomG : atomChain.getAtomGroups()) {
                        int internalNr = this.getInternalNr(atomG);
                        if (seqresG.getResidueNumber().getSeqNum() != internalNr) continue;
                        seqResGroups.set(seqResPos, atomG);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    seqresG.setResidueNumber(null);
                }
                atomChain.setSeqResGroups(seqResGroups);
            }
        }
    }

    private int getInternalNr(Group atomG) {
        if (atomG.getType().equals((Object)GroupType.AMINOACID)) {
            AminoAcidImpl aa = (AminoAcidImpl)atomG;
            return new Long(aa.getId()).intValue();
        }
        if (atomG.getType().equals((Object)GroupType.NUCLEOTIDE)) {
            NucleotideImpl nu = (NucleotideImpl)atomG;
            return new Long(nu.getId()).intValue();
        }
        HetatomImpl he = (HetatomImpl)atomG;
        return new Long(he.getId()).intValue();
    }

    private void addCompounds(StructAsym asym) {
        Compound c;
        int eId = 0;
        try {
            eId = Integer.parseInt(asym.getEntity_id());
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse mol_id from string {}. Will use 0 for creating Compound", (Object)asym.getEntity_id());
        }
        Entity e = this.getEntity(eId);
        for (EntitySrcGen esg : this.entitySrcGens) {
            if (!esg.getEntity_id().equals(asym.getEntity_id()) || (c = this.structure.getCompoundById(eId)) != null || e == null || !e.getType().equals("polymer")) continue;
            c = this.createNewCompoundFromESG(esg, eId);
            c.setMolName(e.getPdbx_description());
            this.structure.addCompound(c);
            logger.debug("Adding Compound with entity id {} from _entity_src_syn, with name: {}", (Object)eId, (Object)c.getMolName());
        }
        for (EntitySrcNat esn : this.entitySrcNats) {
            if (!esn.getEntity_id().equals(asym.getEntity_id()) || (c = this.structure.getCompoundById(eId)) != null || e == null || !e.getType().equals("polymer")) continue;
            c = this.createNewCompoundFromESN(esn, eId);
            c.setMolName(e.getPdbx_description());
            this.structure.addCompound(c);
            logger.debug("Adding Compound with entity id {} from _entity_src_syn, with name: {}", (Object)eId, (Object)c.getMolName());
        }
        for (EntitySrcSyn ess : this.entitySrcSyns) {
            if (!ess.getEntity_id().equals(asym.getEntity_id()) || (c = this.structure.getCompoundById(eId)) != null || e == null || !e.getType().equals("polymer")) continue;
            c = this.createNewCompoundFromESS(ess, eId);
            c.setMolName(e.getPdbx_description());
            this.structure.addCompound(c);
            logger.debug("Adding Compound with entity id {} from _entity_src_syn, with name: {}", (Object)eId, (Object)c.getMolName());
        }
        Compound c2 = this.structure.getCompoundById(eId);
        if (c2 == null) {
            c2 = new Compound();
            c2.setMolId(eId);
            if (e != null && e.getType().equals("polymer")) {
                c2.setMolName(e.getPdbx_description());
                this.structure.addCompound(c2);
                logger.debug("Adding Compound with entity id {} from _entity, with name: {}", (Object)eId, (Object)c2.getMolName());
            }
        }
    }

    private Compound createNewCompoundFromESG(EntitySrcGen esg, int eId) {
        Compound c = new Compound();
        c.setMolId(eId);
        c.setAtcc(esg.getPdbx_gene_src_atcc());
        c.setCell(esg.getPdbx_gene_src_cell());
        c.setOrganismCommon(esg.getGene_src_common_name());
        c.setOrganismScientific(esg.getPdbx_gene_src_scientific_name());
        c.setOrganismTaxId(esg.getPdbx_gene_src_ncbi_taxonomy_id());
        c.setExpressionSystemTaxId(esg.getPdbx_host_org_ncbi_taxonomy_id());
        c.setExpressionSystem(esg.getPdbx_host_org_scientific_name());
        return c;
    }

    private Compound createNewCompoundFromESN(EntitySrcNat esn, int eId) {
        Compound c = new Compound();
        c.setMolId(eId);
        c.setAtcc(esn.getPdbx_atcc());
        c.setCell(esn.getPdbx_cell());
        c.setOrganismCommon(esn.getCommon_name());
        c.setOrganismScientific(esn.getPdbx_organism_scientific());
        c.setOrganismTaxId(esn.getPdbx_ncbi_taxonomy_id());
        return c;
    }

    private Compound createNewCompoundFromESS(EntitySrcSyn ess, int eId) {
        Compound c = new Compound();
        c.setMolId(eId);
        c.setOrganismCommon(ess.getOrganism_common_name());
        c.setOrganismScientific(ess.getOrganism_scientific());
        c.setOrganismTaxId(ess.getNcbi_taxonomy_id());
        return c;
    }

    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void newDatabasePDBrev(DatabasePDBrev dbrev) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        if (dbrev.getNum().equals("1")) {
            try {
                String date = dbrev.getDate_original();
                Date dep = dateFormat.parse(date);
                header.setDepDate(dep);
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.structure.setPDBHeader(header);
    }

    @Override
    public void newDatabasePDBremark(DatabasePDBremark remark) {
        String line;
        int i;
        String id = remark.getId();
        if (id.equals("2") && (i = (line = remark.getText()).indexOf("ANGSTROM")) > 5) {
            String resolution = line.substring(i - 5, i).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                logger.info("could not parse resolution from line and ignoring it " + line);
                return;
            }
            PDBHeader pdbHeader = this.structure.getPDBHeader();
            pdbHeader.setResolution(res);
        }
    }

    @Override
    public void newRefine(Refine r) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        if (pdbHeader.getResolution() != 99.0f) {
            logger.warn("More than 1 resolution value present, will use last one {} and discard previous {} ", (Object)r.getLs_d_res_high(), (Object)String.format("%4.2f", Float.valueOf(pdbHeader.getResolution())));
        }
        try {
            pdbHeader.setResolution(Float.parseFloat(r.getLs_d_res_high()));
        }
        catch (NumberFormatException e) {
            logger.info("Could not parse resolution from " + r.getLs_d_res_high() + " " + e.getMessage());
        }
        if (pdbHeader.getRfree() != 1.0f) {
            logger.warn("More than 1 Rfree value present, will use last one {} and discard previous {} ", (Object)r.getLs_R_factor_R_free(), (Object)String.format("%4.2f", Float.valueOf(pdbHeader.getRfree())));
        }
        if (r.getLs_R_factor_R_free() == null) {
            logger.info("_refine.ls_R_factor_R_free not present, not parsing Rfree value");
        } else {
            try {
                pdbHeader.setRfree(Float.parseFloat(r.getLs_R_factor_R_free()));
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse Rfree from string '{}'", (Object)r.getLs_R_factor_R_free());
            }
        }
    }

    @Override
    public void newAuditAuthor(AuditAuthor aa) {
        String name = aa.getName();
        StringBuffer famName = new StringBuffer();
        StringBuffer initials = new StringBuffer();
        boolean afterComma = false;
        for (char c : name.toCharArray()) {
            if (c == ' ') continue;
            if (c == ',') {
                afterComma = true;
                continue;
            }
            if (afterComma) {
                initials.append(c);
                continue;
            }
            famName.append(c);
        }
        StringBuffer newaa = new StringBuffer();
        newaa.append(initials);
        newaa.append(famName);
        PDBHeader header = this.structure.getPDBHeader();
        String auth = header.getAuthors();
        if (auth == null) {
            header.setAuthors(newaa.toString());
        } else {
            auth = auth + "," + newaa.toString();
            header.setAuthors(auth);
        }
    }

    @Override
    public void newExptl(Exptl exptl) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        String method = exptl.getMethod();
        pdbHeader.setExperimentalTechnique(method);
    }

    @Override
    public void newCell(Cell cell) {
        try {
            float a = Float.parseFloat(cell.getLength_a());
            float b = Float.parseFloat(cell.getLength_b());
            float c = Float.parseFloat(cell.getLength_c());
            float alpha = Float.parseFloat(cell.getAngle_alpha());
            float beta = Float.parseFloat(cell.getAngle_beta());
            float gamma = Float.parseFloat(cell.getAngle_gamma());
            CrystalCell xtalCell = new CrystalCell();
            xtalCell.setA(a);
            xtalCell.setB(b);
            xtalCell.setC(c);
            xtalCell.setAlpha(alpha);
            xtalCell.setBeta(beta);
            xtalCell.setGamma(gamma);
            if (!xtalCell.isCellReasonable()) {
                logger.debug("The crystal cell read from file does not have reasonable dimensions (at least one dimension is below {}), discarding it.", (Object)10.0);
                return;
            }
            this.structure.getPDBHeader().getCrystallographicInfo().setCrystalCell(xtalCell);
        }
        catch (NumberFormatException e) {
            this.structure.getPDBHeader().getCrystallographicInfo().setCrystalCell(null);
            logger.info("could not parse some cell parameters (" + e.getMessage() + "), ignoring _cell ");
        }
    }

    @Override
    public void newSymmetry(Symmetry symmetry) {
        String spaceGroup = symmetry.getSpace_group_name_H_M();
        SpaceGroup sg = SymoplibParser.getSpaceGroup(spaceGroup);
        if (sg == null) {
            logger.warn("Space group '" + spaceGroup + "' not recognised as a standard space group");
        }
        this.structure.getPDBHeader().getCrystallographicInfo().setSpaceGroup(sg);
    }

    @Override
    public void newStructNcsOper(StructNcsOper sNcsOper) {
        this.structNcsOper.add(sNcsOper);
    }

    @Override
    public void newStructRef(StructRef sref) {
        logger.debug(sref.toString());
        this.strucRefs.add(sref);
    }

    private StructRef getStructRef(String ref_id) {
        for (StructRef structRef : this.strucRefs) {
            if (!structRef.getId().equals(ref_id)) continue;
            return structRef;
        }
        return null;
    }

    @Override
    public void newStructRefSeq(StructRefSeq sref) {
        DBRef r = new DBRef();
        r.setIdCode(sref.getPdbx_PDB_id_code());
        r.setDbAccession(sref.getPdbx_db_accession());
        r.setDbIdCode(sref.getPdbx_db_accession());
        r.setChainId(sref.getPdbx_strand_id());
        StructRef structRef = this.getStructRef(sref.getRef_id());
        if (structRef == null) {
            logger.warn("could not find StructRef " + sref.getRef_id() + " for StructRefSeq " + sref);
        } else {
            r.setDatabase(structRef.getDb_name());
            r.setDbIdCode(structRef.getDb_code());
        }
        int seqbegin = Integer.parseInt(sref.getPdbx_auth_seq_align_beg());
        int seqend = Integer.parseInt(sref.getPdbx_auth_seq_align_end());
        Character begin_ins_code = new Character(sref.getPdbx_seq_align_beg_ins_code().charAt(0));
        Character end_ins_code = new Character(sref.getPdbx_seq_align_end_ins_code().charAt(0));
        if (begin_ins_code.charValue() == '?') {
            begin_ins_code = Character.valueOf(' ');
        }
        if (end_ins_code.charValue() == '?') {
            end_ins_code = Character.valueOf(' ');
        }
        r.setSeqBegin(seqbegin);
        r.setInsertBegin(begin_ins_code.charValue());
        r.setSeqEnd(seqend);
        r.setInsertEnd(end_ins_code.charValue());
        int dbseqbegin = Integer.parseInt(sref.getDb_align_beg());
        int dbseqend = Integer.parseInt(sref.getDb_align_end());
        Character db_begin_in_code = new Character(sref.getPdbx_db_align_beg_ins_code().charAt(0));
        Character db_end_in_code = new Character(sref.getPdbx_db_align_end_ins_code().charAt(0));
        if (db_begin_in_code.charValue() == '?') {
            db_begin_in_code = Character.valueOf(' ');
        }
        if (db_end_in_code.charValue() == '?') {
            db_end_in_code = Character.valueOf(' ');
        }
        r.setDbSeqBegin(dbseqbegin);
        r.setIdbnsBegin(db_begin_in_code.charValue());
        r.setDbSeqEnd(dbseqend);
        r.setIdbnsEnd(db_end_in_code.charValue());
        List<DBRef> dbrefs = this.structure.getDBRefs();
        if (dbrefs == null) {
            dbrefs = new ArrayList<DBRef>();
        }
        dbrefs.add(r);
        logger.debug(r.toPDB());
        this.structure.setDBRefs(dbrefs);
    }

    private static Chain getChainFromList(List<Chain> chains, String name) {
        for (Chain chain : chains) {
            if (!chain.getChainID().equals(name)) continue;
            return chain;
        }
        ChainImpl chain = new ChainImpl();
        chain.setChainID(name);
        chains.add(chain);
        return chain;
    }

    private Chain getEntityChain(String entity_id) {
        return SimpleMMcifConsumer.getChainFromList(this.entityChains, entity_id);
    }

    @Override
    public void newEntitySrcGen(EntitySrcGen entitySrcGen) {
        this.entitySrcGens.add(entitySrcGen);
    }

    @Override
    public void newEntitySrcNat(EntitySrcNat entitySrcNat) {
        this.entitySrcNats.add(entitySrcNat);
    }

    @Override
    public void newEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
        this.entitySrcSyns.add(entitySrcSyn);
    }

    @Override
    public void newEntityPolySeq(EntityPolySeq epolseq) {
        logger.debug("NEW entity poly seq " + epolseq);
        int eId = -1;
        try {
            eId = Integer.parseInt(epolseq.getEntity_id());
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse entity id from EntityPolySeq: " + e.getMessage());
        }
        Entity e = this.getEntity(eId);
        if (e == null) {
            logger.info("Could not find entity " + epolseq.getEntity_id() + ". Can not match sequence to it.");
            return;
        }
        Chain entityChain = this.getEntityChain(epolseq.getEntity_id());
        if (epolseq.getMon_id().length() == 3 && StructureTools.get1LetterCodeAmino(epolseq.getMon_id()) != null) {
            AminoAcidImpl g = new AminoAcidImpl();
            g.setRecordType("SEQRES");
            g.setPDBName(epolseq.getMon_id());
            Character code1 = StructureTools.get1LetterCodeAmino(epolseq.getMon_id());
            g.setAminoType(code1);
            g.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
            entityChain.addGroup(g);
        } else if (StructureTools.isNucleotide(epolseq.getMon_id())) {
            NucleotideImpl n = new NucleotideImpl();
            n.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
            n.setPDBName(epolseq.getMon_id());
            entityChain.addGroup(n);
        } else {
            logger.debug("Residue {} {} is not a standard aminoacid or nucleotide, will create a het group for it", (Object)epolseq.getNum(), (Object)epolseq.getMon_id());
            HetatomImpl h = new HetatomImpl();
            h.setPDBName(epolseq.getMon_id());
            h.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
            entityChain.addGroup(h);
        }
    }

    private List<Chain> getChainsFromAllModels(String chainId) {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            for (Chain c : model) {
                if (!c.getChainID().equals(chainId)) continue;
                chains.add(c);
            }
        }
        return chains;
    }

    private void replaceGroupSeqPos(PdbxPolySeqScheme ppss) {
        if (ppss.getAuth_seq_num().equals("?")) {
            return;
        }
        List<Chain> matchinChains = this.getChainsFromAllModels(ppss.getAsym_id());
        long sid = Long.parseLong(ppss.getSeq_id());
        for (Chain c : matchinChains) {
            Group target = null;
            for (Group g : c.getAtomGroups()) {
                HetatomImpl h;
                if (g instanceof AminoAcidImpl) {
                    AminoAcidImpl aa = (AminoAcidImpl)g;
                    if (aa.getId() != sid) continue;
                    target = g;
                    break;
                }
                if (g instanceof NucleotideImpl) {
                    NucleotideImpl n = (NucleotideImpl)g;
                    if (n.getId() != sid) continue;
                    target = g;
                    break;
                }
                if (!(g instanceof HetatomImpl) || (h = (HetatomImpl)g).getId() != sid) continue;
                target = h;
                break;
            }
            if (target == null) {
                logger.info("could not find group at seq. position " + ppss.getSeq_id() + " in internal chain " + c.getChainID() + ". " + ppss);
                continue;
            }
            if (!target.getPDBName().trim().equals(ppss.getMon_id())) {
                logger.info("could not match PdbxPolySeqScheme to chain:" + target.getPDBName() + " " + ppss);
                continue;
            }
            Integer pdbResNum = Integer.parseInt(ppss.getAuth_seq_num());
            String insCodeS = ppss.getPdb_ins_code();
            Character insCode = null;
            if (insCodeS != null && !insCodeS.equals(".") && insCodeS.length() > 0) {
                insCode = Character.valueOf(insCodeS.charAt(0));
            }
            ResidueNumber residueNumber = new ResidueNumber(null, pdbResNum, insCode);
            target.setResidueNumber(residueNumber);
        }
    }

    @Override
    public void newPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
        this.replaceGroupSeqPos(ppss);
        if (this.asymStrandId.containsKey(ppss.getAsym_id())) {
            return;
        }
        if (ppss.getPdb_strand_id() == null) {
            this.asymStrandId.put(ppss.getAsym_id(), ppss.getAuth_mon_id());
            return;
        }
        this.asymStrandId.put(ppss.getAsym_id(), ppss.getPdb_strand_id());
    }

    @Override
    public void newPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
        if (this.asymStrandId.containsKey(ppss.getAsym_id())) {
            return;
        }
        if (ppss.getPdb_strand_id() == null) {
            this.asymStrandId.put(ppss.getAsym_id(), ppss.getAsym_id());
            return;
        }
        this.asymStrandId.put(ppss.getAsym_id(), ppss.getPdb_strand_id());
    }

    @Override
    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
    }

    @Override
    public void newChemComp(ChemComp c) {
    }

    @Override
    public void newGenericData(String category, List<String> loopFields, List<String> lineData) {
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public void newChemCompDescriptor(ChemCompDescriptor ccd) {
    }

    public List<PdbxStructOperList> getStructOpers() {
        return this.structOpers;
    }

    @Override
    public void newPdbxStrucAssembly(PdbxStructAssembly strucAssembly) {
        this.strucAssemblies.add(strucAssembly);
    }

    public List<PdbxStructAssembly> getStructAssemblies() {
        return this.strucAssemblies;
    }

    @Override
    public void newPdbxStrucAssemblyGen(PdbxStructAssemblyGen strucAssembly) {
        this.strucAssemblyGens.add(strucAssembly);
    }

    public List<PdbxStructAssemblyGen> getStructAssemblyGens() {
        return this.strucAssemblyGens;
    }

    @Override
    public void newChemCompAtom(ChemCompAtom atom) {
    }

    @Override
    public void newPdbxChemCompIndentifier(PdbxChemCompIdentifier id) {
    }

    @Override
    public void newChemCompBond(ChemCompBond bond) {
    }

    @Override
    public void newPdbxChemCompDescriptor(PdbxChemCompDescriptor desc) {
    }

    @Override
    public void newStructConn(StructConn structConn) {
        this.structConn.add(structConn);
    }
}

