/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary.io;

import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.MmCifBiolAssemblyProvider;
import org.biojava.nbio.structure.quaternary.io.PDBBioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.RemoteBioUnitDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioUnitDataProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(BioUnitDataProviderFactory.class);
    public static final String mmcifProviderClassName = MmCifBiolAssemblyProvider.class.getName();
    public static final String remoteProviderClassName = RemoteBioUnitDataProvider.class.getName();
    public static final String pdbProviderClassName = PDBBioUnitDataProvider.class.getName();
    public static String DEFAULT_PROVIDER_CLASSNAME;
    private static String providerClassName;

    private BioUnitDataProviderFactory() {
    }

    public static BioUnitDataProvider getBioUnitDataProvider() {
        try {
            Class<?> cls = Class.forName(providerClassName);
            return (BioUnitDataProvider)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception caught", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Exception caught", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("Exception caught", (Throwable)e);
        }
        return null;
    }

    public static void setBioUnitDataProvider(String className) {
        try {
            Class<?> cls = Class.forName(providerClassName);
            Class<?> interfaceClass = Class.forName(BioUnitDataProvider.class.getName());
            Class<?>[] ifs = cls.getInterfaces();
            boolean found = false;
            for (Class<?> c : ifs) {
                if (!c.equals(interfaceClass)) continue;
                found = true;
                break;
            }
            if (!found) {
                logger.warn("The provided class {} does not implement the correct interface!", (Object)className);
                return;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception caught", (Throwable)e);
            return;
        }
        providerClassName = className;
    }

    static {
        providerClassName = DEFAULT_PROVIDER_CLASSNAME = mmcifProviderClassName;
    }
}

