/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.AbstractUserArgumentProcessor;
import org.biojava.nbio.structure.align.ce.CECPParameters;
import org.biojava.nbio.structure.align.ce.CeMain;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.ce.StartupParameters;

public class CeUserArgumentProcessor
extends AbstractUserArgumentProcessor {
    @Override
    protected StartupParameters getStartupParametersInstance() {
        return new CeStartupParams();
    }

    @Override
    public StructureAlignment getAlgorithm() {
        return new CeMain();
    }

    @Override
    public Object getParameters() {
        StructureAlignment alignment = this.getAlgorithm();
        CeParameters aligParams = (CeParameters)alignment.getParameters();
        CeStartupParams startParams = (CeStartupParams)this.params;
        if (aligParams == null) {
            aligParams = new CECPParameters();
        }
        aligParams.setMaxGapSize(startParams.getMaxGapSize());
        aligParams.setWinSize(startParams.getWinSize());
        aligParams.setScoringStrategy(startParams.getScoringStrategy());
        aligParams.setMaxOptRMSD(startParams.getMaxOptRMSD());
        aligParams.setGapOpen(startParams.getGapOpen());
        aligParams.setGapExtension(startParams.getGapExtension());
        aligParams.setShowAFPRanges(startParams.isShowAFPRanges());
        return aligParams;
    }

    @Override
    public String getDbSearchLegend() {
        return "# name1\tname2\tscore\tz-score\trmsd\tlen1\tlen2\tcov1\tcov2\t%ID\tDescription\t ";
    }

    protected static class CeStartupParams
    extends StartupParameters {
        protected int maxGapSize = 30;
        protected int winSize = 8;
        protected CeParameters.ScoringStrategy scoringStrategy = CeParameters.ScoringStrategy.DEFAULT_SCORING_STRATEGY;
        protected double maxOptRMSD = 99.0;
        protected double gapOpen = 5.0;
        protected double gapExtension = 0.5;
        protected boolean showAFPRanges = false;

        public int getWinSize() {
            return this.winSize;
        }

        public void setWinSize(int winSize) {
            this.winSize = winSize;
        }

        public CeParameters.ScoringStrategy getScoringStrategy() {
            return this.scoringStrategy;
        }

        public void setScoringStrategy(CeParameters.ScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
        }

        public double getGapOpen() {
            return this.gapOpen;
        }

        public void setGapOpen(double gapOpen) {
            this.gapOpen = gapOpen;
        }

        public double getGapExtension() {
            return this.gapExtension;
        }

        public void setGapExtension(double gapExtension) {
            this.gapExtension = gapExtension;
        }

        public int getMaxGapSize() {
            return this.maxGapSize;
        }

        public void setMaxGapSize(int maxGapSize) {
            this.maxGapSize = maxGapSize;
        }

        public boolean isShowAFPRanges() {
            return this.showAFPRanges;
        }

        public void setShowAFPRanges(boolean showAFP) {
            this.showAFPRanges = showAFP;
        }

        public Double getMaxOptRMSD() {
            return this.maxOptRMSD;
        }

        public void setMaxOptRMSD(Double maxOptRMSD) {
            this.maxOptRMSD = maxOptRMSD;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CeStartupParams [maxGapSize=").append(this.maxGapSize).append(", winSize=").append(this.winSize).append(", scoringStrategy=").append((Object)this.scoringStrategy).append(", maxOptRMSD=").append(this.maxOptRMSD).append(", gapOpen=").append(this.gapOpen).append(", gapExtension=").append(this.gapExtension).append(", showAFPRanges=").append(this.showAFPRanges).append(", pdbFilePath=").append(this.pdbFilePath).append(", cacheFilePath=").append(this.cacheFilePath).append(", outFile=").append(this.outFile).append(", pdb1=").append(this.pdb1).append(", pdb2=").append(this.pdb2).append(", file1=").append(this.file1).append(", file2=").append(this.file2).append(", showDBresult=").append(this.showDBresult).append(", printXML=").append(this.printXML).append(", printFatCat=").append(this.printFatCat).append(", show3d=").append(this.show3d).append(", autoFetch=").append(this.autoFetch).append(", printCE=").append(this.printCE).append(", showMenu=").append(this.showMenu).append(", printPDB=").append(this.printPDB).append(", isDomainSplit=").append(this.isDomainSplit).append(", alignPairs=").append(this.alignPairs).append(", searchFile=").append(this.searchFile).append(", saveOutputDir=").append(this.saveOutputDir).append(", nrCPU=").append(this.nrCPU).append("]");
            return builder.toString();
        }
    }
}

