/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cath;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.cath.CathDatabase;
import org.biojava.nbio.structure.cath.CathInstallation;

public class CathFactory {
    public static final String VERSION_3_5_0 = "3.5.0";
    public static final String LATEST_VERSION = "3.5.0";
    public static String DEFAULT_VERSION = "3.5.0";
    private static CathDatabase cath;
    private static Map<String, CathDatabase> versions;

    public static void setCath(CathDatabase cath) {
        CathFactory.cath = cath;
    }

    public static CathDatabase getCathDatabase() {
        if (cath == null) {
            cath = new CathInstallation();
        }
        return cath;
    }

    private CathFactory() {
    }

    public static CathDatabase getCathDatabase(String version) {
        CathDatabase cath;
        if (version == null) {
            version = DEFAULT_VERSION;
        }
        if ((cath = versions.get(version)) == null) {
            CathInstallation newCath = new CathInstallation();
            newCath.setCathVersion(version);
            cath = newCath;
        }
        return cath;
    }

    static {
        versions = new HashMap<String, CathDatabase>();
    }
}

