/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.symmetry.core.PairwiseAlignment;
import org.biojava.nbio.structure.symmetry.core.ProteinSequenceClusterer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.SequenceAlignmentCluster;
import org.biojava.nbio.structure.symmetry.core.UniqueSequenceList;

public class ClusterMerger {
    private List<SequenceAlignmentCluster> clusters = null;
    private QuatSymmetryParameters parameters = null;
    List<PairwiseAlignment> pairwiseAlignments = Collections.emptyList();

    public ClusterMerger(List<SequenceAlignmentCluster> clusters, QuatSymmetryParameters parameters) {
        this.clusters = clusters;
        this.parameters = parameters;
    }

    public void calcPairwiseAlignments() {
        this.pairwiseAlignments = new ArrayList<PairwiseAlignment>();
        boolean[] merged = new boolean[this.clusters.size()];
        Arrays.fill(merged, false);
        int n = this.clusters.size();
        for (int i = 0; i < n - 1; ++i) {
            if (merged[i]) continue;
            SequenceAlignmentCluster c1 = this.clusters.get(i);
            for (int j = i + 1; j < n; ++j) {
                SequenceAlignmentCluster c2 = this.clusters.get(j);
                PairwiseAlignment alignment = c1.getPairwiseAlignment(c2);
                if (alignment == null || !(alignment.getAlignmentLengthFraction() >= this.parameters.getAlignmentFractionThreshold()) || !(alignment.getRmsd() <= this.parameters.getRmsdThreshold())) continue;
                merged[j] = true;
                this.pairwiseAlignments.add(alignment);
                if (!this.parameters.isVerbose()) continue;
                System.out.println("ClusterMerger: pairwise cluster alignment: " + i + "-" + j + " seq. identity: " + alignment.getSequenceIdentity());
                System.out.println(alignment);
            }
        }
    }

    public List<SequenceAlignmentCluster> getMergedClusters(double sequenceIdentityCutoff) {
        ArrayList<SequenceAlignmentCluster> mergedClusters = new ArrayList<SequenceAlignmentCluster>();
        Map<SequenceAlignmentCluster, Integer> map = this.getClusterMap();
        boolean[] processed = new boolean[this.clusters.size()];
        Arrays.fill(processed, false);
        int n = this.clusters.size();
        for (int i = 0; i < n; ++i) {
            SequenceAlignmentCluster cluster = this.clusters.get(i);
            SequenceAlignmentCluster clone = null;
            if (!processed[i]) {
                clone = (SequenceAlignmentCluster)cluster.clone();
                mergedClusters.add(clone);
                processed[i] = true;
            }
            for (PairwiseAlignment alignment : this.pairwiseAlignments) {
                if (alignment.getCluster1() != cluster || !(alignment.getSequenceIdentity() >= sequenceIdentityCutoff)) continue;
                clone.setMinSequenceIdentity(Math.min(clone.getMinSequenceIdentity(), alignment.getSequenceIdentity()));
                clone.setMaxSequenceIdentity(Math.max(clone.getMaxSequenceIdentity(), alignment.getSequenceIdentity()));
                this.combineClusters(clone, alignment);
                int index = map.get(alignment.getCluster2());
                processed[index] = true;
            }
        }
        ProteinSequenceClusterer.sortSequenceClustersBySize(mergedClusters);
        return mergedClusters;
    }

    private Map<SequenceAlignmentCluster, Integer> getClusterMap() {
        HashMap<SequenceAlignmentCluster, Integer> map = new HashMap<SequenceAlignmentCluster, Integer>();
        int n = this.clusters.size();
        for (int i = 0; i < n; ++i) {
            map.put(this.clusters.get(i), i);
        }
        return map;
    }

    private void combineClusters(SequenceAlignmentCluster c1, PairwiseAlignment alignment) {
        SequenceAlignmentCluster c2 = (SequenceAlignmentCluster)alignment.getCluster2().clone();
        int[][][] align = alignment.getAlignment();
        UniqueSequenceList u = c2.getUniqueSequenceList().get(0);
        ArrayList<Integer> align1 = new ArrayList<Integer>(align[0][0].length);
        int[] arr$ = align[0][0];
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer a1 = arr$[i$];
            align1.add(a1);
        }
        u.setAlignment1(align1);
        ArrayList<Integer> align2 = new ArrayList<Integer>(align[0][1].length);
        int[] arr$2 = align[0][1];
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            Integer a2 = arr$2[i$];
            align2.add(a2);
        }
        u.setAlignment2(align2);
        c1.addUniqueSequenceList(u);
        for (int i = 1; i < c2.getUniqueSequenceList().size(); ++i) {
            u = c2.getUniqueSequenceList().get(i);
            List<Integer> oldAlign1 = u.getAlignment1();
            List<Integer> oldAlign2 = u.getAlignment2();
            ArrayList<Integer> newAlign1 = new ArrayList<Integer>();
            ArrayList<Integer> newAlign2 = new ArrayList<Integer>();
            for (int j = 0; j < align2.size(); ++j) {
                Integer element = (Integer)align2.get(j);
                Integer index = oldAlign1.indexOf(element);
                if (index == null || index < 0) continue;
                newAlign1.add((Integer)align1.get(j));
                newAlign2.add(oldAlign2.get(index));
            }
            u.setAlignment1(newAlign1);
            u.setAlignment2(newAlign2);
            c1.addUniqueSequenceList(u);
        }
    }
}

