/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BlastClustReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int sequenceIdentity = 0;
    private List<List<String>> clusters = new ArrayList<List<String>>();
    private static final String coreUrl = "ftp://resources.rcsb.org/sequence/clusters/";
    private static List<Integer> seqIdentities = Arrays.asList(30, 40, 50, 70, 90, 95, 100);

    public BlastClustReader(int sequenceIdentity) {
        this.sequenceIdentity = sequenceIdentity;
    }

    public List<List<String>> getPdbChainIdClusters() {
        this.loadClusters(this.sequenceIdentity);
        return this.clusters;
    }

    public Map<String, String> getRepresentatives(String pdbId) {
        this.loadClusters(this.sequenceIdentity);
        String pdbIdUc = pdbId.toUpperCase();
        LinkedHashMap<String, String> representatives = new LinkedHashMap<String, String>();
        block0: for (List<String> cluster : this.clusters) {
            for (String chainId : cluster) {
                if (!chainId.startsWith(pdbIdUc)) continue;
                representatives.put(chainId, cluster.get(0));
                continue block0;
            }
        }
        return representatives;
    }

    public String getRepresentativeChain(String pdbId, String chainId) {
        this.loadClusters(this.sequenceIdentity);
        String pdbChainId = pdbId.toUpperCase() + "." + chainId;
        for (List<String> cluster : this.clusters) {
            if (!cluster.contains(pdbChainId)) continue;
            return cluster.get(0);
        }
        return "";
    }

    public int indexOf(String pdbId, String chainId) {
        this.loadClusters(this.sequenceIdentity);
        String pdbChainId = pdbId.toUpperCase() + "." + chainId;
        for (int i = 0; i < this.clusters.size(); ++i) {
            List<String> cluster = this.clusters.get(i);
            if (!cluster.contains(pdbChainId)) continue;
            return i;
        }
        return -1;
    }

    public List<List<String>> getPdbChainIdClusters(String pdbId) {
        this.loadClusters(this.sequenceIdentity);
        String pdbIdUpper = pdbId.toUpperCase();
        ArrayList<List<String>> matches = new ArrayList<List<String>>();
        block0: for (List<String> cluster : this.clusters) {
            for (String chainId : cluster) {
                if (!chainId.startsWith(pdbIdUpper)) continue;
                matches.add(cluster);
                continue block0;
            }
        }
        return matches;
    }

    public List<List<String>> getChainIdsInEntry(String pdbId) {
        this.loadClusters(this.sequenceIdentity);
        ArrayList<List<String>> matches = new ArrayList<List<String>>();
        ArrayList<String> match = null;
        for (List<String> cluster : this.clusters) {
            for (String chainId : cluster) {
                if (!chainId.startsWith(pdbId)) continue;
                if (match == null) {
                    match = new ArrayList<String>();
                }
                match.add(chainId.substring(5));
            }
            if (match == null) continue;
            Collections.sort(match);
            matches.add(match);
            match = null;
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClusters(int sequenceIdentity) {
        block9: {
            if (this.clusters.size() > 0) {
                return;
            }
            if (!seqIdentities.contains(sequenceIdentity)) {
                System.err.println("Error: representative chains are not available for %sequence identity: " + sequenceIdentity);
                return;
            }
            try {
                URL u = new URL("ftp://resources.rcsb.org/sequence/clusters/bc-" + sequenceIdentity + ".out");
                InputStream stream = u.openStream();
                if (stream == null) break block9;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        line = line.replaceAll("_", ".");
                        List<String> cluster = Arrays.asList(line.split(" "));
                        this.clusters.add(cluster);
                    }
                    reader.close();
                    stream.close();
                }
                catch (IOException e) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

