/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.secstruc.SecStrucElement;
import org.biojava.nbio.structure.secstruc.SecStrucTools;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.CeSymm;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.ResidueGroup;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeSymmIterative {
    private static final Logger logger = LoggerFactory.getLogger(CeSymmIterative.class);
    private CESymmParameters params;
    private Atom[] allAtoms;
    private UndirectedGraph<Integer, DefaultEdge> alignGraph;
    private List<MultipleAlignment> levels;
    private CeSymmResult result;

    public CeSymmIterative(CESymmParameters param) {
        this.params = param;
        this.alignGraph = new SimpleGraph(DefaultEdge.class);
        this.levels = new ArrayList<MultipleAlignment>();
    }

    public CeSymmResult execute(Atom[] atoms) throws StructureException {
        this.allAtoms = atoms;
        boolean symm = this.iterate(atoms);
        if (symm) {
            if (!this.buildAlignment()) {
                return this.result;
            }
            this.recoverAxes();
            MultipleAlignment msa = this.result.getMultipleAlignment();
            SymmetryTools.updateSymmetryTransformation(this.result.getAxes(), msa, atoms);
            double tmScore = MultipleAlignmentScorer.getAvgTMScore(msa) * (double)msa.size();
            double rmsd = MultipleAlignmentScorer.getRMSD(msa);
            msa.putScore("AvgTM-score", tmScore);
            msa.putScore("RMSD", rmsd);
        }
        return this.result;
    }

    private boolean iterate(Atom[] atoms) throws StructureException {
        logger.debug("Starting new iteration...");
        if ((atoms.length <= this.params.getWinSize() || atoms.length <= this.params.getMinCoreLength()) && this.result != null) {
            logger.debug("Aborting iteration due to insufficient Atom array length: %d", (Object)atoms.length);
            return !this.levels.isEmpty();
        }
        if (this.params.getSymmLevels() > 0 && this.levels.size() == this.params.getSymmLevels()) {
            return true;
        }
        CeSymmResult r = CeSymm.analyzeLevel(atoms, this.params);
        if (this.result == null) {
            this.result = r;
        }
        if (this.params.getRefineMethod() == CESymmParameters.RefineMethod.NOT_REFINED) {
            return false;
        }
        if (!r.isSignificant()) {
            return !this.levels.isEmpty();
        }
        Integer start = null;
        int it = 0;
        while (start == null) {
            start = r.getMultipleAlignment().getBlocks().get(0).getAlignRes().get(0).get(it);
            ++it;
        }
        Integer end = null;
        it = r.getMultipleAlignment().getBlocks().get(0).getAlignRes().get(0).size() - 1;
        while (end == null) {
            end = r.getMultipleAlignment().getBlocks().get(0).getAlignRes().get(0).get(it);
            --it;
        }
        Atom[] atomsR = Arrays.copyOfRange(atoms, (int)start, end + 1);
        if (CeSymmIterative.countHelixStrandSSE(atomsR) < this.params.getSSEThreshold()) {
            return !this.levels.isEmpty();
        }
        Block b = r.getMultipleAlignment().getBlock(0);
        for (int pos = 0; pos < b.length(); ++pos) {
            for (int su = 0; su < b.size() - 1; ++su) {
                Integer pos1 = b.getAlignRes().get(su).get(pos);
                Integer pos2 = b.getAlignRes().get(su + 1).get(pos);
                if (pos1 == null || pos2 == null) continue;
                this.alignGraph.addVertex((Object)pos1);
                this.alignGraph.addVertex((Object)pos2);
                this.alignGraph.addEdge((Object)pos1, (Object)pos2);
            }
        }
        this.levels.add(r.getMultipleAlignment());
        return this.iterate(atomsR);
    }

    private boolean buildAlignment() throws StructureException {
        if (this.levels.size() == 1) {
            this.result.setSymmLevels(1);
            return false;
        }
        MultipleAlignmentImpl msa = new MultipleAlignmentImpl();
        msa.getEnsemble().setAtomArrays(new ArrayList<Atom[]>());
        msa.getEnsemble().setStructureIdentifiers(new ArrayList<StructureIdentifier>());
        msa.getEnsemble().setAlgorithmName("jCE-symm");
        msa.getEnsemble().setVersion("2.2");
        BlockSetImpl bs = new BlockSetImpl(msa);
        BlockImpl b = new BlockImpl(bs);
        b.setAlignRes(new ArrayList<List<Integer>>());
        ConnectivityInspector inspector = new ConnectivityInspector(this.alignGraph);
        List comps = inspector.connectedSets();
        ArrayList<ResidueGroup> groups = new ArrayList<ResidueGroup>(comps.size());
        for (Object comp : comps) {
            groups.add(new ResidueGroup((Set<Integer>)comp));
        }
        int order = 1;
        for (MultipleAlignment m : this.levels) {
            order *= m.size();
        }
        for (int su = 0; su < order; ++su) {
            b.getAlignRes().add(new ArrayList());
        }
        for (ResidueGroup group : groups) {
            if (group.order() != order) continue;
            group.combineWith(b.getAlignRes());
        }
        if (b.length() == 0) {
            return false;
        }
        for (int su = 0; su < order; ++su) {
            Collections.sort(b.getAlignRes().get(su));
            msa.getEnsemble().getAtomArrays().add(this.allAtoms);
            msa.getEnsemble().getStructureIdentifiers().add(this.result.getStructureId());
        }
        this.result.setMultipleAlignment(msa);
        this.result.setRefined(true);
        this.result.setSymmOrder(order);
        this.result.setSymmLevels(this.levels.size());
        return true;
    }

    private void recoverAxes() {
        SymmetryAxes axes = new SymmetryAxes();
        int size = this.result.getMultipleAlignment().size();
        int parents = 1;
        for (int m = 0; m < this.levels.size(); ++m) {
            int s;
            MultipleAlignment align = this.levels.get(m);
            Matrix4d axis = align.getBlockSet(0).getTransformations().get(1);
            int subsize = align.size();
            parents *= subsize;
            size /= subsize;
            ArrayList<Integer> repeatTransform = new ArrayList<Integer>();
            for (int i = 0; i < size * parents; ++i) {
                repeatTransform.add(0);
            }
            ArrayList<List<Integer>> superpose = new ArrayList<List<Integer>>();
            superpose.add(new ArrayList());
            superpose.add(new ArrayList());
            for (int su = 0; su < subsize - 1; ++su) {
                for (s = 0; s < size; ++s) {
                    Integer subIndex1 = su * size + s;
                    Integer subIndex2 = (su + 1) * size + s;
                    ((List)superpose.get(0)).add(subIndex1);
                    ((List)superpose.get(1)).add(subIndex2);
                }
            }
            for (int p = 0; p < parents; ++p) {
                for (s = 0; s < size; ++s) {
                    repeatTransform.set(p * size + s, p % subsize);
                }
            }
            axes.addAxis(axis, superpose, repeatTransform, subsize);
        }
        this.result.setAxes(axes);
    }

    private static int countHelixStrandSSE(Atom[] atoms) {
        List<SecStrucElement> sses = SecStrucTools.getSecStrucElements(SymmetryTools.getGroups(atoms));
        int count = 0;
        for (SecStrucElement sse : sses) {
            SecStrucType t = sse.getType();
            if (!t.isBetaStrand() && !t.isHelixType()) continue;
            ++count;
        }
        return count;
    }
}

