/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;

public class SymmetryAxes {
    private List<Matrix4d> axes = new ArrayList<Matrix4d>();
    private List<Integer> tree;
    private List<List<Integer>> repeatTransforms;
    private Map<Integer, List<List<Integer>>> mapAxisRepeats = new HashMap<Integer, List<List<Integer>>>();

    public SymmetryAxes() {
        this.repeatTransforms = new ArrayList<List<Integer>>();
        this.tree = new ArrayList<Integer>();
    }

    public void addAxis(Matrix4d axis, List<List<Integer>> superposition, List<Integer> repeats, Integer division) {
        if (superposition.size() != 2) {
            throw new IllegalArgumentException("Wrong superposition format: should be double List.");
        }
        if (superposition.get(0).size() != superposition.get(1).size()) {
            throw new IllegalArgumentException("Wrong superposition format: not equal List sizes.");
        }
        if (division < 2) {
            throw new IllegalArgumentException("A symmetry axis should divide a structure in > 2 parts");
        }
        this.axes.add(axis);
        this.tree.add(division);
        while (this.repeatTransforms.size() < repeats.size()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int a = 0; a < this.axes.size() - 1; ++a) {
                list.add(0);
            }
            this.repeatTransforms.add(list);
        }
        for (int su = 0; su < this.repeatTransforms.size(); ++su) {
            Integer nTimes = 0;
            if (su < repeats.size()) {
                nTimes = repeats.get(su);
            }
            this.repeatTransforms.get(su).add(nTimes);
        }
        for (int c = 0; c < 2; ++c) {
            for (int p = 0; p < superposition.get(c).size(); ++p) {
                Integer su = superposition.get(c).get(p);
                if (su <= this.repeatTransforms.size()) continue;
                throw new IllegalArgumentException("Repeat indicex in superposition out of bounds");
            }
        }
        this.mapAxisRepeats.put(this.axes.size() - 1, superposition);
    }

    public void updateAxis(Integer index, Matrix4d newAxis) {
        this.axes.set(index, newAxis);
    }

    public List<Matrix4d> getElementaryAxes() {
        return this.axes;
    }

    public List<List<Integer>> getRepeatRelation(Integer index) {
        return this.mapAxisRepeats.get(index);
    }

    public Matrix4d getRepeatTransform(int repeat) {
        ArrayList<Matrix4d> allTransforms = new ArrayList<Matrix4d>();
        Matrix4d transform = new Matrix4d();
        transform.setIdentity();
        for (int a = 0; a < this.axes.size(); ++a) {
            Matrix4d t = (Matrix4d)this.axes.get(a).clone();
            Matrix4d clone = (Matrix4d)t.clone();
            for (int i = 1; i < this.repeatTransforms.get(repeat).get(a); ++i) {
                clone.mul(t);
            }
            if (this.repeatTransforms.get(repeat).get(a) <= 0) continue;
            allTransforms.add(clone);
        }
        for (int t = allTransforms.size() - 1; t >= 0; --t) {
            transform.mul((Matrix4d)allTransforms.get(t));
        }
        return transform;
    }

    @Deprecated
    public List<Matrix4d> getSymmetryAxes() {
        ArrayList<Matrix4d> symmAxes = new ArrayList<Matrix4d>();
        for (int su = 0; su < this.repeatTransforms.size(); ++su) {
            Matrix4d axis = new Matrix4d();
            axis.setIdentity();
            boolean ident = true;
            for (int t = this.repeatTransforms.get(su).size() - 1; t >= 0; --t) {
                int repeats = this.repeatTransforms.get(su).get(t);
                Matrix4d clone = (Matrix4d)this.axes.get(t).clone();
                Matrix4d invert = (Matrix4d)clone.clone();
                invert.invert();
                for (int n = 0; n < repeats; ++n) {
                    if (ident) {
                        axis = clone;
                        clone = (Matrix4d)this.axes.get(t).clone();
                        ident = false;
                        continue;
                    }
                    clone.mul(axis);
                    axis = clone;
                    clone = (Matrix4d)this.axes.get(t).clone();
                    axis.mul(invert);
                }
            }
            if (ident) continue;
            symmAxes.add(axis);
        }
        for (int a = 0; a < symmAxes.size(); ++a) {
            for (int b = a + 1; b < symmAxes.size(); ++b) {
                Matrix4d bx;
                Matrix4d ax = (Matrix4d)symmAxes.get(a);
                boolean eq = SymmetryTools.equivalentAxes(ax, bx = (Matrix4d)symmAxes.get(b), 0.1);
                if (!eq) continue;
                symmAxes.set(a, bx);
            }
        }
        return symmAxes;
    }
}

