/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.io.mmcif.AllChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.ReducedChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadChemCompProvider
implements ChemCompProvider {
    private static final Logger logger = LoggerFactory.getLogger(DownloadChemCompProvider.class);
    public static final String CHEM_COMP_CACHE_DIRECTORY = "chemcomp";
    public static final String SERVER_LOCATION = "http://files.rcsb.org/ligands/download/";
    private static File path;
    private static final String NEWLINE;
    static AtomicBoolean loading;
    static final List<String> protectedIDs;
    boolean downloadAll = false;

    public DownloadChemCompProvider() {
        logger.debug("Initialising DownloadChemCompProvider");
        DownloadChemCompProvider.initPath();
    }

    public DownloadChemCompProvider(String cacheFilePath) {
        logger.debug("Initialising DownloadChemCompProvider");
        path = new File(cacheFilePath);
    }

    private static void initPath() {
        if (path == null) {
            UserConfiguration config = new UserConfiguration();
            path = new File(config.getCacheFilePath());
        }
    }

    public void checkDoFirstInstall() {
        if (!this.downloadAll) {
            return;
        }
        File dir = new File(path, CHEM_COMP_CACHE_DIRECTORY);
        File f = new File(dir, "components.cif.gz");
        if (!f.exists()) {
            this.downloadAllDefinitions();
        } else {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String file) {
                    return file.endsWith(".cif.gz");
                }
            };
            String[] files = dir.list(filter);
            if (files.length < 500) {
                try {
                    this.split();
                }
                catch (IOException e) {
                    logger.error("Could not split file {} into individual chemical component files. Error: {}", (Object)f.toString(), (Object)e.getMessage());
                }
            }
        }
    }

    private void split() throws IOException {
        logger.info("Installing individual chem comp files ...");
        File dir = new File(path, CHEM_COMP_CACHE_DIRECTORY);
        File f = new File(dir, "components.cif.gz");
        int counter = 0;
        InputStreamProvider prov = new InputStreamProvider();
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(prov.getInputStream(f)));){
            String line = null;
            line = buf.readLine();
            StringWriter writer = new StringWriter();
            String currentID = null;
            while (line != null) {
                if (line.startsWith("data_")) {
                    if (currentID != null) {
                        this.writeID(writer.toString(), currentID);
                        ++counter;
                    }
                    currentID = line.substring(5);
                    writer = new StringWriter();
                }
                writer.append(line);
                writer.append(NEWLINE);
                line = buf.readLine();
            }
            this.writeID(writer.toString(), currentID);
        }
        logger.info("Created " + ++counter + " chemical component files.");
    }

    private void writeID(String contents, String currentID) throws IOException {
        String localName = DownloadChemCompProvider.getLocalFileName(currentID);
        try (PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(localName)));){
            pw.print(contents.toString());
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChemComp getChemComp(String recordName) {
        recordName = recordName.toUpperCase().trim();
        boolean haveFile = true;
        if (recordName.equals("?")) {
            return null;
        }
        if (!DownloadChemCompProvider.fileExists(recordName)) {
            this.checkDoFirstInstall();
        }
        if (!DownloadChemCompProvider.fileExists(recordName)) {
            haveFile = DownloadChemCompProvider.downloadChemCompRecord(recordName);
        }
        if (haveFile) {
            String filename = DownloadChemCompProvider.getLocalFileName(recordName);
            InputStream inStream = null;
            try {
                ChemComp chemComp;
                InputStreamProvider isp = new InputStreamProvider();
                inStream = isp.getInputStream(filename);
                SimpleMMcifParser parser = new SimpleMMcifParser();
                ChemCompConsumer consumer = new ChemCompConsumer();
                parser.addMMcifConsumer(consumer);
                parser.parse(new BufferedReader(new InputStreamReader(inStream)));
                ChemicalComponentDictionary dict = consumer.getDictionary();
                ChemComp chemComp2 = chemComp = dict.getChemComp(recordName);
                return chemComp2;
            }
            catch (IOException e) {
                logger.error("Could not parse chemical component file {}. Error: {}. There will be no chemical component info available for {}", new Object[]{filename, e.getMessage(), recordName});
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        logger.error("Could not close chemical component file {}. A resource leak could occur!!", (Object)filename);
                    }
                }
            }
        }
        ReducedChemCompProvider reduced = new ReducedChemCompProvider();
        return reduced.getChemComp(recordName);
    }

    public static String getLocalFileName(String recordName) {
        if (protectedIDs.contains(recordName)) {
            recordName = "_" + recordName;
        }
        DownloadChemCompProvider.initPath();
        File f = new File(path, CHEM_COMP_CACHE_DIRECTORY);
        if (!f.exists()) {
            logger.info("Creating directory " + f);
            boolean success = f.mkdir();
            if (!success) {
                logger.error("Directory {} could not be created", (Object)f);
            }
        }
        File theFile = new File(f, recordName + ".cif.gz");
        return theFile.toString();
    }

    private static boolean fileExists(String recordName) {
        String fileName = DownloadChemCompProvider.getLocalFileName(recordName);
        File f = new File(fileName);
        return f.exists();
    }

    private static boolean downloadChemCompRecord(String recordName) {
        File newFile;
        String localName = DownloadChemCompProvider.getLocalFileName(recordName);
        try {
            newFile = File.createTempFile(CHEM_COMP_CACHE_DIRECTORY + recordName, "cif");
        }
        catch (IOException e) {
            logger.error("Could not write to temp directory {} to create the chemical component download temp file", (Object)System.getProperty("java.io.tmpdir"));
            return false;
        }
        String u = SERVER_LOCATION + recordName + ".cif";
        logger.debug("downloading " + u);
        URL url = null;
        try {
            url = new URL(u);
            HttpURLConnection uconn = HTTPConnectionTools.openHttpURLConnection(url);
            try (PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(newFile)));
                 BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(uconn.getInputStream()));){
                String line;
                while ((line = fileBuffer.readLine()) != null) {
                    pw.println(line);
                }
                pw.flush();
            }
            Files.move(newFile.toPath(), Paths.get(localName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            logger.error("Could not download " + url.toString() + " OR store locally to " + localName + " Error =" + e.getMessage());
            newFile.delete();
            return false;
        }
    }

    private void downloadAllDefinitions() {
        if (loading.get()) {
            logger.info("Waiting for other thread to install chemical components...");
        }
        if (loading.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted " + e.getMessage());
            }
            logger.info("Another thread installed the chemical components.");
            return;
        }
        loading.set(true);
        long timeS = System.currentTimeMillis();
        logger.info("Performing first installation of chemical components.");
        logger.info("Downloading components.cif.gz ...");
        try {
            AllChemCompProvider.downloadFile();
        }
        catch (IOException e) {
            logger.error("Could not download the all chemical components file. Error: {}. Chemical components information won't be available", (Object)e.getMessage());
            loading.set(false);
            return;
        }
        try {
            this.split();
        }
        catch (IOException e) {
            logger.error("Could not split all chem comp file into individual chemical component files. Error: {}", (Object)e.getMessage());
            loading.set(false);
            return;
        }
        long timeE = System.currentTimeMillis();
        logger.info("time to install chem comp dictionary: " + (timeE - timeS) / 1000L + " sec.");
        loading.set(false);
    }

    public boolean isDownloadAll() {
        return this.downloadAll;
    }

    public void setDownloadAll(boolean downloadAll) {
        this.downloadAll = downloadAll;
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        loading = new AtomicBoolean(false);
        protectedIDs = new ArrayList<String>();
        protectedIDs.add("CON");
        protectedIDs.add("PRN");
        protectedIDs.add("AUX");
        protectedIDs.add("NUL");
    }
}

