/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.SVDSuperimposer;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFPTwister {
    private static final Logger logger = LoggerFactory.getLogger(AFPTwister.class);

    public static Group[] twistPDB(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (afpChain.isShortAlign()) {
            return new Group[0];
        }
        List<AFP> afpSet = afpChain.getAfpSet();
        int blockNum = afpChain.getBlockNum();
        Atom[] origCA = StructureTools.cloneAtomArray(ca2);
        Atom[] iniTwistPdb = StructureTools.cloneAtomArray(ca2);
        int[] blockResSize = afpChain.getBlockResSize();
        int[][][] blockResList = afpChain.getBlockResList();
        int[] afpChainList = afpChain.getAfpChainList();
        int[] block2Afp = afpChain.getBlock2Afp();
        int[] blockSize = afpChain.getBlockSize();
        int[] focusAfpList = afpChain.getFocusAfpList();
        if (focusAfpList == null) {
            focusAfpList = new int[afpChain.getMinLen()];
            afpChain.setFocusAfpList(focusAfpList);
        }
        int focusAfpn = 0;
        int e2 = 0;
        int b2 = 0;
        logger.debug("blockNUm at twister: ", (Object)blockNum);
        for (int bk = 0; bk < blockNum; ++bk) {
            AFPTwister.transformOrigPDB(blockResSize[bk], blockResList[bk][0], blockResList[bk][1], ca1, ca2, null, -1);
            if (bk > 0) {
                b2 = e2;
            }
            logger.debug("b2 is {} before  modifyCon", (Object)b2);
            if (bk < blockNum - 1) {
                int afpPos = afpChainList[block2Afp[bk] + blockSize[bk] - 1];
                AFP a1 = afpSet.get(afpPos);
                e2 = a1.getP2();
                int afpPos2 = afpChainList[block2Afp[bk + 1]];
                AFP a2 = afpSet.get(afpPos2);
                e2 = (a2.getP2() - e2) / 2 + e2;
                logger.debug("e2 : {}", (Object)e2);
            } else {
                e2 = ca2.length;
            }
            AFPTwister.cloneAtomRange(iniTwistPdb, ca2, b2, e2);
            for (int i = 0; i < blockSize[bk]; ++i) {
                focusAfpList[focusAfpn] = afpChainList[block2Afp[bk] + i];
                ++focusAfpn;
            }
        }
        int focusResn = AFPTwister.afp2Res(afpChain, focusAfpn, focusAfpList, 0);
        afpChain.setTotalLenIni(focusResn);
        logger.debug(String.format("calrmsdini for %d residues", focusResn));
        double totalRmsdIni = AFPTwister.calCaRmsd(ca1, iniTwistPdb, focusResn, afpChain.getFocusRes1(), afpChain.getFocusRes2());
        afpChain.setTotalRmsdIni(totalRmsdIni);
        logger.debug("got iniRMSD: {}", (Object)totalRmsdIni);
        if (totalRmsdIni == 5.76611141613097) {
            logger.debug("{}", (Object)afpChain.getAlnseq1());
            logger.debug("{}", (Object)afpChain.getAlnsymb());
            logger.debug("{}", (Object)afpChain.getAlnseq2());
        }
        afpChain.setFocusAfpList(focusAfpList);
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setAfpChainList(afpChainList);
        return AFPTwister.twistOptimized(afpChain, ca1, origCA);
    }

    public static Group[] twistOptimized(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        Atom[] optTwistPdb = new Atom[ca2.length];
        int gPos = -1;
        for (Atom a : ca2) {
            optTwistPdb[++gPos] = a;
        }
        int blockNum = afpChain.getBlockNum();
        int b2 = 0;
        int e2 = 0;
        int focusResn = 0;
        int[] focusRes1 = afpChain.getFocusRes1();
        int[] focusRes2 = afpChain.getFocusRes2();
        if (focusRes1 == null) {
            focusRes1 = new int[afpChain.getCa1Length()];
            afpChain.setFocusRes1(focusRes1);
        }
        if (focusRes2 == null) {
            focusRes2 = new int[afpChain.getCa2Length()];
            afpChain.setFocusRes2(focusRes2);
        }
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        for (int bk = 0; bk < blockNum; ++bk) {
            AFPTwister.transformOrigPDB(optLen[bk], optAln[bk][0], optAln[bk][1], ca1, ca2, afpChain, bk);
            if (bk > 0) {
                b2 = e2;
            }
            if (bk < blockNum - 1) {
                e2 = optAln[bk][1][optLen[bk] - 1];
                e2 = (optAln[bk + 1][1][0] - e2) / 2 + e2;
            } else {
                e2 = ca2.length;
            }
            AFPTwister.cloneAtomRange(optTwistPdb, ca2, b2, e2);
            for (int i = 0; i < optLen[bk]; ++i) {
                focusRes1[focusResn] = optAln[bk][0][i];
                focusRes2[focusResn] = optAln[bk][1][i];
                ++focusResn;
            }
        }
        int totalLenOpt = focusResn;
        logger.debug("calrmsdopt for {} residues", (Object)focusResn);
        double totalRmsdOpt = AFPTwister.calCaRmsd(ca1, optTwistPdb, focusResn, focusRes1, focusRes2);
        logger.debug("got opt RMSD: {}", (Object)totalRmsdOpt);
        int optLength = afpChain.getOptLength();
        if (totalLenOpt != optLength) {
            logger.warn("Final alignment length is different {} {}", (Object)totalLenOpt, (Object)optLength);
        }
        logger.debug("final alignment length {}, rmsd {}", (Object)focusResn, (Object)totalRmsdOpt);
        afpChain.setTotalLenOpt(totalLenOpt);
        afpChain.setTotalRmsdOpt(totalRmsdOpt);
        return StructureTools.cloneGroups(optTwistPdb);
    }

    private static void transformOrigPDB(int n, int[] res1, int[] res2, Atom[] ca1, Atom[] ca2, AFPChain afpChain, int blockNr) throws StructureException {
        logger.debug("transforming original coordinates {} len1: {} res1: {} len2: {} res2: {}", new Object[]{n, ca1.length, res1.length, ca2.length, res2.length});
        Atom[] cod1 = AFPTwister.getAtoms(ca1, res1, n, false);
        Atom[] cod2 = AFPTwister.getAtoms(ca2, res2, n, false);
        SVDSuperimposer svd = new SVDSuperimposer(cod1, cod2);
        Matrix r = svd.getRotation();
        Atom t = svd.getTranslation();
        logger.debug("transPdb: transforming orig coordinates with matrix: {}", (Object)r);
        if (afpChain != null) {
            Matrix[] ms = afpChain.getBlockRotationMatrix();
            if (ms == null) {
                ms = new Matrix[afpChain.getBlockNum()];
            }
            ms[blockNr] = r;
            Atom[] shifts = afpChain.getBlockShiftVector();
            if (shifts == null) {
                shifts = new Atom[afpChain.getBlockNum()];
            }
            shifts[blockNr] = t;
            afpChain.setBlockRotationMatrix(ms);
            afpChain.setBlockShiftVector(shifts);
        }
        for (Atom a : ca2) {
            Calc.rotate(a.getGroup(), r);
            Calc.shift(a.getGroup(), t);
        }
    }

    private static Atom[] getAtoms(Atom[] ca, int[] positions, int length, boolean clone) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (int i = 0; i < length; ++i) {
            Atom a;
            int p = positions[i];
            if (clone) {
                a = (Atom)ca[p].clone();
                a.setGroup((Group)ca[p].getGroup().clone());
            } else {
                a = ca[p];
            }
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    private static void cloneAtomRange(Atom[] p1, Atom[] p2, int r1, int r2) throws StructureException {
        logger.debug("modifyCod from: {} to: {}", (Object)r1, (Object)r2);
        ArrayList<Chain> model = new ArrayList<Chain>();
        for (int i = r1; i < r2; ++i) {
            Group g = p2[i].getGroup();
            Group newG = (Group)g.clone();
            p1[i] = newG.getAtom(p2[i].getName());
            Chain parentC = g.getChain();
            Chain newChain = null;
            for (Chain c : model) {
                if (!c.getChainID().equals(parentC.getChainID())) continue;
                newChain = c;
                break;
            }
            if (newChain == null) {
                newChain = new ChainImpl();
                newChain.setChainID(parentC.getChainID());
                model.add(newChain);
            }
            newChain.addGroup(newG);
        }
    }

    private static double calCaRmsd(Atom[] ca1, Atom[] pro, int resn, int[] res1, int[] res2) throws StructureException {
        Atom[] cod1 = AFPTwister.getAtoms(ca1, res1, resn, false);
        Atom[] cod2 = AFPTwister.getAtoms(pro, res2, resn, false);
        if (cod1.length == 0 || cod2.length == 0) {
            logger.info("length of atoms  == 0!");
            return 99.0;
        }
        SVDSuperimposer svd = new SVDSuperimposer(cod1, cod2);
        Matrix r = svd.getRotation();
        Atom t = svd.getTranslation();
        for (Atom a : cod2) {
            Calc.rotate(a.getGroup(), r);
            Calc.shift(a.getGroup(), t);
        }
        return SVDSuperimposer.getRMS(cod1, cod2);
    }

    public static int afp2Res(AFPChain afpChain, int afpn, int[] afpPositions, int listStart) {
        int[] res1 = afpChain.getFocusRes1();
        int[] res2 = afpChain.getFocusRes2();
        int minLen = afpChain.getMinLen();
        int n = 0;
        List<AFP> afpSet = afpChain.getAfpSet();
        for (int i = listStart; i < listStart + afpn; ++i) {
            int a = afpPositions[i];
            for (int j = 0; j < afpSet.get(a).getFragLen(); ++j) {
                if (n >= minLen) {
                    throw new RuntimeException("Error: too many residues in AFPChainer.afp2Res!");
                }
                res1[n] = afpSet.get(a).getP1() + j;
                res2[n] = afpSet.get(a).getP2() + j;
                ++n;
            }
        }
        afpChain.setFocusRes1(res1);
        afpChain.setFocusRes2(res2);
        afpChain.setFocusResn(n);
        if (n == 0) {
            logger.warn("n=0!!! + " + afpn + " " + listStart + " " + afpPositions.length);
        }
        return n;
    }
}

