/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.Pair;

public class GridCell {
    private ArrayList<Integer> iIndices = new ArrayList();
    private ArrayList<Integer> jIndices = new ArrayList();

    public void addIindex(int serial) {
        this.iIndices.add(serial);
    }

    public void addJindex(int serial) {
        this.jIndices.add(serial);
    }

    public int getNumIindices() {
        return this.iIndices.size();
    }

    public int getNumJindices() {
        return this.jIndices.size();
    }

    public List<AtomContact> getContactsWithinCell(Atom[] iAtoms, Atom[] jAtoms, double cutoff) {
        ArrayList<AtomContact> contacts = new ArrayList<AtomContact>();
        if (jAtoms == null) {
            for (int i : this.iIndices) {
                for (int j : this.iIndices) {
                    double distance;
                    if (j <= i || !((distance = Calc.getDistance(iAtoms[i], iAtoms[j])) < cutoff)) continue;
                    contacts.add(new AtomContact(new Pair<Atom>(iAtoms[i], iAtoms[j]), distance));
                }
            }
        } else {
            for (int i : this.iIndices) {
                for (int j : this.jIndices) {
                    double distance = Calc.getDistance(iAtoms[i], jAtoms[j]);
                    if (!(distance < cutoff)) continue;
                    contacts.add(new AtomContact(new Pair<Atom>(iAtoms[i], jAtoms[j]), distance));
                }
            }
        }
        return contacts;
    }

    public List<AtomContact> getContactsToOtherCell(GridCell otherCell, Atom[] iAtoms, Atom[] jAtoms, double cutoff) {
        ArrayList<AtomContact> contacts = new ArrayList<AtomContact>();
        if (jAtoms == null) {
            for (int i : this.iIndices) {
                for (int j : otherCell.iIndices) {
                    double distance;
                    if (j <= i || !((distance = Calc.getDistance(iAtoms[i], iAtoms[j])) < cutoff)) continue;
                    contacts.add(new AtomContact(new Pair<Atom>(iAtoms[i], iAtoms[j]), distance));
                }
            }
        } else {
            for (int i : this.iIndices) {
                for (int j : otherCell.jIndices) {
                    double distance = Calc.getDistance(iAtoms[i], jAtoms[j]);
                    if (!(distance < cutoff)) continue;
                    contacts.add(new AtomContact(new Pair<Atom>(iAtoms[i], jAtoms[j]), distance));
                }
            }
        }
        return contacts;
    }
}

