/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.BondImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.SSBondImpl;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.io.util.PDBTemporaryStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BondMaker {
    private static final Logger logger = LoggerFactory.getLogger(BondMaker.class);
    public static final Set<String> BOND_TYPES_TO_PARSE = new HashSet<String>();
    private static final double MAX_PEPTIDE_BOND_LENGTH = 1.8;
    private static final double MAX_NUCLEOTIDE_BOND_LENGTH = 2.1;
    private Structure structure;
    private FileParsingParameters params;

    public BondMaker(Structure structure, FileParsingParameters params) {
        this.structure = structure;
        this.params = params;
    }

    public void makeBonds() {
        logger.debug("Going to start making bonds");
        this.formPeptideBonds();
        this.formNucleotideBonds();
        this.formIntraResidueBonds();
        this.trimBondLists();
    }

    private void formPeptideBonds() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                List<Group> groups = chain.getSeqResGroups();
                for (int i = 0; i < groups.size() - 1; ++i) {
                    if (!(groups.get(i) instanceof AminoAcidImpl) || !(groups.get(i + 1) instanceof AminoAcidImpl)) continue;
                    AminoAcidImpl tail = (AminoAcidImpl)groups.get(i);
                    AminoAcidImpl head = (AminoAcidImpl)groups.get(i + 1);
                    if (tail.getResidueNumber() == null || head.getResidueNumber() == null) continue;
                    Atom carboxylC = tail.getC();
                    Atom aminoN = head.getN();
                    if (carboxylC == null || aminoN == null || !(Calc.getDistance(carboxylC, aminoN) < 1.8)) continue;
                    new BondImpl(carboxylC, aminoN, 1);
                }
            }
        }
    }

    private void formNucleotideBonds() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                List<Group> groups = chain.getSeqResGroups();
                for (int i = 0; i < groups.size() - 1; ++i) {
                    if (!(groups.get(i) instanceof NucleotideImpl) || !(groups.get(i + 1) instanceof NucleotideImpl)) continue;
                    NucleotideImpl tail = (NucleotideImpl)groups.get(i);
                    NucleotideImpl head = (NucleotideImpl)groups.get(i + 1);
                    if (tail.getResidueNumber() == null || head.getResidueNumber() == null) continue;
                    Atom phosphorous = head.getP();
                    Atom oThreePrime = tail.getO3Prime();
                    if (phosphorous == null || oThreePrime == null || !(Calc.getDistance(phosphorous, oThreePrime) < 2.1)) continue;
                    new BondImpl(phosphorous, oThreePrime, 1);
                }
            }
        }
    }

    private void formIntraResidueBonds() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                List<Group> groups = chain.getAtomGroups();
                for (Group mainGroup : groups) {
                    if (mainGroup.getResidueNumber() == null) continue;
                    ArrayList<Group> totList = new ArrayList<Group>();
                    totList.add(mainGroup);
                    for (Group altLoc : mainGroup.getAltLocs()) {
                        totList.add(altLoc);
                    }
                    for (Group group : totList) {
                        ChemComp aminoChemComp = ChemCompGroupFactory.getChemComp(group.getPDBName());
                        logger.debug("chemcomp for residue {}-{} has {} atoms and {} bonds", new Object[]{group.getPDBName(), group.getResidueNumber(), aminoChemComp.getAtoms().size(), aminoChemComp.getBonds().size()});
                        for (ChemCompBond chemCompBond : aminoChemComp.getBonds()) {
                            Atom a = this.getAtom(chemCompBond.getAtom_id_1(), group);
                            Atom b = this.getAtom(chemCompBond.getAtom_id_2(), group);
                            if (a == null || b == null) continue;
                            int bondOrder = chemCompBond.getNumericalBondOrder();
                            logger.debug("Forming bond between atoms {}-{} and {}-{} with bond order {}", new Object[]{a.getPDBserial(), a.getName(), b.getPDBserial(), b.getName(), bondOrder});
                            new BondImpl(a, b, bondOrder);
                        }
                    }
                }
            }
        }
    }

    private Atom getAtom(String atomId, Group group) {
        Atom a = group.getAtom(atomId);
        if (a == null && atomId.startsWith("H") && (a = group.getAtom(atomId.replaceFirst("H", "D"))) != null && !a.getElement().equals((Object)Element.D)) {
            a = null;
        }
        return a;
    }

    private void trimBondLists() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                for (Group group : chain.getAtomGroups()) {
                    for (Atom atom : group.getAtoms()) {
                        if (atom.getBonds() == null || atom.getBonds().size() <= 0) continue;
                        ((ArrayList)atom.getBonds()).trimToSize();
                    }
                }
            }
        }
    }

    public void formDisulfideBonds(List<SSBondImpl> disulfideBonds) {
        for (SSBondImpl disulfideBond : disulfideBonds) {
            this.formDisulfideBond(disulfideBond);
        }
    }

    private void formDisulfideBond(SSBondImpl disulfideBond) {
        try {
            Map<Integer, Atom> a = this.getAtomFromRecord("SG", "", "CYS", disulfideBond.getChainID1(), disulfideBond.getResnum1(), disulfideBond.getInsCode1());
            Map<Integer, Atom> b = this.getAtomFromRecord("SG", "", "CYS", disulfideBond.getChainID2(), disulfideBond.getResnum2(), disulfideBond.getInsCode2());
            for (int i = 0; i < this.structure.nrModels(); ++i) {
                if (!a.containsKey(i) || !b.containsKey(i) || a.get(i).equals(b.get(i))) continue;
                BondImpl ssbond = new BondImpl(a.get(i), b.get(i), 1);
                this.structure.addSSBond(ssbond);
            }
        }
        catch (StructureException e) {
            if (!this.params.isParseCAOnly()) {
                logger.warn("Could not find atoms specified in SSBOND record: {}", (Object)disulfideBond.toString());
            }
            logger.debug("Could not find atoms specified in SSBOND record while parsing in parseCAonly mode.");
        }
    }

    public void formLinkRecordBond(PDBTemporaryStorageUtils.LinkRecord linkRecord) {
        if (linkRecord.getAltLoc1().equals(" ") || linkRecord.getAltLoc2().equals(" ")) {
            return;
        }
        try {
            Map<Integer, Atom> a = this.getAtomFromRecord(linkRecord.getName1(), linkRecord.getAltLoc1(), linkRecord.getResName1(), linkRecord.getChainID1(), linkRecord.getResSeq1(), linkRecord.getiCode1());
            Map<Integer, Atom> b = this.getAtomFromRecord(linkRecord.getName2(), linkRecord.getAltLoc2(), linkRecord.getResName2(), linkRecord.getChainID2(), linkRecord.getResSeq2(), linkRecord.getiCode2());
            for (int i = 0; i < this.structure.nrModels(); ++i) {
                if (!a.containsKey(i) || !b.containsKey(i) || a.get(i).equals(b.get(i))) continue;
                new BondImpl(a.get(i), b.get(i), 1);
            }
        }
        catch (StructureException e) {
            if (!this.params.isParseCAOnly()) {
                logger.warn("Could not find atoms specified in LINK record: {}", (Object)linkRecord.toString());
            }
            logger.debug("Could not find atoms specified in LINK record while parsing in parseCAonly mode.");
        }
    }

    public void formBondsFromStructConn(List<StructConn> structConn) {
        String symop = "1_555";
        ArrayList<Bond> ssbonds = new ArrayList<Bond>();
        for (StructConn conn : structConn) {
            if (!BOND_TYPES_TO_PARSE.contains(conn.getConn_type_id())) continue;
            String chainId1 = conn.getPtnr1_label_asym_id();
            String chainId2 = conn.getPtnr2_label_asym_id();
            String insCode1 = "";
            if (!conn.getPdbx_ptnr1_PDB_ins_code().equals("?")) {
                insCode1 = conn.getPdbx_ptnr1_PDB_ins_code();
            }
            String insCode2 = "";
            if (!conn.getPdbx_ptnr2_PDB_ins_code().equals("?")) {
                insCode2 = conn.getPdbx_ptnr2_PDB_ins_code();
            }
            String seqId1 = conn.getPtnr1_auth_seq_id();
            String seqId2 = conn.getPtnr2_auth_seq_id();
            String resName1 = conn.getPtnr1_label_comp_id();
            String resName2 = conn.getPtnr2_label_comp_id();
            String atomName1 = conn.getPtnr1_label_atom_id();
            String atomName2 = conn.getPtnr2_label_atom_id();
            String altLoc1 = "";
            if (!conn.getPdbx_ptnr1_label_alt_id().equals("?")) {
                altLoc1 = conn.getPdbx_ptnr1_label_alt_id();
            }
            String altLoc2 = "";
            if (!conn.getPdbx_ptnr2_label_alt_id().equals("?")) {
                altLoc2 = conn.getPdbx_ptnr2_label_alt_id();
            }
            if (!conn.getPtnr1_symmetry().equals("1_555") || !conn.getPtnr2_symmetry().equals("1_555")) {
                logger.info("Skipping bond between atoms {}(residue {}{}) and {}(residue {}{}) belonging to different symmetry partners, because it is not supported yet", new Object[]{atomName1, seqId1, insCode1, atomName2, seqId2, insCode2});
                continue;
            }
            String altLocStr1 = altLoc1.isEmpty() ? "" : "(alt loc " + altLoc1 + ")";
            String altLocStr2 = altLoc2.isEmpty() ? "" : "(alt loc " + altLoc2 + ")";
            Map<Integer, Atom> a1 = null;
            Map<Integer, Atom> a2 = null;
            try {
                a1 = this.getAtomFromRecord(atomName1, altLoc1, resName1, chainId1, seqId1, insCode1);
            }
            catch (StructureException e) {
                logger.warn("Could not find atom specified in struct_conn record: {}{}({}) in chain {}, atom {} {}", new Object[]{seqId1, insCode1, resName1, chainId1, atomName1, altLocStr1});
                continue;
            }
            try {
                a2 = this.getAtomFromRecord(atomName2, altLoc2, resName2, chainId2, seqId2, insCode2);
            }
            catch (StructureException e) {
                logger.warn("Could not find atom specified in struct_conn record: {}{}({}) in chain {}, atom {} {}", new Object[]{seqId2, insCode2, resName2, chainId2, atomName2, altLocStr2});
                continue;
            }
            if (a1 == null) {
                logger.warn("Could not find atom {} {} from residue {}{}({}) in chain {} to create bond specified in struct_conn", new Object[]{atomName1, altLocStr1, seqId1, insCode1, resName1, chainId1});
                continue;
            }
            if (a2 == null) {
                logger.warn("Could not find atom {} {} from residue {}{}({}) in chain {} to create bond specified in struct_conn", new Object[]{atomName2, altLocStr2, seqId2, insCode2, resName2, chainId2});
                continue;
            }
            for (int i = 0; i < this.structure.nrModels(); ++i) {
                BondImpl bond = null;
                if (a1.containsKey(i) && a2.containsKey(i) && !a1.get(i).equals(a2.get(i))) {
                    bond = new BondImpl(a1.get(i), a2.get(i), 1);
                }
                if (bond == null || !conn.getConn_type_id().equals("disulf")) continue;
                ssbonds.add(bond);
            }
        }
        this.structure.setSSBonds(ssbonds);
    }

    private Map<Integer, Atom> getAtomFromRecord(String name, String altLoc, String resName, String chainID, String resSeq, String iCode) throws StructureException {
        if (iCode == null || iCode.isEmpty()) {
            iCode = " ";
        }
        HashMap<Integer, Atom> outMap = new HashMap<Integer, Atom>();
        ResidueNumber resNum = new ResidueNumber(chainID, Integer.parseInt(resSeq), Character.valueOf(iCode.charAt(0)));
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            Group group;
            Chain chain = this.structure.getChain(chainID, i);
            Group g = group = chain.getGroupByPDB(resNum);
            if (!altLoc.isEmpty() && (g = group.getAltLocGroup(Character.valueOf(altLoc.charAt(0)))) == null) {
                throw new StructureException("Could not find altLoc code " + altLoc + " in group " + resSeq + iCode + " of chain " + chainID);
            }
            Atom a = g.getAtom(name);
            if (a == null) continue;
            outMap.put(i, a);
        }
        return outMap;
    }

    static {
        BOND_TYPES_TO_PARSE.add("disulf");
        BOND_TYPES_TO_PARSE.add("covale");
        BOND_TYPES_TO_PARSE.add("covale_base");
        BOND_TYPES_TO_PARSE.add("covale_phosphate");
        BOND_TYPES_TO_PARSE.add("covale_sugar");
        BOND_TYPES_TO_PARSE.add("modres");
    }
}

