/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.symmetry.internal.RefinerFailedException;
import org.biojava.nbio.structure.symmetry.internal.ResidueGroup;
import org.biojava.nbio.structure.symmetry.internal.SymmetryRefiner;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.jgrapht.Graph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;

public class GraphComponentRefiner
implements SymmetryRefiner {
    @Override
    public MultipleAlignment refine(AFPChain selfAlignment, Atom[] atoms, int order) throws StructureException, RefinerFailedException {
        boolean allZero;
        Graph<Integer, DefaultEdge> graph = SymmetryTools.buildSymmetryGraph(selfAlignment);
        ConnectivityInspector inspector = new ConnectivityInspector(graph);
        List components = inspector.connectedSets();
        ArrayList<ResidueGroup> groups = new ArrayList<ResidueGroup>();
        for (Set comp : components) {
            if (comp.size() != order) continue;
            ResidueGroup group = new ResidueGroup(comp);
            groups.add(group);
        }
        int size = groups.size();
        if (size == 0) {
            throw new RefinerFailedException("Could not find any components in the alignment Graph of size != order.");
        }
        GMatrix matrix = new GMatrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                ResidueGroup g2;
                if (i == j) {
                    matrix.setElement(i, j, 0.0);
                    continue;
                }
                ResidueGroup g1 = (ResidueGroup)groups.get(i);
                if (g1.isCompatible(g2 = (ResidueGroup)groups.get(j))) {
                    matrix.setElement(i, j, 1.0);
                    matrix.setElement(j, i, 1.0);
                    continue;
                }
                matrix.setElement(i, j, 0.0);
                matrix.setElement(j, i, 0.0);
            }
        }
        ArrayList<Integer> rowScores = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            GVector row = new GVector(size);
            matrix.getRow(i, row);
            int rowScore = (int)row.normSquared();
            rowScores.add(rowScore);
        }
        ArrayList<List<Integer>> alignRes = new ArrayList<List<Integer>>(order);
        for (int i = 0; i < order; ++i) {
            alignRes.add(new ArrayList());
        }
        do {
            Integer max = (Integer)Collections.max(rowScores);
            int index = rowScores.indexOf(max);
            ((ResidueGroup)groups.get(index)).combineWith(alignRes);
            allZero = true;
            for (int i = 0; i < size; ++i) {
                if (matrix.getElement(index, i) < 1.0) {
                    rowScores.set(i, 0);
                    continue;
                }
                if ((Integer)rowScores.get(i) == 0) continue;
                allZero = false;
            }
        } while (!allZero);
        for (int i = 0; i < order; ++i) {
            Collections.sort((List)alignRes.get(i));
        }
        int length = ((List)alignRes.get(0)).size();
        if (length == 0) {
            throw new RefinerFailedException("Empty alignment");
        }
        int[][][] optAln = new int[order][2][length];
        for (int bk = 0; bk < order; ++bk) {
            optAln[bk] = new int[2][];
            optAln[bk][0] = new int[length];
            optAln[bk][1] = new int[length];
            for (int pos = 0; pos < length; ++pos) {
                optAln[bk][0][pos] = (Integer)((List)alignRes.get(bk)).get(pos);
                optAln[bk][1][pos] = (Integer)((List)alignRes.get((bk + 1) % order)).get(pos);
            }
        }
        AFPChain afp = AlignmentTools.replaceOptAln(optAln, selfAlignment, atoms, atoms);
        return SymmetryTools.fromAFP(afp, atoms);
    }
}

