/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ce.CECalculator;
import org.biojava.nbio.structure.align.helper.AlignUtils;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.util.CoreSuperimposer;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitClustererMethod;
import org.biojava.nbio.structure.cluster.SubunitClustererParameters;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryDetector;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetryTools {
    private static final Logger logger = LoggerFactory.getLogger(SymmetryTools.class);

    private SymmetryTools() {
    }

    private static double getResetVal(double unpenalizedScore, double nResFromMainDiag, double[] gradientPolyCoeff, double gradientExpCoeff) {
        if (Double.isNaN(unpenalizedScore)) {
            return 0.0;
        }
        double updateVal = unpenalizedScore;
        updateVal -= gradientExpCoeff * Math.pow(Math.E, -nResFromMainDiag);
        for (int p = 0; p < gradientPolyCoeff.length; ++p) {
            updateVal -= gradientPolyCoeff[gradientPolyCoeff.length - 1 - p] * Math.pow(nResFromMainDiag, -p);
        }
        return updateVal;
    }

    public static Matrix grayOutCEOrig(Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix origM, int blankWindowSize, double[] gradientPolyCoeff, double gradientExpCoeff) {
        if (origM == null) {
            origM = new Matrix(calculator.getMatMatrix());
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int diff = Math.abs(i - j);
                double resetVal = SymmetryTools.getResetVal(origM.get(i, j), diff, gradientPolyCoeff, gradientExpCoeff);
                if (diff < blankWindowSize) {
                    origM.set(i, j, origM.get(i, j) + resetVal);
                }
                int diff2 = Math.abs(i - (j - ca2.length / 2));
                double resetVal2 = SymmetryTools.getResetVal(origM.get(i, j), diff2, gradientPolyCoeff, gradientExpCoeff);
                if (diff2 >= blankWindowSize) continue;
                origM.set(i, j, origM.get(i, j) + resetVal2);
            }
        }
        return origM;
    }

    public static Matrix grayOutPreviousAlignment(AFPChain afpChain, Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix max, int blankWindowSize, double[] gradientPolyCoeff, double gradientExpCoeff) {
        max = SymmetryTools.grayOutCEOrig(ca2, rows, cols, calculator, max, blankWindowSize, gradientPolyCoeff, gradientExpCoeff);
        double[][] dist1 = calculator.getDist1();
        double[][] dist2 = calculator.getDist2();
        int[][][] optAln = afpChain.getOptAln();
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int breakPoint = ca2.length / 2;
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos1 = optAln[bk][0][i];
                int pos2 = optAln[bk][1][i];
                int dist = blankWindowSize / 2;
                int start1 = Math.max(pos1 - dist, 0);
                int start2 = Math.max(pos2 - dist, 0);
                int end1 = Math.min(pos1 + dist, rows - 1);
                int end2 = Math.min(pos2 + dist, cols - 1);
                for (int i1 = start1; i1 < end1; ++i1) {
                    double resetVal;
                    for (int k = 0; k < blankWindowSize / 2; ++k) {
                        if (i1 - k >= 0) {
                            dist1[i1 - k][i1 - k] = resetVal = SymmetryTools.getResetVal(max.get(i1 - k, i1 - k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                            continue;
                        }
                        if (i1 + k >= rows) continue;
                        dist1[i1 + k][i1 + k] = resetVal = SymmetryTools.getResetVal(max.get(i1 + k, i1 + k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                    }
                    for (int j2 = start2; j2 < end2; ++j2) {
                        double resetVal2;
                        resetVal = SymmetryTools.getResetVal(max.get(i1, j2), Math.abs(i1 - j2), gradientPolyCoeff, gradientExpCoeff);
                        max.set(i1, j2, resetVal);
                        if (j2 < breakPoint) {
                            resetVal2 = SymmetryTools.getResetVal(max.get(i1, j2 + breakPoint), Math.abs(i1 - (j2 + breakPoint)), gradientPolyCoeff, gradientExpCoeff);
                            max.set(i1, j2 + breakPoint, resetVal2);
                        } else {
                            resetVal2 = SymmetryTools.getResetVal(max.get(i1, j2 - breakPoint), Math.abs(i1 - (j2 - breakPoint)), gradientPolyCoeff, gradientExpCoeff);
                            max.set(i1, j2 - breakPoint, resetVal2);
                        }
                        for (int k = 0; k < blankWindowSize / 2; ++k) {
                            double resetVal22;
                            if (j2 - k >= 0) {
                                if (j2 - k < breakPoint) {
                                    dist2[j2 - k][j2 - k] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 - k, j2 - k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                                    continue;
                                }
                                dist2[j2 - k - breakPoint][j2 - k - breakPoint] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 - k - breakPoint, j2 - k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                                continue;
                            }
                            if (j2 + k >= cols) continue;
                            if (j2 + k < breakPoint) {
                                dist2[j2 + k][j2 + k] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 + k, j2 + k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                                continue;
                            }
                            dist2[j2 + k - breakPoint][j2 + k - breakPoint] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 + k - breakPoint, j2 + k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                        }
                    }
                }
            }
        }
        calculator.setDist1(dist1);
        calculator.setDist2(dist2);
        return max;
    }

    public Matrix getDkMatrix(Atom[] ca1, Atom[] ca2, int fragmentLength, double[] dist1, double[] dist2, int rows, int cols) {
        int i;
        Matrix diffDistMax = Matrix.identity(ca1.length, ca2.length);
        for (i = 0; i < rows; ++i) {
            double score1 = 0.0;
            for (int x = 0; x < fragmentLength; ++x) {
                score1 += dist1[i + x];
            }
            for (int j = 0; j < cols; ++j) {
                double score2 = 0.0;
                for (int y = 0; y < fragmentLength; ++y) {
                    score2 += dist2[j + y];
                }
                diffDistMax.set(i, j, Math.abs(score1 - score2));
            }
        }
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int diff2;
                int diff = Math.abs(i - j);
                if (diff < 15) {
                    diffDistMax.set(i, j, 99.0);
                }
                if ((diff2 = Math.abs(i - (j - ca2.length / 2))) >= 15) continue;
                diffDistMax.set(i, j, 99.0);
            }
        }
        return diffDistMax;
    }

    public static Matrix blankOutPreviousAlignment(AFPChain afpChain, Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix max, int blankWindowSize) {
        return SymmetryTools.grayOutPreviousAlignment(afpChain, ca2, rows, cols, calculator, max, blankWindowSize, new double[]{-2.147483648E9}, 0.0);
    }

    public static Matrix blankOutCEOrig(Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix origM, int blankWindowSize) {
        return SymmetryTools.grayOutCEOrig(ca2, rows, cols, calculator, origM, blankWindowSize, new double[]{-2.147483648E9}, 0.0);
    }

    public static Matrix getDkMatrix(Atom[] ca1, Atom[] ca2, int k, int fragmentLength) {
        double[] dist1 = AlignUtils.getDiagonalAtK(ca1, k);
        double[] dist2 = AlignUtils.getDiagonalAtK(ca2, k);
        int rows = ca1.length - fragmentLength - k + 1;
        int cols = ca2.length - fragmentLength - k + 1;
        Matrix m2 = new Matrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            double score1 = 0.0;
            for (int x = 0; x < fragmentLength; ++x) {
                score1 += dist1[i + x];
            }
            for (int j = 0; j < cols; ++j) {
                double score2 = 0.0;
                for (int y = 0; y < fragmentLength; ++y) {
                    score2 += dist2[j + y];
                }
                m2.set(i, j, Math.abs(score1 - score2));
            }
        }
        return m2;
    }

    public static boolean[][] blankOutBreakFlag(AFPChain afpChain, Atom[] ca2, int rows, int cols, CECalculator calculator, boolean[][] breakFlag, int blankWindowSize) {
        int[][][] optAln = afpChain.getOptAln();
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int breakPoint = ca2.length / 2;
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos1 = optAln[bk][0][i];
                int pos2 = optAln[bk][1][i];
                int dist = blankWindowSize;
                int start1 = Math.max(pos1 - dist, 0);
                int start2 = Math.max(pos2 - dist, 0);
                int end1 = Math.min(pos1 + dist, rows - 1);
                int end2 = Math.min(pos2 + dist, cols - 1);
                for (int i1 = start1; i1 < end1; ++i1) {
                    for (int j2 = start2; j2 < end2; ++j2) {
                        breakFlag[i1][j2] = true;
                        if (j2 >= breakPoint) continue;
                        breakFlag[i1][j2 + breakPoint] = true;
                    }
                }
            }
        }
        return breakFlag;
    }

    public static double getAngle(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        Matrix rotation = afpChain.getBlockRotationMatrix()[0];
        return Math.acos(rotation.trace() - 1.0) * 180.0 / Math.PI;
    }

    public static List<List<Integer>> buildSymmetryGraph(List<AFPChain> afps, Atom[] atoms, boolean undirected) {
        ArrayList<List<Integer>> graph = new ArrayList<List<Integer>>();
        for (int n = 0; n < atoms.length; ++n) {
            graph.add(new ArrayList());
        }
        for (int k = 0; k < afps.size(); ++k) {
            for (int i = 0; i < afps.get(k).getOptAln().length; ++i) {
                for (int j = 0; j < afps.get(k).getOptAln()[i][0].length; ++j) {
                    Integer res1 = afps.get(k).getOptAln()[i][0][j];
                    Integer res2 = afps.get(k).getOptAln()[i][1][j];
                    ((List)graph.get(res1)).add(res2);
                    if (!undirected) continue;
                    ((List)graph.get(res2)).add(res1);
                }
            }
        }
        return graph;
    }

    public static Graph<Integer, DefaultEdge> buildSymmetryGraph(AFPChain selfAlignment) {
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        for (int i = 0; i < selfAlignment.getOptAln().length; ++i) {
            for (int j = 0; j < selfAlignment.getOptAln()[i][0].length; ++j) {
                Integer res1 = selfAlignment.getOptAln()[i][0][j];
                Integer res2 = selfAlignment.getOptAln()[i][1][j];
                graph.addVertex((Object)res1);
                graph.addVertex((Object)res2);
                graph.addEdge((Object)res1, (Object)res2);
            }
        }
        return graph;
    }

    public static List<Structure> divideStructure(CeSymmResult symmetry) throws StructureException {
        if (!symmetry.isRefined()) {
            throw new IllegalArgumentException("The symmetry result is not refined, repeats cannot be defined");
        }
        int order = symmetry.getMultipleAlignment().size();
        Atom[] atoms = symmetry.getAtoms();
        Set<Group> allGroups = StructureTools.getAllGroupsFromSubset(atoms, GroupType.HETATM);
        List<StructureIdentifier> repeatsId = symmetry.getRepeatsID();
        ArrayList<Structure> repeats = new ArrayList<Structure>(order);
        for (int i = 0; i < order; ++i) {
            StructureImpl s = new StructureImpl();
            s.setStructureIdentifier(repeatsId.get(i));
            Block align = symmetry.getMultipleAlignment().getBlock(0);
            int res1 = align.getStartResidue(i);
            int res2 = align.getFinalResidue(i);
            ArrayList<Atom> repeat = new ArrayList<Atom>(Math.max(9 * (res2 - res1 + 1), 9));
            Chain prevChain = null;
            for (int k = res1; k <= res2; ++k) {
                Group g = atoms[k].getGroup();
                prevChain = StructureTools.addGroupToStructure(s, g, 0, prevChain, true);
                repeat.addAll(g.getAtoms());
            }
            List<Group> ligands = StructureTools.getLigandsByProximity(allGroups, repeat.toArray(new Atom[repeat.size()]), 5.0);
            logger.warn("Adding {} ligands to {}", (Object)ligands.size(), (Object)symmetry.getMultipleAlignment().getStructureIdentifier(i));
            for (Group ligand : ligands) {
                prevChain = StructureTools.addGroupToStructure(s, ligand, 0, prevChain, true);
            }
            repeats.add(s);
        }
        return repeats;
    }

    public static MultipleAlignment toFullAlignment(CeSymmResult symm) {
        if (!symm.isRefined()) {
            throw new IllegalArgumentException("The symmetry result is not refined, repeats cannot be defined");
        }
        MultipleAlignment full = symm.getMultipleAlignment().clone();
        for (int str = 1; str < full.size(); ++str) {
            Block b = full.getBlock(full.getBlocks().size() - 1).clone();
            b.getAlignRes().add(b.getAlignRes().get(0));
            b.getAlignRes().remove(0);
            full.getBlockSet(0).getBlocks().add(b);
        }
        return full;
    }

    public static MultipleAlignment toRepeatsAlignment(CeSymmResult result) throws StructureException {
        if (!result.isRefined()) {
            throw new IllegalArgumentException("The symmetry result is not refined, repeats cannot be defined");
        }
        MultipleAlignment msa = result.getMultipleAlignment();
        MultipleAlignmentEnsemble newEnsemble = msa.getEnsemble().clone();
        List<Structure> repSt = SymmetryTools.divideStructure(result);
        MultipleAlignment repeats = newEnsemble.getMultipleAlignment(0);
        Block block = repeats.getBlock(0);
        ArrayList<Atom[]> atomArrays = new ArrayList<Atom[]>();
        for (Structure s : repSt) {
            atomArrays.add(StructureTools.getRepresentativeAtomArray(s));
        }
        newEnsemble.setAtomArrays(atomArrays);
        for (int su = 0; su < block.size(); ++su) {
            Integer start = block.getStartResidue(su);
            for (int res = 0; res < block.length(); ++res) {
                Integer residue = block.getAlignRes().get(su).get(res);
                if (residue != null) {
                    residue = residue - start;
                }
                block.getAlignRes().get(su).set(res, residue);
            }
        }
        return repeats;
    }

    public static MultipleAlignment fromAFP(AFPChain symm, Atom[] atoms) throws StructureException {
        if (!symm.getAlgorithmName().contains("symm")) {
            throw new IllegalArgumentException("The input alignment is not a symmetry alignment.");
        }
        MultipleAlignmentEnsembleImpl e = new MultipleAlignmentEnsembleImpl(symm, atoms, atoms, false);
        e.setAtomArrays(new ArrayList<Atom[]>());
        StructureIdentifier name = null;
        if (e.getStructureIdentifiers() != null) {
            if (!e.getStructureIdentifiers().isEmpty()) {
                name = e.getStructureIdentifiers().get(0);
            }
        } else {
            name = atoms[0].getGroup().getChain().getStructure().getStructureIdentifier();
        }
        e.setStructureIdentifiers(new ArrayList<StructureIdentifier>());
        MultipleAlignmentImpl result = new MultipleAlignmentImpl();
        BlockSetImpl bs = new BlockSetImpl(result);
        BlockImpl b = new BlockImpl(bs);
        b.setAlignRes(new ArrayList<List<Integer>>());
        int order = symm.getBlockNum();
        for (int su = 0; su < order; ++su) {
            List<Integer> residues = e.getMultipleAlignment(0).getBlock(su).getAlignRes().get(0);
            b.getAlignRes().add(residues);
            e.getStructureIdentifiers().add(name);
            e.getAtomArrays().add(atoms);
        }
        e.getMultipleAlignments().set(0, result);
        result.setEnsemble(e);
        CoreSuperimposer imposer = new CoreSuperimposer();
        imposer.superimpose(result);
        SymmetryTools.updateSymmetryScores(result);
        return result;
    }

    public static QuatSymmetryResults getQuaternarySymmetry(CeSymmResult result) throws StructureException {
        List<Atom[]> atoms = SymmetryTools.toRepeatsAlignment(result).getAtomArrays();
        List<Subunit> subunits = atoms.stream().map(a -> new Subunit((Atom[])a, null, null, null)).collect(Collectors.toList());
        SubunitClustererParameters cp = new SubunitClustererParameters();
        cp.setClustererMethod(SubunitClustererMethod.STRUCTURE);
        cp.setRMSDThreshold(10.0);
        cp.setStructureCoverageThreshold(0.0);
        QuatSymmetryParameters sp = new QuatSymmetryParameters();
        QuatSymmetryResults gSymmetry = QuatSymmetryDetector.calcGlobalSymmetry(subunits, sp, cp);
        return gSymmetry;
    }

    public static List<Group> getGroups(Atom[] rAtoms) {
        ArrayList<Group> groups = new ArrayList<Group>(rAtoms.length);
        for (Atom a : rAtoms) {
            Group g = a.getGroup();
            if (g != null) {
                groups.add(g);
                continue;
            }
            logger.info("Group not found for representative Atom {}", (Object)a);
        }
        return groups;
    }

    public static void updateSymmetryTransformation(SymmetryAxes axes, MultipleAlignment msa) throws StructureException {
        List<List<Integer>> block = msa.getBlocks().get(0).getAlignRes();
        int length = block.get(0).size();
        if (axes != null) {
            for (int level = 0; level < axes.getNumLevels(); ++level) {
                ArrayList<Atom> list1 = new ArrayList<Atom>();
                ArrayList<Atom> list2 = new ArrayList<Atom>();
                for (int firstRepeat : axes.getFirstRepeats(level)) {
                    Matrix4d transform = axes.getRepeatTransform(firstRepeat);
                    List<List<Integer>> relation = axes.getRepeatRelation(level, firstRepeat);
                    for (int index = 0; index < relation.get(0).size(); ++index) {
                        int p1 = relation.get(0).get(index);
                        int p2 = relation.get(1).get(index);
                        for (int k = 0; k < length; ++k) {
                            Integer pos1 = block.get(p1).get(k);
                            Integer pos2 = block.get(p2).get(k);
                            if (pos1 == null || pos2 == null) continue;
                            Atom a = (Atom)msa.getAtomArrays().get(p1)[pos1].clone();
                            Atom b = (Atom)msa.getAtomArrays().get(p2)[pos2].clone();
                            Calc.transform(a, transform);
                            Calc.transform(b, transform);
                            list1.add(a);
                            list2.add(b);
                        }
                    }
                }
                Atom[] arr1 = list1.toArray(new Atom[list1.size()]);
                Atom[] arr2 = list2.toArray(new Atom[list2.size()]);
                if (arr1.length > 0 && arr2.length > 0) {
                    Matrix4d axis = SuperPositions.superpose(Calc.atomsToPoints(arr1), Calc.atomsToPoints(arr2));
                    axes.updateAxis(level, axis);
                }
                ArrayList<Matrix4d> transformations = new ArrayList<Matrix4d>();
                for (int su = 0; su < msa.size(); ++su) {
                    transformations.add(axes.getRepeatTransform(su));
                }
                msa.getBlockSet(0).setTransformations(transformations);
            }
        } else {
            CoreSuperimposer imposer = new CoreSuperimposer();
            imposer.superimpose(msa);
        }
        SymmetryTools.updateSymmetryScores(msa);
    }

    public static void updateSymmetryScores(MultipleAlignment symm) throws StructureException {
        double tmScore = MultipleAlignmentScorer.getAvgTMScore(symm) * (double)symm.size();
        double rmsd = MultipleAlignmentScorer.getRMSD(symm);
        symm.putScore("AvgTM-score", tmScore);
        symm.putScore("RMSD", rmsd);
    }

    public static Atom[] getRepresentativeAtoms(Structure structure) {
        if (structure.isNmr()) {
            return StructureTools.getRepresentativeAtomArray(structure);
        }
        ArrayList<Atom> atomList = new ArrayList<Atom>();
        for (int m = 0; m < structure.nrModels(); ++m) {
            for (Chain c : structure.getModel(m)) {
                atomList.addAll(Arrays.asList(StructureTools.getRepresentativeAtomArray(c)));
            }
        }
        return atomList.toArray(new Atom[0]);
    }

    public static List<Integer> getValidFolds(List<Integer> stoichiometry) {
        ArrayList<Integer> denominators = new ArrayList<Integer>();
        if (stoichiometry.isEmpty()) {
            return denominators;
        }
        int nChains = Collections.max(stoichiometry);
        TreeSet<Integer> nominators = new TreeSet<Integer>(stoichiometry);
        for (int d = 1; d <= nChains; ++d) {
            boolean isDivisable = true;
            for (Integer n : nominators) {
                if (n % d == 0) continue;
                isDivisable = false;
                break;
            }
            if (!isDivisable) continue;
            denominators.add(d);
        }
        return denominators;
    }
}

