/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.OperatorResolver;
import org.biojava.nbio.structure.quaternary.OrderedPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiologicalAssemblyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BiologicalAssemblyBuilder.class);
    private OperatorResolver operatorResolver;
    private List<PdbxStructAssemblyGen> psags;
    private List<BiologicalAssemblyTransformation> modelTransformations;
    private List<String> modelIndex = new ArrayList<String>();

    public BiologicalAssemblyBuilder() {
        this.init();
    }

    public Structure rebuildQuaternaryStructure(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations, boolean useAsymIds, boolean multiModel) {
        this.orderTransformationsByChainId(asymUnit, transformations);
        Structure s = asymUnit.clone();
        s.resetModels();
        for (BiologicalAssemblyTransformation transformation : transformations) {
            ArrayList<Chain> chainsToTransform = new ArrayList<Chain>();
            if (useAsymIds) {
                Chain c = asymUnit.getChain(transformation.getChainId());
                chainsToTransform.add(c);
            } else {
                Chain polyC = asymUnit.getPolyChainByPDB(transformation.getChainId());
                List<Chain> nonPolyCs = asymUnit.getNonPolyChainsByPDB(transformation.getChainId());
                Chain waterC = asymUnit.getWaterChainByPDB(transformation.getChainId());
                if (polyC != null) {
                    chainsToTransform.add(polyC);
                }
                if (!nonPolyCs.isEmpty()) {
                    chainsToTransform.addAll(nonPolyCs);
                }
                if (waterC != null) {
                    chainsToTransform.add(waterC);
                }
            }
            for (Chain c : chainsToTransform) {
                Chain chain = (Chain)c.clone();
                Calc.transform(chain, transformation.getTransformationMatrix());
                String transformId = transformation.getId();
                if (multiModel) {
                    this.addChainMultiModel(s, chain, transformId);
                    continue;
                }
                this.addChainFlattened(s, chain, transformId);
            }
        }
        s.setBiologicalAssembly(true);
        return s;
    }

    private void orderTransformationsByChainId(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations) {
        final List<String> chainIds = this.getChainIds(asymUnit);
        Collections.sort(transformations, new Comparator<BiologicalAssemblyTransformation>(){

            @Override
            public int compare(BiologicalAssemblyTransformation t1, BiologicalAssemblyTransformation t2) {
                if (t1.getId().equals(t2.getId())) {
                    return chainIds.indexOf(t1.getChainId()) - chainIds.indexOf(t2.getChainId());
                }
                return t1.getId().compareTo(t2.getId());
            }
        });
    }

    private List<String> getChainIds(Structure asymUnit) {
        ArrayList<String> chainIds = new ArrayList<String>();
        for (Chain c : asymUnit.getChains()) {
            String intChainID = c.getId();
            chainIds.add(intChainID);
        }
        return chainIds;
    }

    private void addChainMultiModel(Structure s, Chain newChain, String transformId) {
        int modelCount;
        if (this.modelIndex.size() == 0) {
            this.modelIndex.add("PLACEHOLDER FOR ASYM UNIT");
        }
        if ((modelCount = this.modelIndex.indexOf(transformId)) == -1) {
            this.modelIndex.add(transformId);
            modelCount = this.modelIndex.indexOf(transformId);
        }
        if (modelCount == 0) {
            s.addChain(newChain);
        } else if (modelCount > s.nrModels()) {
            ArrayList<Chain> newModel = new ArrayList<Chain>();
            newModel.add(newChain);
            s.addModel(newModel);
        } else {
            s.addChain(newChain, modelCount - 1);
        }
    }

    private void addChainFlattened(Structure s, Chain newChain, String transformId) {
        newChain.setId(newChain.getId() + "_" + transformId);
        newChain.setName(newChain.getName() + "_" + transformId);
        s.addChain(newChain);
    }

    public ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationList(PdbxStructAssembly psa, List<PdbxStructAssemblyGen> psags, List<PdbxStructOperList> operators) {
        this.init();
        this.psags = psags;
        for (PdbxStructOperList oper : operators) {
            BiologicalAssemblyTransformation transform = new BiologicalAssemblyTransformation();
            transform.setId(oper.getId());
            transform.setRotationMatrix(oper.getMatrix().getArray());
            transform.setTranslation(oper.getVector());
            this.modelTransformations.add(transform);
        }
        ArrayList<BiologicalAssemblyTransformation> transformations = this.getBioUnitTransformationsListUnaryOperators(psa.getId());
        transformations.addAll(this.getBioUnitTransformationsListBinaryOperators(psa.getId()));
        transformations.trimToSize();
        return transformations;
    }

    private ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationsListBinaryOperators(String assemblyId) {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        List<OrderedPair<String>> operators = this.operatorResolver.getBinaryOperators();
        for (PdbxStructAssemblyGen psag : this.psags) {
            if (!psag.getAssembly_id().equals(assemblyId)) continue;
            List<String> asymIds = Arrays.asList(psag.getAsym_id_list().split(","));
            this.operatorResolver.parseOperatorExpressionString(psag.getOper_expression());
            for (String chainId : asymIds) {
                int modelNumber = 1;
                for (OrderedPair<String> operator : operators) {
                    BiologicalAssemblyTransformation original1 = this.getModelTransformationMatrix(operator.getElement1());
                    BiologicalAssemblyTransformation original2 = this.getModelTransformationMatrix(operator.getElement2());
                    BiologicalAssemblyTransformation transform = BiologicalAssemblyTransformation.combine(original1, original2);
                    transform.setChainId(chainId);
                    transform.setId(String.valueOf(modelNumber));
                    transformations.add(transform);
                    ++modelNumber;
                }
            }
        }
        return transformations;
    }

    private BiologicalAssemblyTransformation getModelTransformationMatrix(String operator) {
        for (BiologicalAssemblyTransformation transform : this.modelTransformations) {
            if (!transform.getId().equals(operator)) continue;
            return transform;
        }
        logger.error("Could not find modelTransformationmatrix for " + operator);
        return new BiologicalAssemblyTransformation();
    }

    private ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationsListUnaryOperators(String assemblyId) {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        for (PdbxStructAssemblyGen psag : this.psags) {
            if (!psag.getAssembly_id().equals(assemblyId)) continue;
            this.operatorResolver.parseOperatorExpressionString(psag.getOper_expression());
            List<String> operators = this.operatorResolver.getUnaryOperators();
            List<String> asymIds = Arrays.asList(psag.getAsym_id_list().split(","));
            for (String chainId : asymIds) {
                for (String operator : operators) {
                    BiologicalAssemblyTransformation original = this.getModelTransformationMatrix(operator);
                    BiologicalAssemblyTransformation transform = new BiologicalAssemblyTransformation(original);
                    transform.setChainId(chainId);
                    transform.setId(operator);
                    transformations.add(transform);
                }
            }
        }
        return transformations;
    }

    private void init() {
        this.operatorResolver = new OperatorResolver();
        this.modelTransformations = new ArrayList<BiologicalAssemblyTransformation>(1);
    }
}

