/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.ResidueRangeAndLength;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomPositionMap {
    private static final Logger logger = LoggerFactory.getLogger(AtomPositionMap.class);
    private HashMap<ResidueNumber, Integer> hashMap = new HashMap();
    private TreeMap<ResidueNumber, Integer> treeMap;
    public static final GroupMatcher AMINO_ACID_MATCHER = new GroupMatcher(){

        @Override
        public boolean matches(Group group) {
            ResidueType type;
            if (group == null) {
                return false;
            }
            ChemComp chem = group.getChemComp();
            if (chem == null) {
                return false;
            }
            PolymerType polyType = chem.getPolymerType();
            if (polyType == null && (type = chem.getResidueType()) != null) {
                polyType = type.getPolymerType();
            }
            if (polyType == null) {
                return false;
            }
            return PolymerType.PROTEIN_ONLY.contains(polyType) && group.hasAtom("CA");
        }
    };
    public static final GroupMatcher ANYTHING_MATCHER = new GroupMatcher(){

        @Override
        public boolean matches(Group group) {
            return true;
        }
    };

    public AtomPositionMap(Atom[] atoms) {
        this(atoms, AMINO_ACID_MATCHER);
    }

    public AtomPositionMap(Atom[] atoms, GroupMatcher matcher) {
        for (int i = 0; i < atoms.length; ++i) {
            Group group = atoms[i].getGroup();
            ResidueNumber rn = group.getResidueNumber();
            if (!matcher.matches(group) || this.hashMap.containsKey(rn)) continue;
            this.hashMap.put(rn, i);
        }
        ValueComparator<ResidueNumber, Integer> vc = new ValueComparator<ResidueNumber, Integer>(this.hashMap);
        this.treeMap = new TreeMap(vc);
        this.treeMap.putAll(this.hashMap);
    }

    public AtomPositionMap(Structure s) {
        this(StructureTools.getRepresentativeAtomArray(s));
    }

    public int getLength(int positionA, int positionB, String startingChain) {
        int positionEnd;
        int positionStart;
        if (positionA <= positionB) {
            positionStart = positionA;
            positionEnd = positionB;
        } else {
            positionStart = positionB;
            positionEnd = positionA;
        }
        int count = 0;
        for (Map.Entry<ResidueNumber, Integer> entry : this.treeMap.entrySet()) {
            if (!entry.getKey().getChainName().equals(startingChain) || positionStart > entry.getValue() || entry.getValue() > positionEnd) continue;
            ++count;
        }
        return count;
    }

    public int getLengthDirectional(int positionStart, int positionEnd, String startingChain) {
        int count = this.getLength(positionStart, positionEnd, startingChain);
        if (positionStart <= positionEnd) {
            return count;
        }
        return -count;
    }

    public int getLength(ResidueNumber start, ResidueNumber end) {
        if (!start.getChainName().equals(end.getChainName())) {
            throw new IllegalArgumentException(String.format("Chains differ between %s and %s. Unable to calculate length.", start, end));
        }
        Integer startPos = this.getPosition(start);
        Integer endPos = this.getPosition(end);
        if (startPos == null) {
            throw new IllegalArgumentException("Residue " + start + " was not found.");
        }
        if (endPos == null) {
            throw new IllegalArgumentException("Residue " + start + " was not found.");
        }
        return this.getLength(startPos, endPos, start.getChainName());
    }

    public int getLengthDirectional(ResidueNumber start, ResidueNumber end) {
        if (!start.getChainName().equals(end.getChainName())) {
            throw new IllegalArgumentException(String.format("Chains differ between %s and %s. Unable to calculate length.", start, end));
        }
        Integer startPos = this.getPosition(start);
        Integer endPos = this.getPosition(end);
        if (startPos == null) {
            throw new IllegalArgumentException("Residue " + start + " was not found.");
        }
        if (endPos == null) {
            throw new IllegalArgumentException("Residue " + start + " was not found.");
        }
        return this.getLengthDirectional(startPos, endPos, start.getChainName());
    }

    public NavigableMap<ResidueNumber, Integer> getNavMap() {
        return this.treeMap;
    }

    public Integer getPosition(ResidueNumber residueNumber) {
        return this.hashMap.get(residueNumber);
    }

    public ResidueNumber getFirst(String chainId) {
        Map.Entry<ResidueNumber, Integer> entry = this.treeMap.firstEntry();
        do {
            if (!entry.getKey().getChainName().equals(chainId)) continue;
            return entry.getKey();
        } while ((entry = this.treeMap.higherEntry(entry.getKey())) != null);
        return null;
    }

    public ResidueNumber getLast(String chainId) {
        Map.Entry<ResidueNumber, Integer> entry = this.treeMap.lastEntry();
        do {
            if (!entry.getKey().getChainName().equals(chainId)) continue;
            return entry.getKey();
        } while ((entry = this.treeMap.lowerEntry(entry.getKey())) != null);
        return null;
    }

    public ResidueNumber getFirst() {
        return this.treeMap.firstKey();
    }

    public ResidueNumber getLast() {
        return this.treeMap.lastKey();
    }

    public List<ResidueRangeAndLength> getRanges() {
        String currentChain = "";
        ResidueNumber first = null;
        ResidueNumber prev = null;
        ArrayList<ResidueRangeAndLength> ranges = new ArrayList<ResidueRangeAndLength>();
        for (ResidueNumber rn : this.treeMap.keySet()) {
            if (!rn.getChainName().equals(currentChain)) {
                if (first != null) {
                    ResidueRangeAndLength newRange = new ResidueRangeAndLength(currentChain, first, prev, this.getLength(first, prev));
                    ranges.add(newRange);
                }
                first = rn;
            }
            prev = rn;
            currentChain = rn.getChainName();
        }
        ResidueRangeAndLength newRange = new ResidueRangeAndLength(currentChain, first, prev, this.getLength(first, prev));
        ranges.add(newRange);
        return ranges;
    }

    public ResidueRangeAndLength trimToValidResidues(ResidueRange rr) {
        Integer endIndex;
        Integer startIndex;
        ResidueNumber start = rr.getStart();
        ResidueNumber end = rr.getEnd();
        String chain = rr.getChainName();
        if (start.getChainName() == null) {
            start = new ResidueNumber(chain, start.getSeqNum(), start.getInsCode());
        }
        if (end.getChainName() == null) {
            end = new ResidueNumber(chain, end.getSeqNum(), end.getInsCode());
        }
        if ((startIndex = this.getPosition(start)) == null) {
            for (ResidueNumber residueNumber : this.treeMap.keySet()) {
                if (!residueNumber.getChainName().equals(chain) || start.getSeqNum() > residueNumber.getSeqNum()) continue;
                start = residueNumber;
                startIndex = this.getPosition(residueNumber);
                break;
            }
            if (startIndex == null) {
                logger.error("Unable to find Residue {} in AtomPositionMap, and no plausible substitute.", (Object)start);
                return null;
            }
            logger.warn("Unable to find Residue {}, so substituting {}.", (Object)rr.getStart(), (Object)start);
        }
        if ((endIndex = this.getPosition(end)) == null) {
            for (ResidueNumber key : this.treeMap.descendingKeySet()) {
                if (!key.getChainName().equals(chain)) continue;
                Integer value = this.getPosition(key);
                if (value < startIndex) break;
                if (end.getSeqNum() < key.getSeqNum()) continue;
                end = key;
                endIndex = value;
                break;
            }
            if (endIndex == null) {
                logger.error("Unable to find Residue {} in AtomPositionMap, and no plausible substitute.", (Object)end);
                return null;
            }
            logger.warn("Unable to find Residue {}, so substituting {}.", (Object)rr.getEnd(), (Object)end);
        }
        int n = this.getLength(startIndex, endIndex, chain);
        return new ResidueRangeAndLength(chain, start, end, n);
    }

    private static class ValueComparator<T, V extends Comparable<V>>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<T, V> map;

        public ValueComparator(Map<T, V> map) {
            this.map = map;
        }

        @Override
        public int compare(T o1, T o2) {
            return ((Comparable)this.map.get(o1)).compareTo((Comparable)this.map.get(o2));
        }
    }

    public static interface GroupMatcher {
        public boolean matches(Group var1);
    }
}

