/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif.chem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;

public class ChemCompTools {
    private static final Character UNKNOWN_ONE_LETTER_CODE = Character.valueOf('X');
    private static final Character UNKNOWN_NUCLEOTIDE = Character.valueOf('N');
    private static final Map<String, Character> AMINO_ACID_LOOKUP_3TO1;
    private static final Map<Character, String> AMINO_ACID_LOOKUP_1TO3;
    private static final Map<String, Character> DNA_LOOKUP_2TO1;
    private static final Map<Character, String> DNA_LOOKUP_1TO2;

    public static Character getAminoOneLetter(String chemCompId) {
        return AMINO_ACID_LOOKUP_3TO1.get(chemCompId);
    }

    public static Character getDNAOneLetter(String chemCompId) {
        return DNA_LOOKUP_2TO1.get(chemCompId);
    }

    public static String getAminoThreeLetter(Character c) {
        return AMINO_ACID_LOOKUP_1TO3.get(c);
    }

    public static String getDNATwoLetter(Character c) {
        return DNA_LOOKUP_1TO2.get(c);
    }

    public static final boolean isStandardChemComp(ChemComp cc) {
        String pid = cc.getMon_nstd_parent_comp_id();
        String one = cc.getOne_letter_code();
        PolymerType polymerType = cc.getPolymerType();
        if ((pid == null || pid.equals("?")) && one != null && !one.equals("?")) {
            if (polymerType == PolymerType.peptide || polymerType == PolymerType.dpeptide) {
                return ChemCompTools.performPeptideCheck(cc, one);
            }
            if (polymerType == PolymerType.rna) {
                return ChemCompTools.performRNACheck(cc);
            }
            if (polymerType == PolymerType.dna) {
                return ChemCompTools.performDNACheck(cc);
            }
            return false;
        }
        return false;
    }

    private static boolean performRNACheck(ChemComp cc) {
        return cc.getId().length() == 1;
    }

    private static boolean performDNACheck(ChemComp cc) {
        if (cc.getId().equals(UNKNOWN_NUCLEOTIDE.toString())) {
            return false;
        }
        Character c = ChemCompTools.getDNAOneLetter(cc.getId());
        return c != null;
    }

    private static boolean performPeptideCheck(ChemComp cc, String one) {
        if (one.equals(UNKNOWN_ONE_LETTER_CODE.toString())) {
            return false;
        }
        Character c = ChemCompTools.getAminoOneLetter(cc.getId());
        return c != null;
    }

    public static Character getOneLetterCode(ChemComp cc, ChemicalComponentDictionary dictionary) {
        if (cc.getResidueType() == ResidueType.nonPolymer) {
            return null;
        }
        if (cc.isStandard()) {
            return Character.valueOf(cc.getOne_letter_code().charAt(0));
        }
        ChemComp parent = dictionary.getParent(cc);
        if (parent == null) {
            return Character.valueOf(cc.getOne_letter_code().charAt(0));
        }
        PolymerType poly = cc.getPolymerType();
        if (poly == PolymerType.peptide || poly == PolymerType.dpeptide) {
            Character c = ChemCompTools.getAminoOneLetter(parent.getId());
            if (c == null) {
                c = UNKNOWN_ONE_LETTER_CODE;
            }
            return c;
        }
        if (poly == PolymerType.dna) {
            Character c = ChemCompTools.getDNAOneLetter(parent.getId());
            if (c == null) {
                c = UNKNOWN_NUCLEOTIDE;
            }
            return c;
        }
        return Character.valueOf(cc.getMon_nstd_parent_comp_id().charAt(0));
    }

    static {
        HashMap<String, Character> foo = new HashMap<String, Character>();
        foo.put("ALA", Character.valueOf('A'));
        foo.put("ASP", Character.valueOf('D'));
        foo.put("ASN", Character.valueOf('N'));
        foo.put("ASX", Character.valueOf('B'));
        foo.put("ARG", Character.valueOf('R'));
        foo.put("CYS", Character.valueOf('C'));
        foo.put("GLU", Character.valueOf('E'));
        foo.put("GLN", Character.valueOf('Q'));
        foo.put("GLY", Character.valueOf('G'));
        foo.put("GLX", Character.valueOf('Z'));
        foo.put("HIS", Character.valueOf('H'));
        foo.put("ILE", Character.valueOf('I'));
        foo.put("LYS", Character.valueOf('K'));
        foo.put("LEU", Character.valueOf('L'));
        foo.put("MET", Character.valueOf('M'));
        foo.put("PHE", Character.valueOf('F'));
        foo.put("PRO", Character.valueOf('P'));
        foo.put("SER", Character.valueOf('S'));
        foo.put("THR", Character.valueOf('T'));
        foo.put("TRP", Character.valueOf('W'));
        foo.put("TYR", Character.valueOf('Y'));
        foo.put("VAL", Character.valueOf('V'));
        AMINO_ACID_LOOKUP_3TO1 = Collections.unmodifiableMap(Collections.synchronizedMap(foo));
        HashMap<Character, String> bar = new HashMap<Character, String>();
        bar.put(Character.valueOf('A'), "ALA");
        bar.put(Character.valueOf('D'), "ASP");
        bar.put(Character.valueOf('N'), "ASN");
        bar.put(Character.valueOf('B'), "ASX");
        bar.put(Character.valueOf('R'), "ARG");
        bar.put(Character.valueOf('C'), "CYS");
        bar.put(Character.valueOf('E'), "GLU");
        bar.put(Character.valueOf('Q'), "GLN");
        bar.put(Character.valueOf('G'), "GLY");
        bar.put(Character.valueOf('Z'), "GLX");
        bar.put(Character.valueOf('H'), "HIS");
        bar.put(Character.valueOf('I'), "ILE");
        bar.put(Character.valueOf('K'), "LYS");
        bar.put(Character.valueOf('L'), "LEU");
        bar.put(Character.valueOf('M'), "MET");
        bar.put(Character.valueOf('F'), "PHE");
        bar.put(Character.valueOf('P'), "PRO");
        bar.put(Character.valueOf('S'), "SER");
        bar.put(Character.valueOf('T'), "THR");
        bar.put(Character.valueOf('W'), "TRP");
        bar.put(Character.valueOf('Y'), "TYR");
        bar.put(Character.valueOf('V'), "VAL");
        AMINO_ACID_LOOKUP_1TO3 = Collections.unmodifiableMap(Collections.synchronizedMap(bar));
        foo = new HashMap();
        foo.put("DA", Character.valueOf('A'));
        foo.put("DC", Character.valueOf('C'));
        foo.put("DG", Character.valueOf('G'));
        foo.put("DI", Character.valueOf('I'));
        foo.put("DU", Character.valueOf('U'));
        foo.put("DT", Character.valueOf('T'));
        DNA_LOOKUP_2TO1 = Collections.unmodifiableMap(Collections.synchronizedMap(foo));
        bar = new HashMap();
        bar.put(Character.valueOf('A'), "DA");
        bar.put(Character.valueOf('C'), "DC");
        bar.put(Character.valueOf('G'), "DG");
        bar.put(Character.valueOf('I'), "DI");
        bar.put(Character.valueOf('U'), "DU");
        bar.put(Character.valueOf('T'), "DT");
        DNA_LOOKUP_1TO2 = Collections.unmodifiableMap(Collections.synchronizedMap(bar));
        ArrayList<String> stdMonIds = new ArrayList<String>();
        stdMonIds.addAll(AMINO_ACID_LOOKUP_3TO1.keySet());
        stdMonIds.addAll(DNA_LOOKUP_2TO1.keySet());
    }
}

