/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.cif;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.chem.MetalBondDistance;
import org.biojava.nbio.structure.io.cif.MetalBondConsumer;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.StrColumn;

public class MetalBondConsumerImpl
implements MetalBondConsumer {
    private final Map<String, List<MetalBondDistance>> definitions = new HashMap<String, List<MetalBondDistance>>();

    @Override
    public void prepare() {
        this.definitions.clear();
    }

    @Override
    public void finish() {
        for (List<MetalBondDistance> d : this.definitions.values()) {
            ((ArrayList)d).trimToSize();
        }
    }

    @Override
    public void consume(Category category) {
        StrColumn atomType1 = (StrColumn)category.getColumn("atom_type_1");
        StrColumn atomType2 = (StrColumn)category.getColumn("atom_type_2");
        StrColumn lowerLimit = (StrColumn)category.getColumn("lower_limit");
        StrColumn upperLimit = (StrColumn)category.getColumn("upper_limit");
        for (int i = 0; i < category.getRowCount(); ++i) {
            MetalBondDistance d = new MetalBondDistance();
            d.setAtomType1(atomType1.get(i));
            d.setAtomType2(atomType2.get(i));
            d.setLowerLimit(Float.parseFloat(lowerLimit.get(i)));
            d.setUpperLimit(Float.parseFloat(upperLimit.get(i)));
            List defs = this.definitions.computeIfAbsent(d.getAtomType1(), k -> new ArrayList());
            defs.add(d);
        }
    }

    @Override
    public Map<String, List<MetalBondDistance>> getContainer() {
        return this.definitions;
    }
}

