/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.chem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.align.util.URLConnectionTools;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.chem.AllChemCompProvider;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompProvider;
import org.biojava.nbio.structure.chem.ChemicalComponentDictionary;
import org.biojava.nbio.structure.chem.ReducedChemCompProvider;
import org.biojava.nbio.structure.io.cif.ChemCompConverter;
import org.rcsb.cif.ParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadChemCompProvider
implements ChemCompProvider {
    private static final Logger logger = LoggerFactory.getLogger(DownloadChemCompProvider.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String CHEM_COMP_CACHE_DIRECTORY = "chemcomp";
    public static final String DEFAULT_SERVER_URL = "https://files.rcsb.org/ligands/download/";
    public static final String DEFAULT_CHEMCOMP_PATHURL_TEMPLATE = "{ccd_id}.cif";
    public static String serverBaseUrl = "https://files.rcsb.org/ligands/download/";
    private static File path;
    private static String chemCompPathUrlTemplate;
    static final Pattern CCD_ID_TEMPLATE_REGEX;
    static AtomicBoolean loading;
    static final List<String> protectedIDs;
    private static ChemCompProvider fallback;
    boolean downloadAll = false;

    public DownloadChemCompProvider() {
        this(null);
    }

    public DownloadChemCompProvider(String cacheFilePath) {
        logger.debug("Initialising DownloadChemCompProvider");
        if (cacheFilePath != null) {
            path = new File(cacheFilePath);
        }
    }

    public static void setServerBaseUrl(String serverBaseUrl) {
        if (!((String)serverBaseUrl).endsWith("/")) {
            serverBaseUrl = (String)serverBaseUrl + "/";
        }
        DownloadChemCompProvider.serverBaseUrl = serverBaseUrl;
    }

    public static void setChemCompPathUrlTemplate(String chemCompPathUrlTemplate) {
        DownloadChemCompProvider.chemCompPathUrlTemplate = chemCompPathUrlTemplate;
    }

    public static File getPath() {
        if (path == null) {
            UserConfiguration config = new UserConfiguration();
            path = new File(config.getCacheFilePath());
        }
        return path;
    }

    public void checkDoFirstInstall() {
        if (!this.downloadAll) {
            return;
        }
        File dir = new File(DownloadChemCompProvider.getPath(), CHEM_COMP_CACHE_DIRECTORY);
        File f = new File(dir, "components.cif.gz");
        if (!f.exists()) {
            this.downloadAllDefinitions();
        } else {
            FilenameFilter filter = (dir1, file) -> file.endsWith(".cif.gz");
            String[] files = dir.list(filter);
            if (files.length < 500) {
                try {
                    this.split();
                }
                catch (IOException e) {
                    logger.error("Could not split file {} into individual chemical component files. Error: {}", (Object)f.toString(), (Object)e.getMessage());
                }
            }
        }
    }

    private void split() throws IOException {
        logger.info("Installing individual chem comp files ...");
        File dir = new File(DownloadChemCompProvider.getPath(), CHEM_COMP_CACHE_DIRECTORY);
        File f = new File(dir, "components.cif.gz");
        int counter = 0;
        InputStreamProvider prov = new InputStreamProvider();
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(prov.getInputStream(f)));){
            String line = buf.readLine();
            StringWriter writer = new StringWriter();
            String currentID = null;
            while (line != null) {
                if (line.startsWith("data_")) {
                    if (currentID != null) {
                        this.writeID(writer.toString(), currentID);
                        ++counter;
                    }
                    currentID = line.substring(5);
                    writer = new StringWriter();
                }
                writer.append(line);
                writer.append(NEWLINE);
                line = buf.readLine();
            }
            this.writeID(writer.toString(), currentID);
        }
        logger.info("Created {} chemical component files.", (Object)(++counter));
    }

    private void writeID(String contents, String currentID) throws IOException {
        String localName = DownloadChemCompProvider.getLocalFileName(currentID);
        try (PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(localName)));){
            pw.print(contents);
            pw.flush();
        }
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        recordName = recordName.toUpperCase().trim();
        boolean haveFile = true;
        if (recordName.equals("?")) {
            return null;
        }
        if (DownloadChemCompProvider.fileIsAbsent(recordName)) {
            this.checkDoFirstInstall();
        }
        if (DownloadChemCompProvider.fileIsAbsent(recordName)) {
            haveFile = DownloadChemCompProvider.downloadChemCompRecord(recordName);
        }
        if (haveFile) {
            String filename = DownloadChemCompProvider.getLocalFileName(recordName);
            try {
                ChemComp chemComp;
                try {
                    ChemicalComponentDictionary dict = ChemCompConverter.fromPath(Paths.get(filename, new String[0]));
                    chemComp = dict.getChemComp(recordName);
                }
                catch (ParsingException e) {
                    chemComp = null;
                }
                if (chemComp != null) {
                    return chemComp;
                }
            }
            catch (IOException e) {
                logger.warn("Could not download chemical component file {} for {}. Error: {}. Now trying to use the local chemical component definitions.", new Object[]{filename, recordName, e.getMessage()});
            }
        }
        if (fallback == null) {
            fallback = new ReducedChemCompProvider();
        }
        logger.warn("Falling back to ReducedChemCompProvider for {}. This could indicate a network error.", (Object)recordName);
        return fallback.getChemComp(recordName);
    }

    public static String getLocalFileName(String recordName) {
        File f;
        if (protectedIDs.contains(recordName)) {
            recordName = "_" + (String)recordName;
        }
        if (!(f = new File(DownloadChemCompProvider.getPath(), CHEM_COMP_CACHE_DIRECTORY)).exists()) {
            logger.info("Creating directory {}", (Object)f);
            boolean success = f.mkdir();
            if (!success) {
                logger.error("Directory {} could not be created", (Object)f);
            }
        }
        File theFile = new File(f, (String)recordName + ".cif.gz");
        return theFile.toString();
    }

    private static boolean fileIsAbsent(String recordName) {
        String fileName = DownloadChemCompProvider.getLocalFileName(recordName);
        File f = new File(fileName);
        if (f.length() < 40L) {
            f.delete();
            return true;
        }
        return !f.exists();
    }

    static String expandPathUrlTemplate(String templateStr, String ccdId) {
        Matcher m = CCD_ID_TEMPLATE_REGEX.matcher(templateStr);
        StringBuilder output = new StringBuilder();
        int lastIndex = 0;
        while (m.find()) {
            String repString = ccdId;
            String indicesStr = m.group(1);
            try {
                if (indicesStr == null) {
                    repString = ccdId;
                } else if (!indicesStr.contains("_")) {
                    int idx = Integer.parseInt(indicesStr);
                    repString = idx < 0 ? ccdId.substring(ccdId.length() + idx) : ccdId.substring(0, idx);
                } else if (indicesStr.contains("_")) {
                    String[] tokens = indicesStr.split("_");
                    int begIdx = Integer.parseInt(tokens[0]);
                    int endIdx = Integer.parseInt(tokens[1]);
                    repString = ccdId.substring(begIdx, endIdx);
                }
            }
            catch (IndexOutOfBoundsException e) {
                logger.debug("Indices included in path URL template {} are out of bounds for string {}", (Object)templateStr, (Object)ccdId);
            }
            output.append(templateStr, lastIndex, m.start()).append(repString);
            lastIndex = m.end();
        }
        if (lastIndex < templateStr.length()) {
            output.append(templateStr, lastIndex, templateStr.length());
        }
        return output.toString();
    }

    private static boolean downloadChemCompRecord(String recordName) {
        File newFile;
        String localName = DownloadChemCompProvider.getLocalFileName(recordName);
        try {
            newFile = Files.createTempFile(CHEM_COMP_CACHE_DIRECTORY + recordName, "cif", new FileAttribute[0]).toFile();
            logger.debug("Will write chem comp file to temp file {}", (Object)newFile.toString());
        }
        catch (IOException e) {
            logger.error("Could not write to temp directory {} to create the chemical component download temp file", (Object)System.getProperty("java.io.tmpdir"));
            return false;
        }
        String u = serverBaseUrl + DownloadChemCompProvider.expandPathUrlTemplate(chemCompPathUrlTemplate, recordName);
        logger.debug("Downloading chem comp definition from {}", (Object)u);
        URL url = null;
        try {
            url = new URL(u);
            URLConnection uconn = URLConnectionTools.openURLConnection(url);
            try (PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(newFile)));
                 BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(uconn.getInputStream()));){
                String line;
                boolean success = false;
                while ((line = fileBuffer.readLine()) != null) {
                    pw.println(line);
                    success = true;
                }
                if (!success) {
                    throw new IOException("Malformed URL or no content found in " + url.toString());
                }
                pw.flush();
            }
            Files.move(newFile.toPath(), Paths.get(localName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            logger.error("Could not download {} OR store locally to {} Error ={}", new Object[]{url, localName, e.getMessage()});
            newFile.delete();
            return false;
        }
    }

    private void downloadAllDefinitions() {
        if (loading.get()) {
            logger.info("Waiting for other thread to install chemical components...");
        }
        if (loading.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted " + e.getMessage());
            }
            logger.info("Another thread installed the chemical components.");
            return;
        }
        loading.set(true);
        long timeS = System.currentTimeMillis();
        logger.info("Performing first installation of chemical components.");
        logger.info("Downloading components.cif.gz ...");
        try {
            AllChemCompProvider.downloadFile();
        }
        catch (IOException e) {
            logger.error("Could not download the all chemical components file. Error: {}. Chemical components information won't be available", (Object)e.getMessage());
            loading.set(false);
            return;
        }
        try {
            this.split();
        }
        catch (IOException e) {
            logger.error("Could not split all chem comp file into individual chemical component files. Error: {}", (Object)e.getMessage());
            loading.set(false);
            return;
        }
        long timeE = System.currentTimeMillis();
        logger.info("time to install chem comp dictionary: " + (timeE - timeS) / 1000L + " sec.");
        loading.set(false);
    }

    public boolean isDownloadAll() {
        return this.downloadAll;
    }

    public void setDownloadAll(boolean downloadAll) {
        this.downloadAll = downloadAll;
    }

    static {
        chemCompPathUrlTemplate = DEFAULT_CHEMCOMP_PATHURL_TEMPLATE;
        CCD_ID_TEMPLATE_REGEX = Pattern.compile("\\{ccd_id(?::(\\d+_\\d+|[-+]?\\d+))?}");
        loading = new AtomicBoolean(false);
        protectedIDs = new ArrayList<String>();
        protectedIDs.add("CON");
        protectedIDs.add("PRN");
        protectedIDs.add("AUX");
        protectedIDs.add("NUL");
        fallback = null;
    }
}

