/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.BoundingBox;
import org.biojava.nbio.structure.contact.StructureInterface;
import org.biojava.nbio.structure.contact.StructureInterfaceList;
import org.biojava.nbio.structure.xtal.CrystalTransform;
import org.biojava.nbio.structure.xtal.SpaceGroup;

public class InterfaceFinder {
    public static final double DEFAULT_CONTACT_CUTOFF = 6.0;
    private static final CrystalTransform IDENTITY_TRANSFORM = new CrystalTransform((SpaceGroup)null);
    private static final boolean INCLUDE_HETATOMS = true;
    private List<Chain> polyChains;
    private double cutoff;
    private BoundingBox[] boundingBoxes;

    public InterfaceFinder(Structure structure) {
        this.polyChains = new ArrayList<Chain>(structure.getPolyChains());
        this.trimPolyChains();
        this.cutoff = 6.0;
    }

    private void trimPolyChains() {
        this.polyChains.removeIf(chain -> {
            int count = chain.getAtomGroups().stream().map(Group::getAtoms).mapToInt(Collection::size).sum();
            return count == 0;
        });
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    public StructureInterfaceList getAllInterfaces() {
        this.initBoundingBoxes();
        StructureInterfaceList list = new StructureInterfaceList();
        for (int i = 0; i < this.polyChains.size(); ++i) {
            for (int j = i + 1; j < this.polyChains.size(); ++j) {
                StructureInterface interf;
                if (!this.boundingBoxes[i].overlaps(this.boundingBoxes[j], this.cutoff) || (interf = this.calcInterface(this.polyChains.get(i), this.polyChains.get(j))) == null) continue;
                list.add(interf);
            }
        }
        return list;
    }

    private void initBoundingBoxes() {
        this.boundingBoxes = new BoundingBox[this.polyChains.size()];
        for (int i = 0; i < this.polyChains.size(); ++i) {
            BoundingBox bb;
            Atom[] atoms = StructureTools.getAllNonHAtomArray(this.polyChains.get(i), true);
            Point3d[] points = Calc.atomsToPoints(atoms);
            this.boundingBoxes[i] = bb = new BoundingBox(points);
        }
    }

    private StructureInterface calcInterface(Chain chain1, Chain chain2) {
        AtomContactSet graph = StructureTools.getAtomsInContact(chain1, chain2, this.cutoff, true);
        StructureInterface interf = null;
        if (graph.size() > 0) {
            interf = new StructureInterface(StructureTools.getAllNonHAtomArray(chain1, true), StructureTools.getAllNonHAtomArray(chain2, true), chain1.getName(), chain2.getName(), graph, IDENTITY_TRANSFORM, IDENTITY_TRANSFORM);
        }
        return interf;
    }
}

