/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomIterator
implements Iterator<Atom> {
    private static final Logger logger = LoggerFactory.getLogger(AtomIterator.class);
    private Group group;
    private int current_atom_pos;
    private GroupIterator groupiter;

    public AtomIterator(Structure struct) {
        this.current_atom_pos = -1;
        this.groupiter = new GroupIterator(struct);
        this.group = this.groupiter.hasNext() ? this.groupiter.next() : null;
    }

    public AtomIterator(Structure struct, int modelNr) {
        this.current_atom_pos = -1;
        this.groupiter = new GroupIterator(struct, modelNr);
        this.group = this.groupiter.hasNext() ? this.groupiter.next() : null;
    }

    public Chain getCurrentChain() {
        return this.groupiter.getCurrentChain();
    }

    public int getCurrentModel() {
        return this.groupiter.getCurrentModel();
    }

    public AtomIterator(Group g) {
        this.group = g;
        this.current_atom_pos = -1;
        this.groupiter = null;
    }

    @Override
    public boolean hasNext() {
        if (this.group == null) {
            return false;
        }
        if (this.current_atom_pos < this.group.size() - 1) {
            return true;
        }
        if (this.groupiter != null) {
            GroupIterator tmp = (GroupIterator)this.groupiter.clone();
            while (tmp.hasNext()) {
                Group tmpg = tmp.next();
                if (tmpg.size() <= 0) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    @Override
    public Atom next() {
        ++this.current_atom_pos;
        if (this.current_atom_pos >= this.group.size()) {
            if (this.groupiter == null) {
                throw new NoSuchElementException("no more atoms found in group!");
            }
            if (this.groupiter.hasNext()) {
                this.group = this.groupiter.next();
                this.current_atom_pos = -1;
                return this.next();
            }
            throw new NoSuchElementException("no more atoms found in structure!");
        }
        Atom a = this.group.getAtom(this.current_atom_pos);
        if (a == null) {
            logger.error("current_atom_pos {} group {} size: {}", new Object[]{this.current_atom_pos, this.group, this.group.size()});
            throw new NoSuchElementException("error wile trying to retrieve atom");
        }
        return a;
    }

    @Override
    public void remove() {
    }
}

