/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.ElementType;

public enum Element {
    H(1, 1, 39, 1.1f, 0.32f, 1, 1, 1, 1, 1, 1.008f, 0, 1, new int[]{1}, 2.2f, ElementType.OTHER_NONMETAL),
    C(6, 2, 0, 1.55f, 0.77f, 4, 4, 4, 4, 4, 12.011f, 2, -4, new int[]{-4, -3, -2, 0, -1, 1, 2, 3, 4}, 2.55f, ElementType.OTHER_NONMETAL),
    N(7, 2, 57, 1.4f, 0.75f, 5, 2, 5, 3, 4, 14.007f, 2, -3, new int[]{-3, -2, -1, 0, 1, 2, 3, 4, 5}, 3.04f, ElementType.OTHER_NONMETAL),
    O(8, 2, 65, 1.35f, 0.73f, 6, 1, 2, 2, 2, 16.0f, 2, -2, new int[]{-2, -1, 0, 1, 2}, 3.44f, ElementType.OTHER_NONMETAL),
    D(1, 1, 27, 1.1f, 0.32f, 1, 1, 1, 1, 1, 1.008f, 0, 1, new int[]{0, 1}, 2.2f, ElementType.OTHER_NONMETAL),
    T(1, 1, 90, 1.1f, 0.32f, 1, 1, 1, 1, 1, 1.008f, 0, 1, new int[]{0, 1}, 2.2f, ElementType.OTHER_NONMETAL),
    He(2, 1, 40, 2.2f, 1.6f, 2, 0, 12, 0, 0, 4.003f, 2, 0, new int[]{0}, 0.0f, ElementType.NOBLE_GAS),
    Li(3, 2, 50, 1.22f, 1.34f, 1, 0, 12, 0, 1, 6.94f, 2, 1, new int[]{0, 1}, 0.98f, ElementType.ALKALI_METAL),
    Be(4, 2, 12, 0.63f, 0.9f, 2, 0, 12, 2, 2, 9.012f, 2, 2, new int[]{0, 1, 2}, 1.57f, ElementType.TRANSITION_METAL),
    B(5, 2, 10, 1.55f, 0.82f, 3, 3, 5, 3, 4, 10.81f, 2, 3, new int[]{0, 1, 2, 3}, 2.04f, ElementType.METALLOID),
    F(9, 2, 32, 1.3f, 0.72f, 7, 0, 1, 1, 1, 18.998f, 2, -1, new int[]{-1, 0, 1}, 3.98f, ElementType.HALOGEN),
    Ne(10, 2, 61, 2.02f, 1.12f, 8, 0, 12, 0, 0, 20.17f, 10, 0, new int[0], 0.0f, ElementType.NOBLE_GAS),
    Na(11, 3, 58, 2.2f, 1.54f, 1, 0, 1, 0, 0, 22.99f, 10, 1, new int[]{-1, 0, 1}, 0.93f, ElementType.ALKALI_METAL),
    Mg(12, 3, 54, 1.5f, 1.3f, 2, 0, 2, 0, 2, 24.305f, 10, 2, new int[]{0, 1, 2}, 1.31f, ElementType.ALKALINE_EARTH_METAL),
    Al(13, 3, 4, 1.5f, 1.18f, 3, 0, 5, 0, 4, 26.982f, 10, 3, new int[]{0, 1, 2, 3}, 1.61f, ElementType.POST_TRANSITION_METAL),
    Si(14, 3, 86, 2.2f, 1.11f, 4, 4, 4, 4, 4, 28.086f, 10, 4, new int[]{-4, -3, -2, -1, 0, 1, 2, 3, 4}, 1.9f, ElementType.METALLOID),
    P(15, 3, 67, 1.88f, 1.06f, 5, 3, 5, 3, 5, 30.974f, 10, 5, new int[]{-3, -2, -1, 0, 1, 2, 3, 4, 5}, 2.19f, ElementType.OTHER_NONMETAL),
    S(16, 3, 82, 1.81f, 1.02f, 6, 2, 6, 2, 6, 32.06f, 10, -2, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6}, 2.58f, ElementType.OTHER_NONMETAL),
    Cl(17, 3, 21, 1.75f, 0.99f, 7, 0, 1, 1, 1, 35.453f, 10, -1, new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7}, 3.16f, ElementType.HALOGEN),
    Ar(18, 4, 6, 2.77f, 1.54f, 8, 0, 12, 0, 0, 39.948f, 18, 0, new int[]{0}, 0.0f, ElementType.NOBLE_GAS),
    K(19, 4, 47, 2.39f, 1.96f, 1, 0, 12, 0, 0, 39.102f, 18, 1, new int[]{-1, 0, 1}, 0.82f, ElementType.ALKALI_METAL),
    Ca(20, 4, 17, 1.95f, 1.74f, 2, 0, 2, 0, 0, 40.08f, 18, 2, new int[]{0, 1, 2}, 1.0f, ElementType.ALKALINE_EARTH_METAL),
    Sc(21, 4, 84, 1.32f, 1.44f, 3, 0, 12, 3, 0, 44.956f, 18, 3, new int[]{0, 1, 2, 3}, 1.36f, ElementType.TRANSITION_METAL),
    Ti(22, 4, 96, 1.95f, 1.36f, 4, 2, 4, 3, 4, 47.88f, 18, 4, new int[]{-1, 0, 1, 2, 3, 4}, 1.54f, ElementType.TRANSITION_METAL),
    V(23, 4, 100, 1.06f, 1.25f, 5, 0, 12, 3, 0, 50.04f, 18, 5, new int[]{-1, 0, 1, 2, 3, 4, 5}, 1.63f, ElementType.TRANSITION_METAL),
    Cr(24, 4, 24, 1.13f, 1.27f, 6, 0, 12, 2, 0, 51.996f, 18, 3, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6}, 1.66f, ElementType.TRANSITION_METAL),
    Mn(25, 4, 55, 1.19f, 1.39f, 7, 0, 12, 0, 0, 54.938f, 18, 2, new int[]{-3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7}, 1.55f, ElementType.TRANSITION_METAL),
    Fe(26, 4, 33, 1.95f, 1.25f, 3, 0, 8, 0, 0, 55.847f, 18, 3, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6}, 1.83f, ElementType.TRANSITION_METAL),
    Co(27, 4, 23, 1.13f, 1.26f, 3, 0, 12, 0, 0, 58.933f, 18, 2, new int[]{-1, 0, 1, 2, 3, 4, 5}, 1.88f, ElementType.TRANSITION_METAL),
    Ni(28, 4, 62, 1.24f, 1.21f, 3, 0, 12, 0, 0, 58.71f, 18, 2, new int[]{-1, 0, 1, 2, 3, 4}, 1.91f, ElementType.TRANSITION_METAL),
    Cu(29, 4, 26, 1.15f, 1.38f, 2, 0, 4, 0, 0, 63.546f, 18, 2, new int[]{0, 1, 2, 3, 4}, 1.9f, ElementType.TRANSITION_METAL),
    Zn(30, 4, 106, 1.15f, 1.31f, 2, 0, 2, 0, 0, 65.38f, 18, 2, new int[]{0, 1, 2}, 1.65f, ElementType.TRANSITION_METAL),
    Ga(31, 4, 36, 1.55f, 1.26f, 3, 1, 4, 2, 4, 69.72f, 28, 3, new int[]{0, 1, 2, 3}, 1.81f, ElementType.POST_TRANSITION_METAL),
    Ge(32, 4, 38, 2.72f, 1.22f, 4, 0, 12, 4, 4, 72.59f, 28, 4, new int[]{-4, -3, -2, -1, 0, 1, 2, 3, 4}, 2.01f, ElementType.METALLOID),
    As(33, 4, 7, 0.83f, 1.19f, 5, 0, 12, 3, 5, 74.922f, 28, -3, new int[]{-3, 0, 1, 2, 3, 5}, 2.18f, ElementType.METALLOID),
    Se(34, 4, 85, 0.9f, 1.16f, 6, 0, 12, 2, 6, 78.96f, 28, 4, new int[]{-2, 0, 1, 2, 4, 6}, 2.55f, ElementType.OTHER_NONMETAL),
    Br(35, 4, 15, 1.95f, 1.14f, 7, 0, 1, 1, 1, 79.904f, 28, -1, new int[]{-1, 0, 1, 2, 3, 4, 5, 7}, 2.96f, ElementType.HALOGEN),
    Kr(36, 4, 48, 1.9f, 1.6f, 8, 0, 12, 0, 0, 83.8f, 28, 0, new int[]{0, 2}, 3.0f, ElementType.NOBLE_GAS),
    Rb(37, 5, 77, 2.65f, 2.11f, 1, 0, 12, 0, 0, 85.467f, 36, 1, new int[]{-1, 0, 1}, 0.82f, ElementType.ALKALI_METAL),
    Sr(38, 5, 89, 2.02f, 1.92f, 2, 0, 12, 2, 0, 87.62f, 36, 2, new int[]{0, 1, 2}, 0.95f, ElementType.ALKALINE_EARTH_METAL),
    Y(39, 5, 103, 1.61f, 1.62f, 3, 0, 12, 3, 0, 88.806f, 36, 3, new int[]{0, 1, 2, 3}, 1.22f, ElementType.TRANSITION_METAL),
    Zr(40, 5, 105, 1.42f, 1.48f, 4, 0, 12, 4, 0, 91.22f, 36, 4, new int[]{0, 1, 2, 3, 4}, 1.33f, ElementType.TRANSITION_METAL),
    Nb(41, 5, 59, 1.33f, 1.37f, 5, 0, 12, 3, 0, 92.906f, 36, 5, new int[]{-1, 0, 1, 2, 3, 4, 5}, 1.6f, ElementType.TRANSITION_METAL),
    Mo(42, 5, 56, 1.75f, 1.45f, 6, 1, 6, 3, 0, 95.94f, 36, 6, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6}, 2.16f, ElementType.TRANSITION_METAL),
    Tc(43, 5, 93, 1.8f, 1.56f, 7, 0, 12, 6, 0, 98.91f, 36, 7, new int[]{-3, -1, 0, 1, 2, 3, 4, 5, 6, 7}, 1.9f, ElementType.TRANSITION_METAL),
    Ru(44, 5, 81, 1.2f, 1.26f, 8, 0, 12, 3, 0, 101.07f, 36, 4, new int[]{-2, 0, 1, 2, 3, 4, 5, 6, 7, 8}, 2.2f, ElementType.TRANSITION_METAL),
    Rh(45, 5, 79, 1.22f, 1.35f, 4, 0, 12, 3, 0, 102.906f, 36, 3, new int[]{-1, 0, 1, 2, 3, 4, 5, 6}, 2.28f, ElementType.TRANSITION_METAL),
    Pd(46, 5, 70, 1.44f, 1.31f, 4, 0, 12, 2, 0, 106.4f, 36, 2, new int[]{0, 1, 2, 4}, 2.2f, ElementType.TRANSITION_METAL),
    Ag(47, 5, 3, 1.55f, 1.53f, 1, 0, 6, 0, 0, 107.868f, 36, 1, new int[]{0, 1, 2, 3, 4}, 1.93f, ElementType.TRANSITION_METAL),
    Cd(48, 5, 18, 1.75f, 1.48f, 2, 0, 12, 0, 0, 112.4f, 36, 2, new int[]{0, 1, 2}, 1.69f, ElementType.TRANSITION_METAL),
    In(49, 5, 45, 1.46f, 1.44f, 3, 0, 12, 3, 0, 114.82f, 46, 3, new int[]{0, 1, 2, 3}, 1.78f, ElementType.POST_TRANSITION_METAL),
    Sn(50, 5, 88, 1.67f, 1.41f, 4, 0, 12, 2, 4, 118.69f, 46, 4, new int[]{-4, 0, 2, 4}, 1.96f, ElementType.POST_TRANSITION_METAL),
    Sb(51, 5, 83, 1.12f, 1.38f, 5, 0, 12, 4, 5, 121.75f, 46, -3, new int[]{-3, 0, 3, 5}, 2.05f, ElementType.METALLOID),
    Te(52, 5, 94, 1.26f, 1.35f, 6, 0, 12, 2, 6, 127.6f, 46, 4, new int[]{-2, 0, 2, 4, 5, 6}, 2.1f, ElementType.METALLOID),
    I(53, 5, 44, 2.15f, 1.33f, 7, 1, 1, 1, 1, 126.905f, 46, -1, new int[]{-1, 0, 1, 3, 4, 5, 7}, 2.66f, ElementType.HALOGEN),
    Xe(54, 5, 102, 2.1f, 1.7f, 8, 0, 12, 0, 0, 131.3f, 46, 0, new int[]{0, 1, 2, 4, 6, 8}, 2.6f, ElementType.NOBLE_GAS),
    Cs(55, 6, 25, 3.01f, 2.25f, 1, 0, 12, 0, 0, 132.905f, 54, 1, new int[]{-1, 0, 1}, 0.79f, ElementType.ALKALI_METAL),
    Ba(56, 6, 11, 2.41f, 1.98f, 2, 0, 12, 0, 0, 137.34f, 54, 2, new int[]{0, 2}, 0.89f, ElementType.ALKALINE_EARTH_METAL),
    La(57, 6, 49, 1.83f, 1.95f, 3, 0, 12, 3, 0, 138.905f, 54, 3, new int[]{0, 2, 3}, 1.1f, ElementType.LANTHANOID),
    Ce(58, 6, 19, 1.86f, 1.03f, 4, 0, 12, 3, 0, 140.12f, 54, 3, new int[]{0, 2, 3, 4}, 1.12f, ElementType.LANTHANOID),
    Pr(59, 6, 73, 1.62f, 0.9f, 4, 0, 12, 3, 0, 140.908f, 55, 3, new int[]{0, 2, 3, 4}, 1.13f, ElementType.LANTHANOID),
    Nd(60, 6, 60, 1.79f, 0.99f, 3, 0, 12, 3, 0, 144.24f, 56, 3, new int[]{0, 2, 3, 4}, 1.14f, ElementType.LANTHANOID),
    Pm(61, 6, 71, 1.76f, 0.98f, 3, 0, 12, 3, 0, 145.0f, 58, 3, new int[]{0, 2, 3}, 1.13f, ElementType.LANTHANOID),
    Sm(62, 6, 87, 1.74f, 0.96f, 3, 0, 12, 2, 0, 150.4f, 59, 3, new int[]{0, 2, 3}, 1.17f, ElementType.LANTHANOID),
    Eu(63, 6, 31, 1.96f, 1.09f, 3, 0, 12, 2, 0, 151.96f, 60, 3, new int[]{0, 2, 3}, 1.2f, ElementType.LANTHANOID),
    Gd(64, 6, 37, 1.69f, 0.94f, 3, 0, 12, 3, 0, 157.25f, 61, 3, new int[]{0, 1, 2, 3}, 1.2f, ElementType.LANTHANOID),
    Tb(65, 6, 92, 1.66f, 0.92f, 4, 0, 12, 3, 0, 158.925f, 61, 3, new int[]{0, 1, 2, 3, 4}, 1.1f, ElementType.LANTHANOID),
    Dy(66, 6, 28, 1.63f, 0.91f, 3, 0, 12, 3, 0, 162.5f, 62, 3, new int[]{0, 2, 3, 4}, 1.22f, ElementType.LANTHANOID),
    Ho(67, 6, 43, 1.61f, 0.89f, 3, 0, 12, 3, 0, 164.93f, 64, 3, new int[]{0, 2, 3}, 1.23f, ElementType.LANTHANOID),
    Er(68, 6, 29, 1.59f, 0.88f, 3, 0, 12, 3, 0, 167.26f, 65, 3, new int[]{0, 2, 3}, 1.24f, ElementType.LANTHANOID),
    Tm(69, 6, 98, 1.57f, 0.87f, 3, 0, 12, 3, 0, 168.934f, 66, 3, new int[]{0, 2, 3, 4}, 1.25f, ElementType.LANTHANOID),
    Yb(70, 6, 104, 1.54f, 0.86f, 3, 0, 12, 2, 0, 173.04f, 67, 3, new int[]{0, 2, 3}, 1.1f, ElementType.LANTHANOID),
    Lu(71, 6, 52, 1.53f, 0.85f, 3, 0, 12, 3, 0, 174.97f, 68, 3, new int[]{0, 3}, 1.27f, ElementType.LANTHANOID),
    Hf(72, 6, 41, 1.4f, 1.58f, 4, 0, 12, 4, 0, 178.49f, 68, 4, new int[]{0, 2, 3, 4}, 1.3f, ElementType.TRANSITION_METAL),
    Ta(73, 6, 91, 1.22f, 1.38f, 5, 0, 12, 5, 0, 180.85f, 68, 5, new int[]{-1, 0, 2, 3, 4, 5}, 1.5f, ElementType.TRANSITION_METAL),
    W(74, 6, 101, 1.26f, 1.46f, 6, 0, 12, 6, 0, 183.85f, 68, 6, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6}, 2.36f, ElementType.TRANSITION_METAL),
    Re(75, 6, 78, 1.3f, 1.59f, 7, 0, 12, 4, 0, 186.2f, 68, 7, new int[]{-3, -1, 0, 1, 2, 3, 4, 5, 6, 7}, 1.9f, ElementType.TRANSITION_METAL),
    Os(76, 6, 66, 1.58f, 1.28f, 8, 0, 12, 2, 0, 190.2f, 68, 4, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8}, 2.2f, ElementType.TRANSITION_METAL),
    Ir(77, 6, 46, 1.22f, 1.37f, 6, 0, 12, 3, 0, 192.22f, 68, 4, new int[]{-3, -1, 0, 1, 2, 3, 4, 5, 6, 8}, 2.2f, ElementType.TRANSITION_METAL),
    Pt(78, 6, 74, 1.55f, 1.28f, 4, 0, 6, 0, 0, 195.09f, 68, 4, new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6}, 2.28f, ElementType.TRANSITION_METAL),
    Au(79, 6, 9, 1.45f, 1.44f, 3, 0, 6, 0, 0, 196.967f, 68, 3, new int[]{-1, 0, 1, 2, 3, 5}, 2.54f, ElementType.TRANSITION_METAL),
    Hg(80, 6, 42, 1.55f, 1.32f, 2, 0, 12, 1, 2, 200.59f, 78, 1, new int[]{0, 1, 2, 4}, 2.0f, ElementType.TRANSITION_METAL),
    Tl(81, 6, 97, 1.96f, 1.45f, 3, 0, 12, 1, 3, 204.3833f, 78, 1, new int[]{-1, 0, 1, 3}, 1.62f, ElementType.POST_TRANSITION_METAL),
    Pb(82, 6, 69, 2.16f, 1.47f, 4, 0, 12, 2, 4, 207.2f, 78, 2, new int[]{-4, 0, 2, 4}, 2.33f, ElementType.POST_TRANSITION_METAL),
    Bi(83, 6, 13, 1.73f, 1.46f, 5, 0, 12, 3, 3, 208.981f, 78, 3, new int[]{-3, 0, 1, 3, 5}, 2.2f, ElementType.POST_TRANSITION_METAL),
    Po(84, 6, 72, 1.21f, 0.67f, 6, 0, 12, 4, 2, 209.0f, 78, 4, new int[]{-2, 0, 2, 4, 5, 6}, 2.0f, ElementType.METALLOID),
    At(85, 6, 8, 1.12f, 0.62f, 7, 0, 12, 1, 1, 210.0f, 78, -1, new int[]{-1, 0, 1, 3, 5, 7}, 2.2f, ElementType.HALOGEN),
    Rn(86, 6, 80, 2.3f, 1.9f, 8, 0, 12, 0, 0, 222.0f, 78, 0, new int[]{0, 2, 6}, 0.0f, ElementType.NOBLE_GAS),
    Fr(87, 7, 35, 3.24f, 1.8f, 1, 0, 12, 0, 0, 223.0f, -1, 1, new int[]{0, 1}, 0.7f, ElementType.ALKALI_METAL),
    Ra(88, 7, 76, 2.57f, 1.43f, 2, 0, 12, 2, 0, 226.0f, -1, 2, new int[]{0, 2}, 0.9f, ElementType.ALKALINE_EARTH_METAL),
    Ac(89, 7, 2, 2.12f, 1.18f, 3, 0, 12, 4, 0, 227.0f, -1, 3, new int[]{0, 2, 3}, 1.1f, ElementType.ACTINOID),
    Th(90, 7, 95, 1.84f, 1.02f, 4, 0, 12, 1, 0, 232.038f, -1, 4, new int[]{0, 2, 3, 4}, 1.3f, ElementType.ACTINOID),
    Pa(91, 7, 68, 1.6f, 0.89f, 5, 0, 12, 4, 0, 231.036f, -1, 5, new int[]{0, 2, 3, 4, 5}, 1.5f, ElementType.ACTINOID),
    U(92, 7, 99, 1.75f, 0.97f, 6, 0, 12, 4, 0, 238.029f, -1, 6, new int[]{0, 2, 3, 4, 5, 6}, 1.38f, ElementType.ACTINOID),
    Np(93, 7, 64, 1.71f, 0.95f, 6, 0, 12, 4, 0, 237.048f, -1, 5, new int[]{0, 3, 4, 5, 6, 7}, 1.36f, ElementType.ACTINOID),
    Pu(94, 7, 75, 1.67f, 0.93f, 6, 0, 12, 3, 0, 244.0f, -1, 4, new int[]{0, 3, 4, 5, 6, 7, 8}, 1.28f, ElementType.ACTINOID),
    Am(95, 7, 5, 1.66f, 0.92f, 6, 0, 12, 3, 0, 243.0f, -1, 3, new int[]{0, 2, 3, 4, 5, 6, 7}, 1.13f, ElementType.ACTINOID),
    Cm(96, 7, 22, 1.65f, 0.91f, 3, 0, 12, 3, 0, 248.0f, -1, 3, new int[]{0, 3, 4}, 1.28f, ElementType.ACTINOID),
    Bk(97, 7, 14, 1.64f, 0.9f, 4, 0, 12, 3, 0, 247.0f, -1, 3, new int[]{0, 2, 3, 4}, 1.3f, ElementType.ACTINOID),
    Cf(98, 7, 20, 1.63f, 0.89f, 3, 0, 12, 4, 0, 251.0f, -1, 3, new int[]{0, 2, 3, 4}, 1.3f, ElementType.ACTINOID),
    Es(99, 7, 30, 1.62f, 0.88f, -1, 0, 12, 4, 0, 254.0f, -1, 3, new int[]{0, 2, 3}, 1.3f, ElementType.ACTINOID),
    Fm(100, 7, 34, 1.61f, 0.87f, -1, 0, 12, 4, 0, 257.0f, -1, 3, new int[]{0, 2, 3}, 1.3f, ElementType.ACTINOID),
    Md(101, 7, 53, 1.6f, 0.86f, -1, 0, 12, 4, 0, 256.0f, -1, 3, new int[]{0, 2, 3}, 1.3f, ElementType.ACTINOID),
    No(102, 7, 63, 1.59f, 0.85f, -1, 0, 12, 4, 0, 254.0f, -1, 3, new int[]{0, 2, 3}, 1.3f, ElementType.ACTINOID),
    Lr(103, 7, 51, 1.58f, 0.84f, -1, 0, 12, 4, 0, 257.0f, -1, 3, new int[]{0, 3}, 0.0f, ElementType.ACTINOID),
    R(104, 0, 105, 0.0f, 0.0f, 0, 0, 4, 1, 0, 0.0f, -1, 3, null, 0.0f, ElementType.UNKNOWN);

    private int atomicNumber;
    private int period;
    private float VDWRadius;
    private float covalentRadius;
    private int valenceElectronCount;
    private int minimumValence;
    private int maximumValence;
    private int commonValence;
    private int maximumCovalentValence;
    private float atomicMass;
    private int coreElectronCount;
    private int oxidationState;
    private int[] allOxidationStates;
    private float paulingElectronegativity;
    private ElementType elementType;
    private static final Map<String, Element> allElements;

    private Element(int atomicNumber, int period, int hillOrder, float VDWRadius, float covalentRadius, int valenceElectronCount, int minimumValence, int maximumValence, int commonValence, int maximumCovalentValence, float atomicMass, int coreElectronCount, int oxidationState, int[] allOxidationStates, float paulingElectronegativity, ElementType elementType) {
        this.atomicNumber = atomicNumber;
        this.period = period;
        this.VDWRadius = VDWRadius;
        this.covalentRadius = covalentRadius;
        this.valenceElectronCount = valenceElectronCount;
        this.minimumValence = minimumValence;
        this.maximumValence = maximumValence;
        this.commonValence = commonValence;
        this.maximumCovalentValence = maximumCovalentValence;
        this.atomicMass = atomicMass;
        this.coreElectronCount = coreElectronCount;
        this.oxidationState = oxidationState;
        this.allOxidationStates = allOxidationStates;
        this.paulingElectronegativity = paulingElectronegativity;
        this.elementType = elementType;
    }

    public int[] getAllOxidationStates() {
        return this.allOxidationStates;
    }

    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getHillOrder() {
        throw new RuntimeException("Not implemented, yet!");
    }

    public float getVDWRadius() {
        return this.VDWRadius;
    }

    public float getCovalentRadius() {
        return this.covalentRadius;
    }

    public int getValenceElectronCount() {
        return this.valenceElectronCount;
    }

    public int getMinimumValence() {
        return this.minimumValence;
    }

    public int getMaximumValence() {
        return this.maximumValence;
    }

    public int getCommonValence() {
        return this.commonValence;
    }

    public int getMaximumCovalentValence() {
        return this.maximumCovalentValence;
    }

    public float getAtomicMass() {
        return this.atomicMass;
    }

    public int getCoreElectronCount() {
        return this.coreElectronCount;
    }

    public int getOxidationState() {
        return this.oxidationState;
    }

    public float getPaulingElectronegativity() {
        return this.paulingElectronegativity;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public static Element valueOfIgnoreCase(String elementSymbol) {
        Element e = allElements.get(elementSymbol.toLowerCase());
        if (e != null) {
            return e;
        }
        throw new IllegalArgumentException("Invalid element symbol: " + elementSymbol);
    }

    public boolean isHydrogen() {
        return this == H || this == D || this == T;
    }

    public boolean isHeavyAtom() {
        return !this.isHydrogen();
    }

    public boolean isHeteroAtom() {
        return this != C && this != H;
    }

    public boolean isMetal() {
        return this.elementType.isMetal();
    }

    public boolean isMetalloid() {
        return this.elementType.isMetalloid();
    }

    public boolean isNonMetal() {
        return this.elementType.isNonMetal();
    }

    public boolean isHalogen() {
        return this.elementType.equals((Object)ElementType.HALOGEN);
    }

    public boolean isChalcogen() {
        return this == O || this == S || this == Se || this == Te || this == Po;
    }

    public static Element getElementFromHillIndex(int index) {
        throw new UnsupportedOperationException("Not implemented, yet!");
    }

    static {
        allElements = new HashMap<String, Element>();
        for (Element e : Element.values()) {
            allElements.put(e.toString().toLowerCase(), e);
        }
    }
}

