/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.basepairs;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.basepairs.BasePairParameters;
import org.biojava.nbio.structure.contact.Pair;

public class TertiaryBasePairParameters
extends BasePairParameters {
    private static final long serialVersionUID = 2556427111533466577L;
    public static final double DEFAULT_MAX_STAGGER = 2.0;
    public static final double DEFAULT_MAX_PROPELLER = 60.0;
    private double maxStagger = 2.0;
    private double maxPropeller = 60.0;

    public TertiaryBasePairParameters(Structure structure, boolean RNA, boolean removeDups) {
        super(structure, RNA, removeDups);
    }

    @Override
    public List<Pair<Group>> findPairs(List<Chain> chains) {
        ArrayList<Pair<Group>> result = new ArrayList<Pair<Group>>();
        boolean lastFoundPair = false;
        for (int i = 0; i < chains.size(); ++i) {
            Chain c = chains.get(i);
            String sequence = c.getAtomSequence();
            for (int j = 0; j < sequence.length(); ++j) {
                boolean foundPair = false;
                for (int k = sequence.length() - 1; k >= j + 3 && !foundPair; --k) {
                    Group g1 = c.getAtomGroup(j);
                    Group g2 = c.getAtomGroup(k);
                    Integer type1 = (Integer)BASE_MAP.get(g1.getPDBName());
                    Integer type2 = (Integer)BASE_MAP.get(g2.getPDBName());
                    if (type1 == null || type2 == null) continue;
                    Atom a1 = g1.getAtom("C1'");
                    Atom a2 = g2.getAtom("C1'");
                    if (a1 == null || a2 == null || Math.abs(a1.getCoordsAsPoint3d().distance(a2.getCoordsAsPoint3d()) - 10.0) > 4.0) continue;
                    Pair<Group> ga = new Pair<Group>(g1, g2);
                    Matrix4d data = this.basePairReferenceFrame(ga);
                    if (Math.abs(this.pairParameters[5]) > this.maxStagger || Math.abs(this.pairParameters[1]) > this.maxPropeller) continue;
                    result.add(ga);
                    this.pairingNames.add(this.useRNA ? BASE_LIST_RNA[type1] + BASE_LIST_RNA[type2] : BASE_LIST_DNA[type1] + BASE_LIST_DNA[type2]);
                    foundPair = true;
                }
                if (!foundPair && lastFoundPair && this.pairSequence.length() > 0 && this.pairSequence.charAt(this.pairSequence.length() - 1) != ' ') {
                    this.pairSequence = this.pairSequence + " ";
                }
                if (foundPair) {
                    this.pairSequence = this.pairSequence + c.getAtomSequence().charAt(j);
                }
                lastFoundPair = foundPair;
            }
        }
        result.addAll(super.findPairs(chains));
        return result;
    }

    public double getMaxStagger() {
        return this.maxStagger;
    }

    public void setMaxStagger(double maxStagger) {
        this.maxStagger = maxStagger;
    }

    public double getMaxPropeller() {
        return this.maxPropeller;
    }

    public void setMaxPropeller(double maxPropeller) {
        this.maxPropeller = maxPropeller;
    }
}

