/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cath;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.cath.CathCategory;
import org.biojava.nbio.structure.cath.CathSegment;

public class CathDomain
implements Serializable,
StructureIdentifier {
    public static final long serialVersionUID = 1L;
    String domainName;
    Integer classId;
    Integer architectureId;
    Integer topologyId;
    Integer homologyId;
    Integer sequenceFamilyId;
    Integer orthologousSequenceFamilyId;
    Integer likeSequenceFamilyId;
    Integer identicalSequenceFamilyId;
    Integer domainCounter;
    Integer length;
    Double resolution;
    String format;
    String version;
    Date date;
    String name;
    String source;
    String sequenceHeader;
    String sequence;
    List<CathSegment> segments;
    String comment;

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getThePdbId() {
        return this.domainName.substring(0, 4);
    }

    public String getPdbIdAndChain() {
        return this.domainName.substring(0, 4) + (String)(!"0".equals(this.domainName.substring(4, 5)) ? "." + this.domainName.substring(4, 5) : "");
    }

    public Integer getDomainId() {
        return Integer.parseInt(this.domainName.substring(5));
    }

    public Integer getClassId() {
        return this.classId;
    }

    public void setClassId(Integer classId) {
        this.classId = classId;
    }

    public Integer getArchitectureId() {
        return this.architectureId;
    }

    public void setArchitectureId(Integer architectureId) {
        this.architectureId = architectureId;
    }

    public Integer getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(Integer topologyId) {
        this.topologyId = topologyId;
    }

    public Integer getHomologyId() {
        return this.homologyId;
    }

    public void setHomologyId(Integer homologyId) {
        this.homologyId = homologyId;
    }

    public Integer getSequenceFamilyId() {
        return this.sequenceFamilyId;
    }

    public void setSequenceFamilyId(Integer sequenceFamilyId) {
        this.sequenceFamilyId = sequenceFamilyId;
    }

    public Integer getOrthologousSequenceFamilyId() {
        return this.orthologousSequenceFamilyId;
    }

    public void setOrthologousSequenceFamilyId(Integer orthologousSequenceFamilyId) {
        this.orthologousSequenceFamilyId = orthologousSequenceFamilyId;
    }

    public Integer getLikeSequenceFamilyId() {
        return this.likeSequenceFamilyId;
    }

    public void setLikeSequenceFamilyId(Integer likeSequenceFamilyId) {
        this.likeSequenceFamilyId = likeSequenceFamilyId;
    }

    public Integer getIdenticalSequenceFamilyId() {
        return this.identicalSequenceFamilyId;
    }

    public void setIdenticalSequenceFamilyId(Integer identicalSequenceFamilyId) {
        this.identicalSequenceFamilyId = identicalSequenceFamilyId;
    }

    public Integer getDomainCounter() {
        return this.domainCounter;
    }

    public void setDomainCounter(Integer domainCounter) {
        this.domainCounter = domainCounter;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Double getResolution() {
        return this.resolution;
    }

    public void setResolution(Double resolution) {
        this.resolution = resolution;
    }

    public void setCATH(String cathCode) {
        String[] token = cathCode.split("[.]");
        this.setClassId(Integer.parseInt(token[0]));
        this.setArchitectureId(Integer.parseInt(token[1]));
        this.setTopologyId(Integer.parseInt(token[2]));
        this.setHomologyId(Integer.parseInt(token[3]));
    }

    public String getCATH() {
        return Integer.toString(this.getClassId()) + "." + Integer.toString(this.getArchitectureId()) + "." + Integer.toString(this.getTopologyId()) + "." + Integer.toString(this.getHomologyId());
    }

    public void setSOLID(String cathCode) {
        String[] token = cathCode.split("[.]");
        this.setSequenceFamilyId(Integer.parseInt(token[0]));
        this.setOrthologousSequenceFamilyId(Integer.parseInt(token[1]));
        this.setLikeSequenceFamilyId(Integer.parseInt(token[2]));
        this.setIdenticalSequenceFamilyId(Integer.parseInt(token[3]));
        this.setDomainCounter(Integer.parseInt(token[4]));
    }

    public String getSOILD() {
        return Integer.toString(this.getSequenceFamilyId()) + "." + Integer.toString(this.getOrthologousSequenceFamilyId()) + "." + Integer.toString(this.getLikeSequenceFamilyId()) + "." + Integer.toString(this.getIdenticalSequenceFamilyId()) + "." + Integer.toString(this.getDomainCounter());
    }

    public Integer getClassificationId(CathCategory cathCategory) {
        switch (cathCategory) {
            case Class: {
                return this.getClassId();
            }
            case Architecture: {
                return this.getArchitectureId();
            }
            case Topolgy: {
                return this.getTopologyId();
            }
            case Homology: {
                return this.getHomologyId();
            }
            case SequenceFamily: {
                return this.getSequenceFamilyId();
            }
            case OrthologousSequenceFamily: {
                return this.getOrthologousSequenceFamilyId();
            }
            case LikeSequenceFamily: {
                return this.getLikeSequenceFamilyId();
            }
            case IdenticalSequenceFamily: {
                return this.getIdenticalSequenceFamilyId();
            }
            case DomainCounter: {
                return this.getDomainCounter();
            }
        }
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSequenceHeader() {
        return this.sequenceHeader;
    }

    public void setSequenceHeader(String sequenceHeader) {
        this.sequenceHeader = sequenceHeader;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public List<CathSegment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<CathSegment> segments) {
        this.segments = segments;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return "CathDomain [domainName=" + this.domainName + ", classId=" + this.classId + ", architectureId=" + this.architectureId + ", topologyId=" + this.topologyId + ", homologyId=" + this.homologyId + ", sequenceFamilyId=" + this.sequenceFamilyId + ", orthologousSequenceFamilyId=" + this.orthologousSequenceFamilyId + ", likeSequenceFamilyId=" + this.likeSequenceFamilyId + ", identicalSequenceFamilyId=" + this.identicalSequenceFamilyId + ", domainCounter=" + this.domainCounter + ", length=" + this.length + ", resolution=" + this.resolution + ", format=" + this.format + ", version=" + this.version + ", date=" + String.valueOf(this.date) + ", name=" + this.name + ", source=" + this.source + ", sequenceHeader=" + this.sequenceHeader + ", sequence=" + this.sequence + ", segments=" + String.valueOf(this.segments) + ", comment=" + this.comment + "]";
    }

    public Set<String> getChains() throws StructureException {
        HashSet<String> chains = new HashSet<String>();
        List<ResidueRange> rrs = this.toCanonical().getResidueRanges();
        for (ResidueRange rr : rrs) {
            chains.add(rr.getChainName());
        }
        return chains;
    }

    @Override
    public String getIdentifier() {
        return this.getCATH();
    }

    @Override
    public SubstructureIdentifier toCanonical() throws StructureException {
        ArrayList<ResidueRange> ranges = new ArrayList<ResidueRange>();
        String chain = String.valueOf(this.getDomainName().charAt(this.getDomainName().length() - 3));
        for (CathSegment segment : this.getSegments()) {
            ranges.add(new ResidueRange(chain, segment.getStart(), segment.getStop()));
        }
        return new SubstructureIdentifier(this.getThePdbId(), ranges);
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return this.toCanonical().reduce(input);
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        return cache.getStructure(this.getThePdbId());
    }
}

