/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.asa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;

public class GroupAsa
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashMap<Character, Double> tripeptAsa = GroupAsa.initTriPeptAsas();
    private Group g;
    private double asaU;
    private double asaC;
    private List<Double> atomAsaUs;
    private List<Double> atomAsaCs;

    private static HashMap<Character, Double> initTriPeptAsas() {
        HashMap<Character, Double> map = new HashMap<Character, Double>();
        map.put(Character.valueOf('A'), 113.0);
        map.put(Character.valueOf('R'), 241.0);
        map.put(Character.valueOf('N'), 158.0);
        map.put(Character.valueOf('D'), 151.0);
        map.put(Character.valueOf('C'), 140.0);
        map.put(Character.valueOf('Q'), 189.0);
        map.put(Character.valueOf('E'), 183.0);
        map.put(Character.valueOf('G'), 85.0);
        map.put(Character.valueOf('H'), 194.0);
        map.put(Character.valueOf('I'), 182.0);
        map.put(Character.valueOf('L'), 180.0);
        map.put(Character.valueOf('K'), 211.0);
        map.put(Character.valueOf('M'), 204.0);
        map.put(Character.valueOf('F'), 218.0);
        map.put(Character.valueOf('P'), 143.0);
        map.put(Character.valueOf('S'), 122.0);
        map.put(Character.valueOf('T'), 146.0);
        map.put(Character.valueOf('W'), 259.0);
        map.put(Character.valueOf('Y'), 229.0);
        map.put(Character.valueOf('V'), 160.0);
        return map;
    }

    public GroupAsa(Group g) {
        this.g = g;
        int groupNoHSize = this.getGroupNoHSize();
        this.atomAsaUs = new ArrayList<Double>(groupNoHSize);
        this.atomAsaCs = new ArrayList<Double>(groupNoHSize);
    }

    private int getGroupNoHSize() {
        int count = 0;
        for (Atom atom : this.g.getAtoms()) {
            if (atom.getElement() == Element.H) continue;
            ++count;
        }
        return count;
    }

    public Group getGroup() {
        return this.g;
    }

    public double getAsaU() {
        return this.asaU;
    }

    public void setAsaU(double asaU) {
        this.asaU = asaU;
    }

    public double getAsaC() {
        return this.asaC;
    }

    public void setAsaC(double asaC) {
        this.asaC = asaC;
    }

    public void addAtomAsaU(double asa) {
        this.asaU += asa;
        this.atomAsaUs.add(asa);
    }

    public void addAtomAsaC(double asa) {
        this.asaC += asa;
        this.atomAsaCs.add(asa);
    }

    public List<Double> getAtomAsaUs() {
        return this.atomAsaUs;
    }

    public void setAtomAsaUs(List<Double> atomAsaUs) {
        this.atomAsaUs = atomAsaUs;
        this.asaU = 0.0;
        for (Double atomAsaU : atomAsaUs) {
            this.asaU += atomAsaU.doubleValue();
        }
    }

    public List<Double> getAtomAsaCs() {
        return this.atomAsaCs;
    }

    public void setAtomAsaCs(List<Double> atomAsaCs) {
        this.atomAsaCs = atomAsaCs;
        this.asaC = 0.0;
        for (Double atomAsaC : atomAsaCs) {
            this.asaC += atomAsaC.doubleValue();
        }
    }

    public double getBsa() {
        return this.asaU - this.asaC;
    }

    public double getBsaToAsaRatio() {
        return this.getBsa() / this.asaU;
    }

    public double getRelativeAsaU() {
        if (!this.g.getType().equals((Object)GroupType.AMINOACID)) {
            throw new IllegalArgumentException("Can not calculate relative ASA for non amino-acid");
        }
        char aa = ((AminoAcid)this.g).getAminoType().charValue();
        return this.asaU / tripeptAsa.get(Character.valueOf(aa));
    }

    public double getRelativeAsaC() {
        if (!this.g.getType().equals((Object)GroupType.AMINOACID)) {
            throw new IllegalArgumentException("Can not calculate relative ASA for non amino-acid");
        }
        char aa = ((AminoAcid)this.g).getAminoType().charValue();
        return this.asaC / tripeptAsa.get(Character.valueOf(aa));
    }

    public Object clone() {
        int i;
        GroupAsa n = new GroupAsa(this.g);
        n.setAsaC(this.getAsaC());
        n.setAsaU(this.getAsaU());
        n.atomAsaUs = new ArrayList<Double>(this.atomAsaUs.size());
        n.atomAsaCs = new ArrayList<Double>(this.atomAsaCs.size());
        for (i = 0; i < this.atomAsaUs.size(); ++i) {
            n.atomAsaUs.add(this.atomAsaUs.get(i));
        }
        for (i = 0; i < this.atomAsaCs.size(); ++i) {
            n.atomAsaCs.add(this.atomAsaCs.get(i));
        }
        return n;
    }
}

