/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;

public class HelicalRepeatUnit {
    private QuatSymmetrySubunits subunits = null;
    private List<Point3d> repeatUnitCenters = new ArrayList<Point3d>();
    private List<Point3d[]> repeatUnits = new ArrayList<Point3d[]>();
    private List<List<Integer>> repeatUnitIndices = new ArrayList<List<Integer>>();
    private Map<Integer[], Integer> interactingNeighbors = Collections.emptyMap();

    public HelicalRepeatUnit(QuatSymmetrySubunits subunits) {
        this.subunits = subunits;
    }

    public List<Point3d> getRepeatUnitCenters() {
        if (this.repeatUnitCenters.isEmpty()) {
            this.run();
        }
        return this.repeatUnitCenters;
    }

    public List<Point3d[]> getRepeatUnits() {
        if (this.repeatUnits.isEmpty()) {
            this.run();
        }
        return this.repeatUnits;
    }

    public List<List<Integer>> getRepeatUnitIndices() {
        return this.repeatUnitIndices;
    }

    public Map<Integer[], Integer> getInteractingRepeatUnits() {
        if (this.interactingNeighbors.isEmpty()) {
            this.run();
        }
        return this.interactingNeighbors;
    }

    private void run() {
        this.repeatUnitCenters = this.calcRepeatUnitCenters();
        if (this.repeatUnitCenters.isEmpty()) {
            return;
        }
        this.repeatUnits = this.calcRepeatUnits();
        this.interactingNeighbors = this.findInteractingNeigbors();
    }

    private List<Point3d> calcRepeatUnitCenters() {
        ArrayList<Integer> models = new ArrayList<Integer>(this.subunits.getSubunitCount());
        for (int s = 0; s < this.subunits.getSubunitCount(); ++s) {
            models.add(0);
        }
        HashSet<Integer> uniqueModels = new HashSet<Integer>(Arrays.asList(1));
        int modelCount = uniqueModels.size();
        List<Integer> folds = this.subunits.getFolds();
        int maxFold = folds.get(folds.size() - 1);
        ArrayList<Point3d> repeatCenters = new ArrayList<Point3d>();
        List<Point3d> centers = this.subunits.getCenters();
        if (maxFold % modelCount == 0 && modelCount > 1 && this.subunits.getSubunitCount() > 3) {
            for (int i = 0; i < modelCount; ++i) {
                ArrayList<Integer> subunitIndices = new ArrayList<Integer>();
                Point3d p = new Point3d();
                int count = 0;
                for (int j = 0; j < models.size(); ++j) {
                    if ((Integer)models.get(j) != i) continue;
                    p.add((Tuple3d)centers.get(j));
                    subunitIndices.add(j);
                    ++count;
                }
                p.scale(1.0 / (double)count);
                repeatCenters.add(p);
                this.repeatUnitIndices.add(subunitIndices);
            }
        } else {
            List<Integer> sequenceClusterIds = this.subunits.getClusterIds();
            for (int i = 0; i < this.subunits.getSubunitCount(); ++i) {
                ArrayList<Integer> subunitIndices = new ArrayList<Integer>(1);
                if (sequenceClusterIds.get(i) != 0) continue;
                repeatCenters.add(new Point3d(centers.get(i)));
                subunitIndices.add(i);
                this.repeatUnitIndices.add(subunitIndices);
            }
        }
        if (repeatCenters.size() < 3) {
            repeatCenters.clear();
        }
        return repeatCenters;
    }

    private List<Point3d[]> calcRepeatUnits() {
        ArrayList<Integer> models = new ArrayList<Integer>(this.subunits.getSubunitCount());
        for (int s = 0; s < this.subunits.getSubunitCount(); ++s) {
            models.add(0);
        }
        HashSet<Integer> uniqueModels = new HashSet<Integer>(Arrays.asList(1));
        int modelCount = uniqueModels.size();
        List<Integer> folds = this.subunits.getFolds();
        int maxFold = folds.get(folds.size() - 1);
        ArrayList<Point3d[]> repeatTraces = new ArrayList<Point3d[]>();
        List<Point3d[]> traces = this.subunits.getTraces();
        if (maxFold % modelCount == 0 && modelCount > 1 && this.subunits.getSubunitCount() > 3) {
            for (int i = 0; i < modelCount; ++i) {
                ArrayList<Point3d> coords = new ArrayList<Point3d>();
                for (int j = 0; j < models.size(); ++j) {
                    if ((Integer)models.get(j) != i) continue;
                    coords.addAll(Arrays.asList(traces.get(j)));
                }
                Point3d[] x = new Point3d[coords.size()];
                coords.toArray(x);
                repeatTraces.add(CalcPoint.clonePoint3dArray(x));
            }
        } else {
            List<Integer> sequenceClusterIds = this.subunits.getClusterIds();
            for (int i = 0; i < this.subunits.getSubunitCount(); ++i) {
                if (sequenceClusterIds.get(i) != 0) continue;
                Point3d[] x = this.subunits.getTraces().get(i);
                repeatTraces.add(CalcPoint.clonePoint3dArray(x));
            }
        }
        return repeatTraces;
    }

    private Map<Integer[], Integer> findInteractingNeigbors() {
        HashMap<Integer[], Integer> contactMap = new HashMap<Integer[], Integer>();
        Map<Integer, List<Integer[]>> distanceMap = this.findClosestPairs(8);
        for (List<Integer[]> pairs : distanceMap.values()) {
            for (Integer[] pair : pairs) {
                Integer contacts = HelicalRepeatUnit.calcContactNumber(this.repeatUnits.get(pair[0]), this.repeatUnits.get(pair[1]));
                if (contacts <= 0) continue;
                contactMap.put(pair, contacts);
            }
        }
        return contactMap;
    }

    private Map<Integer, List<Integer[]>> findClosestPairs(int maxNeighbors) {
        TreeMap<Integer, List<Integer[]>> reducedMap = new TreeMap<Integer, List<Integer[]>>();
        TreeMap distanceMap = new TreeMap();
        int nCenters = this.repeatUnitCenters.size();
        for (int i = 0; i < nCenters - 1; ++i) {
            for (int j = i + 1; j < nCenters; ++j) {
                float dist = (float)this.repeatUnitCenters.get(i).distance(this.repeatUnitCenters.get(j));
                int intDist = Math.round(dist *= 100.0f);
                ArrayList<Integer[]> pairs = (ArrayList<Integer[]>)distanceMap.get(intDist);
                if (pairs == null) {
                    pairs = new ArrayList<Integer[]>();
                }
                Integer[] pair = new Integer[]{i, j};
                pairs.add(pair);
                distanceMap.put(intDist, pairs);
            }
        }
        int count = 0;
        for (Map.Entry entry : distanceMap.entrySet()) {
            if (reducedMap.containsKey(entry.getKey())) continue;
            reducedMap.put((Integer)entry.getKey(), (List)entry.getValue());
            if (++count != maxNeighbors) continue;
            break;
        }
        distanceMap.clear();
        return reducedMap;
    }

    private static int calcContactNumber(Point3d[] a, Point3d[] b) {
        int contacts = 0;
        for (Point3d pa : a) {
            for (Point3d pb : b) {
                if (!(pa.distance(pb) < 10.0)) continue;
                ++contacts;
            }
        }
        return contacts;
    }
}

