/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.lang.reflect.Constructor;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.IntrospectedCodeClass;

class IntrospectedCodeConstructor
implements CodeMethod {
    private final Constructor _constructor;

    public IntrospectedCodeConstructor(Constructor m) {
        this._constructor = m;
    }

    @Override
    public String getName() {
        return "<init>";
    }

    @Override
    public String getFullName() {
        return this._constructor.getDeclaringClass().getName() + "." + this.getName();
    }

    @Override
    public CodeClass getContainingClass() {
        return IntrospectedCodeClass.forClass(this._constructor.getDeclaringClass());
    }

    @Override
    public String getDescriptor() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < this.numParameters(); ++i) {
            CodeClass cc = this.getParameterType(i);
            sb.append(cc.getDescriptor());
        }
        sb.append(')');
        sb.append(this.getReturnType().getDescriptor());
        return sb.toString();
    }

    @Override
    public int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public CodeClass getReturnType() {
        return CodeUtils.TYPE_VOID;
    }

    @Override
    public int numParameters() {
        return this._constructor.getParameterTypes().length;
    }

    @Override
    public CodeClass getParameterType(int pos) {
        return IntrospectedCodeClass.forClass(this._constructor.getParameterTypes()[pos]);
    }
}

