/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.lang.reflect.Method;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.IntrospectedCodeClass;

class IntrospectedCodeMethod
implements CodeMethod {
    private final Method _method;

    public IntrospectedCodeMethod(Method m) {
        this._method = m;
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public String getFullName() {
        return this._method.getDeclaringClass().getName() + "." + this.getName();
    }

    @Override
    public CodeClass getContainingClass() {
        return IntrospectedCodeClass.forClass(this._method.getDeclaringClass());
    }

    @Override
    public String getDescriptor() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < this.numParameters(); ++i) {
            CodeClass cc = this.getParameterType(i);
            sb.append(cc.getDescriptor());
        }
        sb.append(')');
        sb.append(this.getReturnType().getDescriptor());
        return sb.toString();
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public CodeClass getReturnType() {
        return IntrospectedCodeClass.forClass(this._method.getReturnType());
    }

    @Override
    public int numParameters() {
        return this._method.getParameterTypes().length;
    }

    @Override
    public CodeClass getParameterType(int pos) {
        return IntrospectedCodeClass.forClass(this._method.getParameterTypes()[pos]);
    }

    public String toString() {
        return super.toString() + " " + this.getDescriptor();
    }
}

