/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.utils.bytecode.BranchFixup;
import org.biojava.utils.bytecode.ChildContext;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.OutstandingReference;
import org.biojava.utils.bytecode.ParametricType;
import org.biojava.utils.bytecode.ParentContext;
import org.biojava.utils.bytecode.SimpleReference;

class MethodRootContext
implements CodeContext,
ParentContext {
    private final CodeClass codeClass;
    private final CodeMethod codeMethod;
    private final ConstantPool cpool;
    private byte[] sink;
    private int offset;
    private List outstandingRefs = new ArrayList();
    private Map markedLabels = new HashMap();
    private Map localVariables = new HashMap();
    private int usedLocals;
    private int maxLocals;
    private Map resolvedParametrics;
    private List exceptionTable = new ArrayList();

    MethodRootContext(CodeClass cc, CodeMethod cm, ConstantPool cp) {
        this.resolvedParametrics = new HashMap();
        this.codeClass = cc;
        this.codeMethod = cm;
        this.cpool = cp;
        this.sink = new byte[65536];
        this.offset = 0;
        this.maxLocals = 0;
        this.usedLocals = 0;
    }

    @Override
    public CodeClass getCodeClass() {
        return this.codeClass;
    }

    @Override
    public CodeMethod getCodeMethod() {
        return this.codeMethod;
    }

    @Override
    public ConstantPool getConstants() {
        return this.cpool;
    }

    @Override
    public void writeByte(byte b) {
        this.sink[this.offset++] = b;
    }

    @Override
    public void writeShort(int i) {
        this.sink[this.offset++] = (byte)(i >> 8 & 0xFF);
        this.sink[this.offset++] = (byte)(i & 0xFF);
    }

    @Override
    public void writeShortAt(int pos, int i) {
        this.sink[pos] = (byte)(i >> 8 & 0xFF);
        this.sink[pos + 1] = (byte)(i & 0xFF);
    }

    @Override
    public void writeLabel(Label l) {
        this.outstandingRefs.add(new BranchFixup(l, this.getOffset(), this));
        this.writeShort(0);
    }

    @Override
    public void markLabel(Label l) throws CodeException {
        if (this.markedLabels.containsKey(l)) {
            throw new CodeException("Attempt to duplicate marked label");
        }
        this.markedLabels.put(l, new Integer(this.getOffset()));
    }

    @Override
    public int resolveLocal(LocalVariable lv) {
        Integer slot = (Integer)this.localVariables.get(lv);
        if (slot != null) {
            return slot;
        }
        int newLocal = this.usedLocals;
        this.usedLocals += lv.needSlots();
        this.setMaxLocals(this.usedLocals);
        this.localVariables.put(lv, new Integer(newLocal));
        return newLocal;
    }

    @Override
    public int resolveLocalNoCreate(LocalVariable lv) {
        Integer slot = (Integer)this.localVariables.get(lv);
        if (slot != null) {
            return slot;
        }
        return -1;
    }

    @Override
    public void registerParametricType(ParametricType type, CodeClass concreteType) throws CodeException {
        if (this.resolvedParametrics.containsKey(type)) {
            throw new CodeException("Failed to regiter parametric type " + type + ". Attempted to register for " + concreteType + " but it is already registered for " + this.resolvedParametrics.get(type));
        }
        if (!type.canAccept(concreteType)) {
            throw new CodeException("Parametric type is not compattible with concrete type: " + type + " : " + concreteType);
        }
        this.resolvedParametrics.put(type, concreteType);
    }

    @Override
    public CodeClass resolveParametricType(ParametricType type) throws CodeException {
        CodeClass cc = (CodeClass)this.resolvedParametrics.get(type);
        if (cc == null) {
            throw new CodeException("Can not resolve type: " + type);
        }
        return cc;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() throws CodeException {
        ListIterator li = this.outstandingRefs.listIterator();
        while (li.hasNext()) {
            OutstandingReference or = (OutstandingReference)li.next();
            Integer off = (Integer)this.markedLabels.get(or.getLabel());
            if (off != null) {
                or.resolve(off);
                continue;
            }
            throw new CodeException("Reference to label " + or.getLabel() + " still outstanding at top level");
        }
    }

    @Override
    public CodeContext subContext() {
        return new ChildContext(this);
    }

    @Override
    public void promoteOutstandingReference(OutstandingReference or) {
        this.outstandingRefs.add(or);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.sink, 0, this.offset);
    }

    @Override
    public void setMaxLocals(int newMax) {
        if (newMax > this.maxLocals) {
            this.maxLocals = newMax;
        }
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    @Override
    public int getUsedLocals() {
        return this.usedLocals;
    }

    @Override
    public void addExceptionTableEntry(Label startHandled, Label endHandled, CodeClass eClass, Label handler) {
        SimpleReference rStartHandled = new SimpleReference(startHandled);
        SimpleReference rEndHandled = new SimpleReference(endHandled);
        SimpleReference rHandler = new SimpleReference(handler);
        this.outstandingRefs.add(rStartHandled);
        this.outstandingRefs.add(rEndHandled);
        this.outstandingRefs.add(rHandler);
        this.addExceptionTableEntry(new ExceptionMemento(rStartHandled, rEndHandled, eClass, rHandler));
    }

    @Override
    public void addExceptionTableEntry(ExceptionMemento em) {
        this.exceptionTable.add(em);
    }

    public List getExceptionTable() {
        return Collections.unmodifiableList(this.exceptionTable);
    }
}

