/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class ShortInstruction
implements Instruction {
    private final byte opcode;
    private final int val;
    private final int delta;

    ShortInstruction(byte opcode, int val, int delta) {
        this.opcode = opcode;
        this.val = val;
        this.delta = delta;
    }

    @Override
    public void writeCode(CodeContext ctx) throws CodeException {
        ctx.writeByte(this.opcode);
        ctx.writeShort(this.val);
    }

    @Override
    public int stackDepth() {
        return Math.max(this.delta, 0);
    }

    @Override
    public int stackDelta() {
        return this.delta;
    }
}

