/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.n0pe.asadmin.AbstractAsAdminCmd;
import org.n0pe.asadmin.AsAdminCmdList;
import org.n0pe.asadmin.AsAdminException;
import org.n0pe.asadmin.IAsAdminCmd;
import org.n0pe.asadmin.IAsAdminConfig;

public class AsAdmin {
    private static final String ASADMIN_FAILED = "failed";
    private static final String OUTPUT_PREFIX = "[ASADMIN] ";
    private static Map instances;
    public static final String HOST_OPT = "--host";
    public static final String PORT_OPT = "--port";
    public static final String SECURE_OPT = "--secure";
    public static final String USER_OPT = "--user";
    public static final String PASSWORDFILE_OPT = "--passwordfile";
    public static String ASADMIN_COMMAND_NAME;
    private IAsAdminConfig config;

    public static AsAdmin getInstance(IAsAdminConfig config) {
        AsAdmin instance;
        if (instances == null) {
            instances = new HashMap(1);
        }
        if ((instance = (AsAdmin)instances.get(config)) == null) {
            instance = new AsAdmin(config);
            instances.put(config, instance);
        }
        return instance;
    }

    private AsAdmin(IAsAdminConfig config) {
        this.config = config;
    }

    public void run(AsAdminCmdList cmdList) throws AsAdminException {
        for (IAsAdminCmd cmd : cmdList) {
            this.run(cmd);
        }
    }

    public void run(IAsAdminCmd cmd) throws AsAdminException {
        try {
            Process proc;
            File gfBinPath = new File(this.config.getGlassfishHome() + File.separator + "bin");
            Object[] cmds = AsAdmin.buildProcessParams(cmd, this.config);
            cmds[0] = gfBinPath + File.separator + cmds[0];
            if (SystemUtils.IS_OS_WINDOWS) {
                String command = "\"\"" + StringUtils.join((Object[])cmds, (String)"\" \"") + "\"\"";
                Object[] windowsCommand = SystemUtils.IS_OS_WINDOWS_95 || SystemUtils.IS_OS_WINDOWS_98 || SystemUtils.IS_OS_WINDOWS_ME ? new String[]{"command.com", "/C", command} : new String[]{"cmd.exe", "/C", command};
                AsAdmin.outPrintln("Will run the following command: " + StringUtils.join((Object[])windowsCommand, (String)" "));
                proc = Runtime.getRuntime().exec((String[])windowsCommand);
            } else {
                AsAdmin.outPrintln("Will run the following command: " + StringUtils.join((Object[])cmds, (String)" "));
                proc = Runtime.getRuntime().exec((String[])cmds);
            }
            ProcessStreamGobbler errorGobbler = new ProcessStreamGobbler(cmd, proc.getErrorStream(), 1);
            ProcessStreamGobbler outputGobbler = new ProcessStreamGobbler(cmd, proc.getInputStream(), 0);
            errorGobbler.start();
            outputGobbler.start();
            int exitCode = proc.waitFor();
            if (exitCode != 0) {
                throw new AsAdminException("asadmin invocation failed and returned : " + String.valueOf(exitCode));
            }
        }
        catch (InterruptedException ex) {
            throw new AsAdminException("AsAdmin error occurred: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new AsAdminException("AsAdmin error occurred: " + ex.getMessage(), ex);
        }
    }

    public static String[] buildProcessParams(IAsAdminCmd cmd, IAsAdminConfig config) {
        ArrayList<String> pbParams = new ArrayList<String>();
        pbParams.add(ASADMIN_COMMAND_NAME);
        pbParams.add(cmd.getActionCommand());
        if (!(StringUtils.isEmpty((String)config.getHost()) || "start-domain".equals(cmd.getActionCommand()) || "stop-domain".equals(cmd.getActionCommand()) || "stop-database".equals(cmd.getActionCommand()) || "start-database".equals(cmd.getActionCommand()))) {
            pbParams.add(HOST_OPT);
            pbParams.add(config.getHost());
        }
        if (!(StringUtils.isEmpty((String)config.getPort()) || "start-domain".equals(cmd.getActionCommand()) || "stop-domain".equals(cmd.getActionCommand()) || "stop-database".equals(cmd.getActionCommand()) || "start-database".equals(cmd.getActionCommand()))) {
            pbParams.add(PORT_OPT);
            pbParams.add(config.getPort());
        }
        if (config.isSecure()) {
            pbParams.add(SECURE_OPT);
        }
        if (cmd.needCredentials()) {
            pbParams.add(USER_OPT);
            pbParams.add(config.getUser());
            pbParams.add(PASSWORDFILE_OPT);
            pbParams.add(config.getPasswordFile());
        }
        pbParams.addAll(Arrays.asList(cmd.getParameters()));
        return pbParams.toArray(new String[pbParams.size()]);
    }

    private static void outPrintln(String message) {
        System.out.print(OUTPUT_PREFIX);
        System.out.println(message);
    }

    private static void errPrintln(String message) {
        System.out.print(OUTPUT_PREFIX);
        System.out.println(message);
    }

    static {
        ASADMIN_COMMAND_NAME = SystemUtils.IS_OS_WINDOWS ? "asadmin.bat" : "asadmin";
    }

    private static class ProcessStreamGobbler
    extends Thread {
        private static final int OUTPUT = 0;
        private static final int ERROR = 1;
        private AbstractAsAdminCmd cmd;
        private InputStream is;
        private int type = 0;

        private ProcessStreamGobbler(IAsAdminCmd cmd, InputStream is, int type) {
            this.is = is;
            this.type = type;
            if (AbstractAsAdminCmd.class.isAssignableFrom(cmd.getClass())) {
                this.cmd = (AbstractAsAdminCmd)cmd;
            }
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    switch (this.type) {
                        case 0: {
                            if (this.cmd != null) {
                                this.cmd.appendStandardOutputLine(line);
                            }
                            AsAdmin.outPrintln("[OUTPUT] " + line);
                            break;
                        }
                        case 1: {
                            if (this.cmd != null) {
                                this.cmd.appendErrorOutputLine(line);
                            }
                            AsAdmin.errPrintln("[ERROR]  " + line);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

