/*
 * Copyright (c) 2010, Paul Merlin. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.n0pe.asadmin;

import java.util.Map;

/**
 * Configuration provider for AsAdmin.
 */
public interface IAsAdminConfig
{

    /**
     * @return A map of environment to use when forking the asadmin process.
     */
    Map<String, String> getEnvironmentVariables();

    /**
     * @return The glassfish home path.
     */
    String getGlassfishHome();

    /**
     * @return The username to use with asadmin.
     */
    String getUser();

    /**
     * @return The file where credentials are stored.
     */
    String getPasswordFile();

    /**
     * @return The glassfish host.
     */
    String getHost();

    /**
     * @return The glassfish port.
     */
    String getPort();

    /**
     * @return True if gf admin connection is secure.
     */
    boolean isSecure();

}
