/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.n0pe.asadmin.AbstractAsAdminCmd;
import org.n0pe.asadmin.Util;

public class CreateJdbcConnectionPool
extends AbstractAsAdminCmd {
    public static final String JDBC = "create-jdbc-connection-pool";
    public static final String DATA_SOURCE_OPT = "--datasourceclassname";
    public static final String RESTYPE_OPT = "--restype";
    public static final String PROPERTY_OPT = "--property";
    private String poolName;
    private String dataSource;
    private String restype;
    private Map properties;

    private CreateJdbcConnectionPool() {
    }

    public CreateJdbcConnectionPool(String poolName) {
        this.poolName = poolName;
    }

    public CreateJdbcConnectionPool withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public CreateJdbcConnectionPool withRestype(String restype) {
        this.restype = restype;
        return this;
    }

    public CreateJdbcConnectionPool addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return this;
    }

    public boolean needCredentials() {
        return true;
    }

    public String getActionCommand() {
        if (this.poolName == null) {
            throw new IllegalStateException();
        }
        return JDBC;
    }

    public String[] getParameters() {
        String[] params;
        if (this.dataSource == null || this.restype == null) {
            throw new IllegalStateException();
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            StringBuffer sw = new StringBuffer();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                sw.append(key).append("=").append(Util.quoteCommandArgument((String)this.properties.get(key)));
                if (!it.hasNext()) continue;
                sw.append(":");
            }
            params = new String[]{DATA_SOURCE_OPT, this.dataSource, RESTYPE_OPT, this.restype, PROPERTY_OPT, sw.toString(), this.poolName};
        } else {
            params = new String[]{DATA_SOURCE_OPT, this.dataSource, RESTYPE_OPT, this.restype, this.poolName};
        }
        return params;
    }
}

