/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

public final class FreePortFinder {
    public static final String LOOPBACK = "127.0.0.1";
    public static final String ALL_INTERFACES = "0.0.0.0";

    private FreePortFinder() {
    }

    public static boolean isFree(int port) {
        return FreePortFinder.isFree(null, port);
    }

    public static boolean isFree(InetAddress address, int port) {
        try {
            new ServerSocket(port, 1, address).close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static int findRandom() throws IOException {
        return FreePortFinder.findRandomOnIface(null);
    }

    public static int findWithPreference(int prefered) throws IOException {
        return FreePortFinder.findOnIfaceWithPreference(null, prefered);
    }

    public static int findRandomOnIface(InetAddress address) throws IOException {
        return FreePortFinder.findOnIfaceWithPreference(address, -1);
    }

    public static int findOnIfaceWithPreference(InetAddress address, int prefered) throws IOException {
        ServerSocket server = prefered > 0 ? new ServerSocket(prefered, 1, address) : new ServerSocket(0, 1, address);
        int port = server.getLocalPort();
        server.close();
        return port;
    }
}

