/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.Bayeux;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.server.BayeuxService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatService
extends BayeuxService {
    private final ConcurrentMap<String, Map<String, String>> _members = new ConcurrentHashMap();

    public ChatService(Bayeux bayeux) {
        super(bayeux, "chat");
        this.subscribe("/service/members", "handleMembership");
        this.subscribe("/service/privatechat", "privateChat");
    }

    public void handleMembership(Client client, Map<String, Object> data) {
        ConcurrentHashMap<String, String> newRoomMembers;
        String room = (String)data.get("room");
        ConcurrentHashMap<String, String> roomMembers = (ConcurrentHashMap<String, String>)this._members.get(room);
        if (roomMembers == null && (roomMembers = (Map)this._members.putIfAbsent(room, newRoomMembers = new ConcurrentHashMap<String, String>())) == null) {
            roomMembers = newRoomMembers;
        }
        ConcurrentHashMap<String, String> members = roomMembers;
        String userName = (String)data.get("user");
        if (userName != null) {
            members.put(userName, client.getId());
            client.addListener((ClientListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.broadcastMembers(members.keySet());
    }

    private void broadcastMembers(Set<String> members) {
        Channel channel = this.getBayeux().getChannel("/chat/members", false);
        if (channel != null) {
            channel.publish(this.getClient(), members, null);
        }
    }

    public void privateChat(Client client, Map<String, Object> data) {
        String roomName = (String)data.get("room");
        Map membersMap = (Map)this._members.get(roomName);
        String[] peerNames = ((String)data.get("peer")).split(",");
        ArrayList<Client> peers = new ArrayList<Client>(peerNames.length);
        for (String peerName : peerNames) {
            Client peer;
            String peerId = (String)membersMap.get(peerName);
            if (peerId == null || (peer = this.getBayeux().getClient(peerId)) == null) continue;
            peers.add(peer);
        }
        if (peers.size() > 0) {
            HashMap<String, Object> message = new HashMap<String, Object>();
            message.put("chat", data.get("chat"));
            message.put("user", data.get("user"));
            message.put("scope", "private");
            for (Client peer : peers) {
                peer.deliver(client, roomName, message, null);
            }
            client.deliver(this.getClient(), roomName, message, null);
        }
    }

    static /* synthetic */ void access$000(ChatService x0, Set x1) {
        x0.broadcastMembers(x1);
    }
}

