/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.annotation.AnnotationProcessor;
import org.cometd.annotation.Listener;
import org.cometd.annotation.Service;
import org.cometd.annotation.Session;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAnnotationProcessor
extends AnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientAnnotationProcessor.class);
    private final ConcurrentMap<Object, ClientSessionChannel.MessageListener> handshakeListeners = new ConcurrentHashMap<Object, ClientSessionChannel.MessageListener>();
    private final ConcurrentMap<Object, List<ListenerCallback>> listeners = new ConcurrentHashMap<Object, List<ListenerCallback>>();
    private final ConcurrentMap<Object, List<SubscriptionCallback>> subscribers = new ConcurrentHashMap<Object, List<SubscriptionCallback>>();
    private final ClientSession clientSession;
    private final Object[] injectables;

    public ClientAnnotationProcessor(ClientSession clientSession) {
        this(clientSession, new Object[0]);
    }

    public ClientAnnotationProcessor(ClientSession clientSession, Object ... injectables) {
        this.clientSession = clientSession;
        this.injectables = injectables;
    }

    public boolean process(Object bean) {
        this.processMetaHandshakeListener(bean);
        boolean result = this.processDependencies(bean);
        result |= this.processCallbacks(bean);
        return result |= this.processPostConstruct(bean);
    }

    private void processMetaHandshakeListener(Object bean) {
        MetaHandshakeListener listener;
        ClientSessionChannel.MessageListener existing;
        if (bean != null && (existing = this.handshakeListeners.putIfAbsent(bean, listener = new MetaHandshakeListener(bean))) == null) {
            this.clientSession.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)listener);
        }
    }

    public boolean processPostConstruct(Object bean) {
        return super.processPostConstruct(bean);
    }

    private boolean processCallbacks(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        if (!Modifier.isPublic(klass.getModifiers())) {
            throw new IllegalArgumentException("Service class " + klass.getName() + " must be public");
        }
        boolean result = this.processListener(bean);
        return result |= this.processSubscription(bean);
    }

    public boolean deprocess(Object bean) {
        this.deprocessMetaHandshakeListener(bean);
        boolean result = this.deprocessCallbacks(bean);
        return result |= this.processPreDestroy(bean);
    }

    private void deprocessMetaHandshakeListener(Object bean) {
        ClientSessionChannel.MessageListener listener = (ClientSessionChannel.MessageListener)this.handshakeListeners.remove(bean);
        if (listener != null) {
            this.clientSession.getChannel("/meta/handshake").removeListener((ClientSessionChannel.ClientSessionChannelListener)listener);
        }
    }

    public boolean deprocessCallbacks(Object bean) {
        boolean result = this.deprocessListener(bean);
        return result |= this.deprocessSubscription(bean);
    }

    public boolean processPreDestroy(Object bean) {
        return super.processPreDestroy(bean);
    }

    private boolean processDependencies(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = this.processInjectables(bean, List.of(this.injectables));
        return result |= this.processSession(bean, this.clientSession);
    }

    private boolean processSession(Object bean, ClientSession clientSession) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Session.class) == null || !field.getType().isAssignableFrom(clientSession.getClass())) continue;
                this.setField(bean, field, clientSession);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Injected {} to field {} on bean {}", new Object[]{clientSession, field, bean});
            }
        }
        List methods = this.findAnnotatedMethods(bean, Session.class);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(clientSession.getClass())) continue;
            this.invokePrivate(bean, method, new Object[]{clientSession});
            result = true;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Injected {} to method {} on bean {}", new Object[]{clientSession, method, bean});
        }
        return result;
    }

    private boolean processListener(Object bean) {
        Method[] methods;
        AnnotationProcessor.checkMethodsPublic((Object)bean, Listener.class);
        boolean result = false;
        for (Method method : methods = bean.getClass().getMethods()) {
            String[] channels;
            Listener listener;
            if (method.getDeclaringClass() == Object.class || (listener = method.getAnnotation(Listener.class)) == null) continue;
            List paramNames = this.processParameters(method);
            AnnotationProcessor.checkSignaturesMatch((Method)method, (Class[])ListenerCallback.signature, (List)paramNames);
            for (String channel : channels = listener.value()) {
                List existing;
                if (!ChannelId.isMeta((String)channel)) {
                    throw new IllegalArgumentException("Annotation @" + Listener.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) must specify a meta channel");
                }
                ChannelId channelId = new ChannelId(channel);
                if (channelId.isTemplate()) {
                    channel = (String)channelId.getWilds().get(0);
                }
                ListenerCallback listenerCallback = new ListenerCallback(bean, method, paramNames, channelId, channel);
                this.clientSession.getChannel(channel).addListener((ClientSessionChannel.ClientSessionChannelListener)listenerCallback);
                List<ListenerCallback> callbacks = (CopyOnWriteArrayList<ListenerCallback>)this.listeners.get(bean);
                if (callbacks == null && (existing = (List)this.listeners.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<ListenerCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(listenerCallback);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered listener for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
            }
        }
        return result;
    }

    private boolean deprocessListener(Object bean) {
        boolean result = false;
        List callbacks = (List)this.listeners.remove(bean);
        if (callbacks != null) {
            for (ListenerCallback callback : callbacks) {
                ClientSessionChannel channel = this.clientSession.getChannel(callback.subscription);
                if (channel == null) continue;
                channel.removeListener((ClientSessionChannel.ClientSessionChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    private boolean processSubscription(Object bean) {
        Method[] methods;
        AnnotationProcessor.checkMethodsPublic((Object)bean, Subscription.class);
        boolean result = false;
        for (Method method : methods = bean.getClass().getMethods()) {
            String[] channels;
            Subscription subscription;
            if (method.getDeclaringClass() == Object.class || (subscription = method.getAnnotation(Subscription.class)) == null) continue;
            List paramNames = this.processParameters(method);
            AnnotationProcessor.checkSignaturesMatch((Method)method, (Class[])SubscriptionCallback.signature, (List)paramNames);
            for (String channel : channels = subscription.value()) {
                List existing;
                List<SubscriptionCallback> callbacks;
                if (ChannelId.isMeta((String)channel)) {
                    throw new IllegalArgumentException("Annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) must specify a non meta channel");
                }
                ChannelId channelId = new ChannelId(channel);
                if (channelId.isTemplate()) {
                    channel = (String)channelId.getWilds().get(0);
                }
                SubscriptionCallback subscriptionCallback = new SubscriptionCallback(this.clientSession, bean, method, paramNames, channelId, channel);
                if (this.clientSession.isHandshook()) {
                    this.clientSession.getChannel(channel).subscribe((ClientSessionChannel.MessageListener)subscriptionCallback);
                }
                if ((callbacks = (CopyOnWriteArrayList<SubscriptionCallback>)this.subscribers.get(bean)) == null && (existing = (List)this.subscribers.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<SubscriptionCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(subscriptionCallback);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered subscriber for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
            }
        }
        return result;
    }

    private boolean deprocessSubscription(Object bean) {
        boolean result = false;
        List callbacks = (List)this.subscribers.remove(bean);
        if (callbacks != null) {
            for (SubscriptionCallback callback : callbacks) {
                this.clientSession.getChannel(callback.subscription).unsubscribe((ClientSessionChannel.MessageListener)callback);
                result = true;
            }
        }
        return result;
    }

    private class MetaHandshakeListener
    implements ClientSessionChannel.MessageListener {
        private final Object bean;

        public MetaHandshakeListener(Object bean) {
            this.bean = bean;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            List subscriptions;
            if (message.isSuccessful() && (subscriptions = (List)ClientAnnotationProcessor.this.subscribers.get(this.bean)) != null) {
                ClientAnnotationProcessor.this.clientSession.batch(() -> {
                    for (SubscriptionCallback subscription : subscriptions) {
                        subscription.subscribe();
                    }
                });
            }
        }
    }

    private static class ListenerCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final Object target;
        private final Method method;
        private final List<String> paramNames;
        private final ChannelId channelId;
        private final String subscription;

        private ListenerCallback(Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription) {
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Map matches = this.channelId.bind(message.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return;
            }
            Object[] args = new Object[1 + this.paramNames.size()];
            args[0] = message;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[1 + i] = matches.get(this.paramNames.get(i));
            }
            ClientAnnotationProcessor.callPublic((Object)this.target, (Method)this.method, (Object[])args);
        }
    }

    private static class SubscriptionCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final ClientSession clientSession;
        private final Object target;
        private final Method method;
        private final List<String> paramNames;
        private final ChannelId channelId;
        private final String subscription;

        public SubscriptionCallback(ClientSession clientSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription) {
            this.clientSession = clientSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Map matches = this.channelId.bind(message.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return;
            }
            Object[] args = new Object[1 + this.paramNames.size()];
            args[0] = message;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[1 + i] = matches.get(this.paramNames.get(i));
            }
            ClientAnnotationProcessor.callPublic((Object)this.target, (Method)this.method, (Object[])args);
        }

        private void subscribe() {
            this.clientSession.getChannel(this.subscription).subscribe((ClientSessionChannel.MessageListener)this);
        }
    }
}

