/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.cometd.annotation.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationProcessor.class);

    protected boolean processPostConstruct(Object bean) {
        if (bean == null) {
            return false;
        }
        List<Method> postConstructs = this.findLifeCycleMethods(bean, PostConstruct.class);
        boolean result = false;
        for (Method method : postConstructs) {
            this.invokePrivate(bean, method, new Object[0]);
            result = true;
        }
        return result;
    }

    protected boolean processPreDestroy(Object bean) {
        if (bean == null) {
            return false;
        }
        List<Method> preDestroys = this.findLifeCycleMethods(bean, PreDestroy.class);
        boolean result = false;
        for (Method method : preDestroys) {
            try {
                this.invokePrivate(bean, method, new Object[0]);
                result = true;
            }
            catch (RuntimeException x) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Exception while invoking @PreDestroy method " + method + ", ignoring", (Throwable)x);
            }
        }
        return result;
    }

    private List<Method> findLifeCycleMethods(Object bean, Class<? extends Annotation> lifeCycle) {
        ArrayList classes = new ArrayList();
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            classes.add(c);
        }
        Collections.reverse(classes);
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < classes.size(); ++i) {
            Method[] methods;
            Class c = (Class)classes.get(i);
            boolean foundInClass = false;
            for (Method method : methods = c.getDeclaredMethods()) {
                Annotation annotation = method.getAnnotation(lifeCycle);
                if (annotation == null) continue;
                if (foundInClass) {
                    throw new RuntimeException("Invalid @" + lifeCycle.getSimpleName() + " method " + method + ": another method with the same annotation exists");
                }
                foundInClass = true;
                if (method.getReturnType() != Void.TYPE) {
                    throw new RuntimeException("Invalid @" + lifeCycle.getSimpleName() + " method " + method + ": it must have void return type");
                }
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Invalid @" + lifeCycle.getSimpleName() + " method " + method + ": it must have no parameters");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException("Invalid @" + lifeCycle.getSimpleName() + " method " + method + ": it must not be static");
                }
                boolean overridden = false;
                for (int j = i + 1; j < classes.size(); ++j) {
                    try {
                        Class sc = (Class)classes.get(j);
                        sc.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        overridden = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (overridden) continue;
                result.add(method);
            }
        }
        Collections.reverse(result);
        return result;
    }

    protected List<Method> findAnnotatedMethods(Object bean, Class<? extends Annotation> annotationClass) {
        ArrayList classes = new ArrayList();
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            classes.add(c);
        }
        Collections.reverse(classes);
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < classes.size(); ++i) {
            Method[] methods;
            Class c = (Class)classes.get(i);
            for (Method method : methods = c.getDeclaredMethods()) {
                Annotation annotation = method.getAnnotation(annotationClass);
                if (annotation == null) continue;
                boolean overridden = false;
                for (int j = i + 1; j < classes.size(); ++j) {
                    try {
                        Class sc = (Class)classes.get(j);
                        sc.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        overridden = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (overridden) continue;
                result.add(method);
            }
        }
        Collections.reverse(result);
        return result;
    }

    protected List<String> processParameters(Method method) {
        Annotation[][] parametersAnnotations;
        ArrayList<String> result = new ArrayList<String>();
        Annotation[][] annotationArray = parametersAnnotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = annotationArray[i]) {
                if (!(parameterAnnotation instanceof Param)) continue;
                result.add(((Param)parameterAnnotation).value());
            }
        }
        return result;
    }

    protected Object invokePrivate(Object bean, Method method, Object ... args) {
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(bean, args);
            return object;
        }
        catch (InvocationTargetException x) {
            throw new RuntimeException(x.getCause());
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    protected static Object invokePublic(Object target, Method method, Object[] arguments) throws Throwable {
        try {
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException x) {
            throw x.getCause();
        }
    }

    protected static Object callPublic(Object target, Method method, Object ... arguments) {
        try {
            return AnnotationProcessor.invokePublic(target, method, arguments);
        }
        catch (Throwable x) {
            Class<?> klass = target.getClass();
            Logger logger = LoggerFactory.getLogger(klass);
            logger.info("Exception while invoking " + klass + "#" + method.getName() + "()", x);
            return null;
        }
    }

    protected Object getField(Object bean, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(bean);
            return object;
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected void setField(Object bean, Field field, Object value) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected static void checkMethodsPublic(Object bean, Class<? extends Annotation> annotationClass) {
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                Annotation annotation = method.getAnnotation(annotationClass);
                if (annotation == null || Modifier.isPublic(method.getModifiers())) continue;
                throw new IllegalArgumentException("@" + annotationClass.getSimpleName() + " method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) must be public");
            }
        }
    }

    protected static void checkSignaturesMatch(Method method, Class<?>[] expectedTypes, List<String> paramNames) {
        int i;
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != expectedTypes.length + paramNames.size()) {
            throw new IllegalArgumentException("Wrong number of parameters in service method: " + method.getName() + "(...)." + (paramTypes.length > 2 ? " Template parameters not annotated with @" + Param.class.getSimpleName() + " ?" : ""));
        }
        for (i = 0; i < expectedTypes.length; ++i) {
            Class<?> parameter;
            Class<?> expected = expectedTypes[i];
            if (expected == null || (parameter = paramTypes[i]).isAssignableFrom(expected)) continue;
            throw new IllegalArgumentException("Parameter type " + parameter.getName() + " must be instead " + expected.getName() + " in service method: " + method.getName() + "(...).");
        }
        for (i = 0; i < paramNames.size(); ++i) {
            Class<String> parameter = paramTypes[expectedTypes.length + i];
            if (parameter.isAssignableFrom(String.class)) continue;
            throw new IllegalArgumentException("Template parameter '" + paramNames.get(i) + "' must be of type " + String.class.getName() + " in service method: " + method.getName() + "(...).");
        }
    }

    protected boolean processInjectables(Object bean, List<Object> injectables) {
        boolean result = false;
        for (Object injectable : injectables) {
            result |= this.processInjectable(bean, injectable);
        }
        return result;
    }

    protected boolean processInjectable(Object bean, Object injectable) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Inject.class) == null || !field.getType().isAssignableFrom(injectable.getClass())) continue;
                Object value = this.getField(bean, field);
                if (value != null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Avoid injection of field {} on bean {}, it's already injected with {}", new Object[]{field, bean, value});
                    continue;
                }
                this.setField(bean, field, injectable);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Injected {} to field {} on bean {}", new Object[]{injectable, field, bean});
            }
        }
        List<Method> methods = this.findAnnotatedMethods(bean, Inject.class);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(injectable.getClass())) continue;
            this.invokePrivate(bean, method, injectable);
            result = true;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Injected {} to method {} on bean {}", new Object[]{injectable, method, bean});
        }
        return result;
    }
}

