/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation.server;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.cometd.annotation.server.ServerAnnotationProcessor;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.server.CometDServlet;
import org.eclipse.jetty.util.Loader;

public class AnnotationCometDServlet
extends CometDServlet {
    private final List<Object> services = new ArrayList<Object>();
    private volatile ServerAnnotationProcessor processor;

    public void init() throws ServletException {
        super.init();
        this.processor = this.newServerAnnotationProcessor((BayeuxServer)this.getBayeux());
        String servicesParam = this.getInitParameter("services");
        if (servicesParam != null && servicesParam.length() > 0) {
            for (String serviceClass : servicesParam.split(",")) {
                Object service = this.processService(this.processor, serviceClass.trim());
                this.services.add(service);
                this.registerService(service);
            }
        }
    }

    protected ServerAnnotationProcessor newServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        return new ServerAnnotationProcessor(bayeuxServer);
    }

    protected Object processService(ServerAnnotationProcessor processor, String serviceClassName) throws ServletException {
        try {
            Object service = this.newService(serviceClassName);
            processor.process(service);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Processed annotated service {}", service);
            }
            return service;
        }
        catch (Exception x) {
            this._logger.warn("Failed to create annotated service " + serviceClassName, (Throwable)x);
            throw new ServletException((Throwable)x);
        }
    }

    protected Object newService(String serviceClassName) throws Exception {
        return Loader.loadClass(((Object)((Object)this)).getClass(), (String)serviceClassName).newInstance();
    }

    protected void registerService(Object service) {
        this.getServletContext().setAttribute(service.getClass().getName(), service);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Registered annotated service {} in servlet context", service);
        }
    }

    public void destroy() {
        for (Object service : this.services) {
            this.deregisterService(service);
            this.deprocessService(this.processor, service);
        }
        super.destroy();
    }

    protected void deregisterService(Object service) {
        this.getServletContext().removeAttribute(service.getClass().getName());
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Deregistered annotated service {}", service);
        }
    }

    protected void deprocessService(ServerAnnotationProcessor processor, Object service) {
        processor.deprocess(service);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Deprocessed annotated service {}", service);
        }
    }

    public List<Object> getServices() {
        return this.services;
    }
}

