/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationProcessor {
    protected final Logger logger = Log.getLogger((String)this.getClass().getName());

    AnnotationProcessor() {
    }

    protected Object invokeMethod(Object bean, Method method, Object ... args) {
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(bean, args);
            return object;
        }
        catch (InvocationTargetException x) {
            throw new RuntimeException(x.getCause());
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    protected Method findGetterMethod(Class<?> klass, Method setter) {
        try {
            String getterName;
            Method getter;
            String setterPrefix = "set";
            String setterName = setter.getName();
            if (setterName.startsWith(setterPrefix) && (setterName.length() == setterPrefix.length() || Character.isUpperCase(setterName.charAt(setterPrefix.length()))) && (getter = klass.getDeclaredMethod(getterName = "get" + setterName.substring(setterPrefix.length()), new Class[0])).getReturnType() == setter.getParameterTypes()[0]) {
                return getter;
            }
            return null;
        }
        catch (NoSuchMethodException x) {
            return null;
        }
    }

    protected Object getField(Object bean, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(bean);
            return object;
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected void setField(Object bean, Field field, Object value) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected static boolean signaturesMatch(Class<?>[] candidate, Class<?>[] expected) {
        if (candidate.length != expected.length) {
            return false;
        }
        for (int i = 0; i < candidate.length; ++i) {
            Class<?> parameter = candidate[i];
            if (parameter.isAssignableFrom(expected[i])) continue;
            return false;
        }
        return true;
    }
}

