/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.java.annotation;

import javax.servlet.ServletException;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.java.annotation.ServerAnnotationProcessor;
import org.cometd.server.CometdServlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Logger;

public class AnnotationCometdServlet
extends CometdServlet {
    private static final long serialVersionUID = 2821068017364051087L;

    public void init() throws ServletException {
        super.init();
        String services = this.getInitParameter("services");
        if (services != null && services.length() > 0) {
            ServerAnnotationProcessor processor = new ServerAnnotationProcessor((BayeuxServer)this.getBayeux());
            for (String service : services.split(",")) {
                this.processService(processor, service.trim());
            }
        }
    }

    protected void processService(ServerAnnotationProcessor processor, String serviceClassName) throws ServletException {
        Logger logger = this.getBayeux().getLogger();
        try {
            Object service = Loader.loadClass(((Object)((Object)this)).getClass(), (String)serviceClassName).newInstance();
            processor.process(service);
            logger.info("Processed annotated service " + serviceClassName, new Object[0]);
        }
        catch (Exception x) {
            logger.warn("Failed to create annotated service " + serviceClassName, (Throwable)x);
            throw new ServletException((Throwable)x);
        }
    }
}

