/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.java.annotation.AnnotationProcessor;
import org.cometd.java.annotation.Configure;
import org.cometd.java.annotation.Listener;
import org.cometd.java.annotation.Service;
import org.cometd.java.annotation.Session;
import org.cometd.java.annotation.Subscription;

public class ServerAnnotationProcessor
extends AnnotationProcessor {
    private final ConcurrentMap<Object, LocalSession> sessions = new ConcurrentHashMap<Object, LocalSession>();
    private final ConcurrentMap<Object, List<ListenerCallback>> listeners = new ConcurrentHashMap<Object, List<ListenerCallback>>();
    private final ConcurrentMap<Object, List<SubscriptionCallback>> subscribers = new ConcurrentHashMap<Object, List<SubscriptionCallback>>();
    private final BayeuxServer bayeuxServer;

    public ServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        this.bayeuxServer = bayeuxServer;
    }

    public boolean process(Object bean) {
        boolean result = this.processDependencies(bean);
        result |= this.processConfigurations(bean);
        result |= this.processCallbacks(bean);
        return result |= this.processPostConstruct(bean);
    }

    public boolean processConfigurations(final Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            for (final Method method : methods = c.getDeclaredMethods()) {
                String[] channels;
                Configure configure = method.getAnnotation(Configure.class);
                if (configure == null) continue;
                result = true;
                for (String channel : channels = configure.value()) {
                    ConfigurableServerChannel.Initializer init = new ConfigurableServerChannel.Initializer(){

                        public void configureChannel(ConfigurableServerChannel channel) {
                            boolean flip = false;
                            try {
                                ServerAnnotationProcessor.this.logger.debug("Configure channel {} with method {} on bean {}", new Object[]{channel, method, bean});
                                if (!method.isAccessible()) {
                                    flip = true;
                                    method.setAccessible(true);
                                }
                                method.invoke(bean, channel);
                            }
                            catch (Exception x) {
                                throw new RuntimeException(x);
                            }
                            finally {
                                if (flip) {
                                    method.setAccessible(false);
                                }
                            }
                        }
                    };
                    boolean initialized = this.bayeuxServer.createIfAbsent(channel, new ConfigurableServerChannel.Initializer[]{init});
                    if (initialized) {
                        this.logger.debug("Channel {} already initialized. Not called method {} on bean {}", new Object[]{channel, method, bean});
                        continue;
                    }
                    if (configure.configureIfExists()) {
                        this.logger.debug("Configure channel {} with method {} on bean {}", new Object[]{channel, method, bean});
                        init.configureChannel((ConfigurableServerChannel)this.bayeuxServer.getChannel(channel));
                        continue;
                    }
                    if (!configure.errorIfExists()) continue;
                    throw new IllegalStateException("Channel already configured: " + channel);
                }
            }
        }
        return result;
    }

    public boolean processDependencies(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = this.processBayeux(bean);
        LocalSession session = this.findOrCreateLocalSession(bean, serviceAnnotation.value());
        return result |= this.processSession(bean, session);
    }

    public boolean processPostConstruct(Object bean) {
        return super.processPostConstruct(bean);
    }

    public boolean processCallbacks(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        LocalSession session = this.findOrCreateLocalSession(bean, serviceAnnotation.value());
        boolean result = this.processListener(bean, session);
        return result |= this.processSubscription(bean, session);
    }

    public boolean deprocess(Object bean) {
        boolean result = this.deprocessCallbacks(bean);
        return result |= this.processPreDestroy(bean);
    }

    public boolean deprocessCallbacks(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = this.deprocessListener(bean);
        return result |= this.deprocessSubscription(bean);
    }

    public boolean processPreDestroy(Object bean) {
        return super.processPreDestroy(bean);
    }

    private LocalSession findOrCreateLocalSession(Object bean, String name) {
        LocalSession session = (LocalSession)this.sessions.get(bean);
        if (session == null) {
            session = this.bayeuxServer.newLocalSession(name);
            LocalSession existing = this.sessions.putIfAbsent(bean, session);
            if (existing != null) {
                session = existing;
            } else {
                session.handshake();
            }
        }
        return session;
    }

    private boolean processBayeux(Object bean) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Inject.class) == null || !field.getType().isAssignableFrom(this.bayeuxServer.getClass())) continue;
                Object value = this.getField(bean, field);
                if (value != null) {
                    this.logger.debug("Avoid injection of field {} on bean {}, it's already injected with {}", new Object[]{field, bean, value});
                    continue;
                }
                this.setField(bean, field, this.bayeuxServer);
                result = true;
                this.logger.debug("Injected {} to field {} on bean {}", new Object[]{this.bayeuxServer, field, bean});
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                Object value;
                Class<?>[] parameterTypes;
                if (method.getAnnotation(Inject.class) == null || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(this.bayeuxServer.getClass())) continue;
                Method getter = this.findGetterMethod(c, method);
                if (getter != null && (value = this.invokeMethod(bean, getter, new Object[0])) != null) {
                    this.logger.debug("Avoid injection of method {} on bean {}, it's already injected with {}", new Object[]{method, bean, value});
                    continue;
                }
                this.invokeMethod(bean, method, this.bayeuxServer);
                result = true;
                this.logger.debug("Injected {} to method {} on bean {}", new Object[]{this.bayeuxServer, method, bean});
            }
        }
        return result;
    }

    private boolean processSession(Object bean, LocalSession localSession) {
        ServerSession serverSession = localSession.getServerSession();
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Session.class) == null) continue;
                LocalSession value = null;
                if (field.getType().isAssignableFrom(localSession.getClass())) {
                    value = localSession;
                } else if (field.getType().isAssignableFrom(serverSession.getClass())) {
                    value = serverSession;
                }
                if (value == null) continue;
                this.setField(bean, field, value);
                result = true;
                this.logger.debug("Injected {} to field {} on bean {}", new Object[]{value, field, bean});
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (method.getAnnotation(Session.class) == null || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                LocalSession value = null;
                if (parameterTypes[0].isAssignableFrom(localSession.getClass())) {
                    value = localSession;
                } else if (parameterTypes[0].isAssignableFrom(serverSession.getClass())) {
                    value = serverSession;
                }
                if (value == null) continue;
                this.invokeMethod(bean, method, value);
                result = true;
                this.logger.debug("Injected {} to method {} on bean {}", new Object[]{value, method, bean});
            }
        }
        return result;
    }

    private boolean processListener(Object bean, LocalSession localSession) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                String[] channels;
                Listener listener = method.getAnnotation(Listener.class);
                if (listener == null) continue;
                for (String channel : channels = listener.value()) {
                    List existing;
                    this.bayeuxServer.createIfAbsent(channel, new ConfigurableServerChannel.Initializer[0]);
                    ListenerCallback listenerCallback = new ListenerCallback(localSession, bean, method, channel, listener.receiveOwnPublishes());
                    this.bayeuxServer.getChannel(channel).addListener((ServerChannel.ServerChannelListener)listenerCallback);
                    List<ListenerCallback> callbacks = (CopyOnWriteArrayList<ListenerCallback>)this.listeners.get(bean);
                    if (callbacks == null && (existing = (List)this.listeners.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<ListenerCallback>())) != null) {
                        callbacks = existing;
                    }
                    callbacks.add(listenerCallback);
                    result = true;
                    this.logger.debug("Registered listener for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
                }
            }
        }
        return result;
    }

    private boolean deprocessListener(Object bean) {
        boolean result = false;
        List callbacks = (List)this.listeners.get(bean);
        if (callbacks != null) {
            for (ListenerCallback callback : callbacks) {
                ServerChannel channel = this.bayeuxServer.getChannel(callback.channel);
                if (channel == null) continue;
                channel.removeListener((ServerChannel.ServerChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    private boolean processSubscription(Object bean, LocalSession localSession) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                String[] channels;
                Subscription subscription = method.getAnnotation(Subscription.class);
                if (subscription == null) continue;
                for (String channel : channels = subscription.value()) {
                    List existing;
                    SubscriptionCallback subscriptionCallback = new SubscriptionCallback(localSession, bean, method, channel);
                    localSession.getChannel(channel).subscribe((ClientSessionChannel.MessageListener)subscriptionCallback);
                    List<SubscriptionCallback> callbacks = (CopyOnWriteArrayList<SubscriptionCallback>)this.subscribers.get(bean);
                    if (callbacks == null && (existing = (List)this.subscribers.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<SubscriptionCallback>())) != null) {
                        callbacks = existing;
                    }
                    callbacks.add(subscriptionCallback);
                    result = true;
                    this.logger.debug("Registered subscriber for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
                }
            }
        }
        return result;
    }

    private boolean deprocessSubscription(Object bean) {
        boolean result = false;
        List callbacks = (List)this.subscribers.get(bean);
        if (callbacks != null) {
            for (SubscriptionCallback callback : callbacks) {
                callback.localSession.getChannel(callback.channel).unsubscribe((ClientSessionChannel.MessageListener)callback);
                result = true;
            }
        }
        return result;
    }

    private static class SubscriptionCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final String channel;

        public SubscriptionCallback(LocalSession localSession, Object target, Method method, String channel) {
            Class<?>[] parameters = method.getParameterTypes();
            if (!AnnotationProcessor.signaturesMatch(parameters, signature)) {
                throw new IllegalArgumentException("Wrong method signature for method " + method);
            }
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.channel = channel;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            boolean accessible = this.method.isAccessible();
            try {
                this.method.setAccessible(true);
                this.method.invoke(this.target, message);
            }
            catch (InvocationTargetException x) {
                throw new RuntimeException(x.getCause());
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException(x);
            }
            finally {
                this.method.setAccessible(accessible);
            }
        }
    }

    private static class ListenerCallback
    implements ServerChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{ServerSession.class, ServerMessage.Mutable.class};
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final String channel;
        private final boolean receiveOwnPublishes;

        private ListenerCallback(LocalSession localSession, Object target, Method method, String channel, boolean receiveOwnPublishes) {
            Class<?>[] parameters = method.getParameterTypes();
            if (!AnnotationProcessor.signaturesMatch(parameters, signature)) {
                throw new IllegalArgumentException("Wrong method signature for method " + method);
            }
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.channel = channel;
            this.receiveOwnPublishes = receiveOwnPublishes;
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (from == this.localSession.getServerSession() && !this.receiveOwnPublishes) {
                return true;
            }
            boolean accessible = this.method.isAccessible();
            try {
                this.method.setAccessible(true);
                Object result = this.method.invoke(this.target, from, message);
                boolean bl = result != Boolean.FALSE;
                return bl;
            }
            catch (InvocationTargetException x) {
                throw new RuntimeException(x.getCause());
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException(x);
            }
            finally {
                this.method.setAccessible(accessible);
            }
        }
    }
}

