/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.java.annotation;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.java.annotation.ServerAnnotationProcessor;
import org.cometd.server.CometdServlet;
import org.eclipse.jetty.util.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCometdServlet
extends CometdServlet {
    private final List<Object> services = new ArrayList<Object>();
    private volatile ServerAnnotationProcessor processor;

    public void init() throws ServletException {
        super.init();
        this.processor = this.newServerAnnotationProcessor((BayeuxServer)this.getBayeux());
        String servicesParam = this.getInitParameter("services");
        if (servicesParam != null && servicesParam.length() > 0) {
            for (String serviceClass : servicesParam.split(",")) {
                Object service = this.processService(this.processor, serviceClass.trim());
                this.services.add(service);
            }
        }
    }

    protected ServerAnnotationProcessor newServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        return new ServerAnnotationProcessor(bayeuxServer);
    }

    protected Object processService(ServerAnnotationProcessor processor, String serviceClassName) throws ServletException {
        try {
            Object service = this.newService(serviceClassName);
            processor.process(service);
            this._logger.info("Processed annotated service {}", service);
            return service;
        }
        catch (Exception x) {
            this._logger.warn("Failed to create annotated service " + serviceClassName, (Throwable)x);
            throw new ServletException((Throwable)x);
        }
    }

    protected Object newService(String serviceClassName) throws Exception {
        return Loader.loadClass(((Object)((Object)this)).getClass(), (String)serviceClassName).newInstance();
    }

    public void destroy() {
        for (Object service : this.services) {
            this.deprocessService(this.processor, service);
        }
        super.destroy();
    }

    protected void deprocessService(ServerAnnotationProcessor processor, Object service) {
        processor.deprocess(service);
        this._logger.info("Deprocessed annotated service {}", service);
    }

    protected List<Object> getServices() {
        return this.services;
    }
}

