/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.annotation.AnnotationProcessor;
import org.cometd.annotation.Listener;
import org.cometd.annotation.Service;
import org.cometd.annotation.Session;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;

public class ClientAnnotationProcessor
extends AnnotationProcessor {
    private final ConcurrentMap<Object, List<ListenerCallback>> listeners = new ConcurrentHashMap<Object, List<ListenerCallback>>();
    private final ConcurrentMap<Object, List<SubscriptionCallback>> subscribers = new ConcurrentHashMap<Object, List<SubscriptionCallback>>();
    private final ClientSession clientSession;
    private final Object[] injectables;

    public ClientAnnotationProcessor(ClientSession clientSession) {
        this(clientSession, new Object[0]);
    }

    public ClientAnnotationProcessor(ClientSession clientSession, Object ... injectables) {
        this.clientSession = clientSession;
        this.injectables = injectables;
    }

    public boolean process(Object bean) {
        boolean result = this.processDependencies(bean);
        result |= this.processCallbacks(bean);
        return result |= this.processPostConstruct(bean);
    }

    public boolean processPostConstruct(Object bean) {
        return super.processPostConstruct(bean);
    }

    private boolean processCallbacks(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        if (!Modifier.isPublic(klass.getModifiers())) {
            throw new IllegalArgumentException("Service class '" + klass.getName() + "' must be public");
        }
        boolean result = this.processListener(bean);
        return result |= this.processSubscription(bean);
    }

    public boolean deprocess(Object bean) {
        boolean result = this.deprocessCallbacks(bean);
        return result |= this.processPreDestroy(bean);
    }

    public boolean deprocessCallbacks(Object bean) {
        boolean result = this.deprocessListener(bean);
        return result |= this.deprocessSubscription(bean);
    }

    public boolean processPreDestroy(Object bean) {
        return super.processPreDestroy(bean);
    }

    private boolean processDependencies(Object bean) {
        if (bean == null) {
            return false;
        }
        Class<?> klass = bean.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = this.processInjectables(bean, Arrays.asList(this.injectables));
        return result |= this.processSession(bean, this.clientSession);
    }

    private boolean processSession(Object bean, ClientSession clientSession) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Session.class) == null || !field.getType().isAssignableFrom(clientSession.getClass())) continue;
                this.setField(bean, field, clientSession);
                result = true;
                this.logger.debug("Injected {} to field {} on bean {}", new Object[]{clientSession, field, bean});
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (method.getAnnotation(Session.class) == null || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(clientSession.getClass())) continue;
                this.invokeMethod(bean, method, clientSession);
                result = true;
                this.logger.debug("Injected {} to method {} on bean {}", new Object[]{clientSession, method, bean});
            }
        }
        return result;
    }

    private boolean processListener(Object bean) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                String[] channels;
                Listener listener = method.getAnnotation(Listener.class);
                if (listener == null) continue;
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException("Service method '" + method.getName() + "' in class '" + method.getDeclaringClass().getName() + "' must be public");
                }
                for (String channel : channels = listener.value()) {
                    List existing;
                    ListenerCallback listenerCallback = new ListenerCallback(bean, method, channel);
                    this.clientSession.getChannel(channel).addListener((ClientSessionChannel.ClientSessionChannelListener)listenerCallback);
                    List<ListenerCallback> callbacks = (CopyOnWriteArrayList<ListenerCallback>)this.listeners.get(bean);
                    if (callbacks == null && (existing = (List)this.listeners.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<ListenerCallback>())) != null) {
                        callbacks = existing;
                    }
                    callbacks.add(listenerCallback);
                    result = true;
                    this.logger.debug("Registered listener for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
                }
            }
        }
        return result;
    }

    private boolean deprocessListener(Object bean) {
        boolean result = false;
        List callbacks = (List)this.listeners.get(bean);
        if (callbacks != null) {
            for (ListenerCallback callback : callbacks) {
                ClientSessionChannel channel = this.clientSession.getChannel(callback.channel);
                if (channel == null) continue;
                channel.removeListener((ClientSessionChannel.ClientSessionChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    private boolean processSubscription(Object bean) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                String[] channels;
                Subscription subscription = method.getAnnotation(Subscription.class);
                if (subscription == null) continue;
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException("Service method '" + method.getName() + "' in class '" + method.getDeclaringClass().getName() + "' must be public");
                }
                for (String channel : channels = subscription.value()) {
                    List existing;
                    SubscriptionCallback subscriptionCallback = new SubscriptionCallback(this.clientSession, bean, method, channel);
                    if (this.clientSession.isHandshook()) {
                        this.clientSession.getChannel(channel).subscribe((ClientSessionChannel.MessageListener)subscriptionCallback);
                    } else {
                        this.clientSession.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)subscriptionCallback);
                    }
                    List<SubscriptionCallback> callbacks = (CopyOnWriteArrayList<SubscriptionCallback>)this.subscribers.get(bean);
                    if (callbacks == null && (existing = (List)this.subscribers.putIfAbsent(bean, callbacks = new CopyOnWriteArrayList<SubscriptionCallback>())) != null) {
                        callbacks = existing;
                    }
                    callbacks.add(subscriptionCallback);
                    result = true;
                    this.logger.debug("Registered subscriber for channel {} to method {} on bean {}", new Object[]{channel, method, bean});
                }
            }
        }
        return result;
    }

    private boolean deprocessSubscription(Object bean) {
        boolean result = false;
        List callbacks = (List)this.subscribers.get(bean);
        if (callbacks != null) {
            for (SubscriptionCallback callback : callbacks) {
                this.clientSession.getChannel(callback.channel).unsubscribe((ClientSessionChannel.MessageListener)callback);
                result = true;
            }
        }
        return result;
    }

    private static class SubscriptionCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final ClientSession clientSession;
        private final Object target;
        private final Method method;
        private final String channel;

        public SubscriptionCallback(ClientSession clientSession, Object target, Method method, String channel) {
            Class<?>[] parameters = method.getParameterTypes();
            if (!AnnotationProcessor.signaturesMatch(parameters, signature)) {
                throw new IllegalArgumentException("Wrong method signature for method " + method);
            }
            if (ChannelId.isMeta((String)channel)) {
                throw new IllegalArgumentException("Annotation @Subscription on method " + method + " must specify a non meta channel");
            }
            this.clientSession = clientSession;
            this.target = target;
            this.method = method;
            this.channel = channel;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            if ("/meta/handshake".equals(channel.getId())) {
                if (message.isSuccessful()) {
                    this.subscribe();
                }
            } else {
                this.forward(message);
            }
        }

        private void subscribe() {
            this.clientSession.getChannel(this.channel).subscribe((ClientSessionChannel.MessageListener)this);
            this.clientSession.getChannel("/meta/handshake").removeListener((ClientSessionChannel.ClientSessionChannelListener)this);
        }

        private void forward(Message message) {
            try {
                this.method.invoke(this.target, message);
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private static class ListenerCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final Object target;
        private final Method method;
        private final String channel;

        private ListenerCallback(Object target, Method method, String channel) {
            Class<?>[] parameters = method.getParameterTypes();
            if (!AnnotationProcessor.signaturesMatch(parameters, signature)) {
                throw new IllegalArgumentException("Wrong method signature for method " + method);
            }
            if (!ChannelId.isMeta((String)channel)) {
                throw new IllegalArgumentException("Annotation @Listener on method " + method + " must specify a meta channel");
            }
            this.target = target;
            this.method = method;
            this.channel = channel;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            try {
                this.method.invoke(this.target, message);
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

