/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationProcessor {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    AnnotationProcessor() {
    }

    protected boolean processPostConstruct(Object bean) {
        if (bean == null) {
            return false;
        }
        ArrayList<Method> postConstructs = new ArrayList<Method>();
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            boolean foundInClass = false;
            for (Method method : methods = c.getDeclaredMethods()) {
                PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
                if (postConstruct == null) continue;
                if (foundInClass) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": another method with the same annotation exists");
                }
                foundInClass = true;
                if (method.getReturnType() != Void.TYPE) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": it must have void return type");
                }
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": it must have no parameters");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": it must not be static");
                }
                postConstructs.add(method);
            }
        }
        Collections.reverse(postConstructs);
        boolean result = false;
        for (Method method : postConstructs) {
            this.invokeMethod(bean, method, new Object[0]);
            result = true;
        }
        return result;
    }

    protected boolean processPreDestroy(Object bean) {
        if (bean == null) {
            return false;
        }
        ArrayList<Method> preDestroys = new ArrayList<Method>();
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            boolean foundInClass = false;
            for (Method method : methods = c.getDeclaredMethods()) {
                PreDestroy preDestroy = method.getAnnotation(PreDestroy.class);
                if (preDestroy == null) continue;
                if (foundInClass) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": another method with the same annotation exists");
                }
                foundInClass = true;
                if (method.getReturnType() != Void.TYPE) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": it must have void return type");
                }
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": it must have no parameters");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": it must not be static");
                }
                preDestroys.add(method);
            }
        }
        boolean result = false;
        for (Method method : preDestroys) {
            try {
                this.invokeMethod(bean, method, new Object[0]);
                result = true;
            }
            catch (RuntimeException x) {
                this.logger.debug("Exception while invoking @PreDestroy method " + method + ", ignoring", (Throwable)x);
            }
        }
        return result;
    }

    protected Object invokeMethod(Object bean, Method method, Object ... args) {
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(bean, args);
            return object;
        }
        catch (InvocationTargetException x) {
            throw new RuntimeException(x.getCause());
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    protected Method findGetterMethod(Class<?> klass, Method setter) {
        try {
            String getterName;
            Method getter;
            String setterPrefix = "set";
            String setterName = setter.getName();
            if (setterName.startsWith(setterPrefix) && (setterName.length() == setterPrefix.length() || Character.isUpperCase(setterName.charAt(setterPrefix.length()))) && (getter = klass.getDeclaredMethod(getterName = "get" + setterName.substring(setterPrefix.length()), new Class[0])).getReturnType() == setter.getParameterTypes()[0]) {
                return getter;
            }
            return null;
        }
        catch (NoSuchMethodException x) {
            return null;
        }
    }

    protected Object getField(Object bean, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(bean);
            return object;
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected void setField(Object bean, Field field, Object value) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected static boolean signaturesMatch(Class<?>[] candidate, Class<?>[] expected) {
        if (candidate.length != expected.length) {
            return false;
        }
        for (int i = 0; i < candidate.length; ++i) {
            Class<?> parameter = candidate[i];
            if (parameter.isAssignableFrom(expected[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean processInjectables(Object bean, List<Object> injectables) {
        boolean result = false;
        for (Object injectable : injectables) {
            result |= this.processInjectable(bean, injectable);
        }
        return result;
    }

    protected boolean processInjectable(Object bean, Object injectable) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Inject.class) == null || !field.getType().isAssignableFrom(injectable.getClass())) continue;
                Object value = this.getField(bean, field);
                if (value != null) {
                    this.logger.debug("Avoid injection of field {} on bean {}, it's already injected with {}", new Object[]{field, bean, value});
                    continue;
                }
                this.setField(bean, field, injectable);
                result = true;
                this.logger.debug("Injected {} to field {} on bean {}", new Object[]{injectable, field, bean});
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                Object value;
                Class<?>[] parameterTypes;
                if (method.getAnnotation(Inject.class) == null || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(injectable.getClass())) continue;
                Method getter = this.findGetterMethod(c, method);
                if (getter != null && (value = this.invokeMethod(bean, getter, new Object[0])) != null) {
                    this.logger.debug("Avoid injection of method {} on bean {}, it's already injected with {}", new Object[]{method, bean, value});
                    continue;
                }
                this.invokeMethod(bean, method, injectable);
                result = true;
                this.logger.debug("Injected {} to method {} on bean {}", new Object[]{injectable, method, bean});
            }
        }
        return result;
    }
}

